// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * Base class for the {@code Model} and the {@code Profile} objects.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class ModelBase
    implements Serializable, InputLocationTracker
{
    /**
     * @deprecated Use {@link #subprojects} instead.
     */
    @Deprecated(since = "4.0.0")
    final List<String> modules;
    /**
     * The subprojects (formerly called modules) to build as a part of this
     * project. Each subproject listed is a relative path to the directory containing the subproject.
     * To be consistent with the way default URLs are calculated from parent, it is recommended
     * to have subproject names match artifact ids.
     */
    final List<String> subprojects;
    /**
     * Distribution information for a project that enables deployment of the site
     * and artifacts to remote web servers and repositories respectively.
     */
    final DistributionManagement distributionManagement;
    /**
     * Properties that can be used throughout the POM as a substitution, and
     * are used as filters in resources if enabled.
     * The format is {@code <name>value</name>}.
     */
    final Map<String, String> properties;
    /**
     * Default dependency information for projects that inherit from this one. The
     * dependencies in this section are not immediately resolved. Instead, when a POM derived
     * from this one declares a dependency described by a matching groupId and artifactId, the
     * version and other values from this section are used for that dependency if they were not
     * already specified.
     */
    final DependencyManagement dependencyManagement;
    /**
     * This element describes all the dependencies associated with a project.
     * These dependencies are used to construct a classpath for your
     * project during the build process. They are automatically downloaded from the
     * repositories defined in this project.
     * 
     * @see <a href="https://maven.apache.org/guides/introduction/introduction-to-dependency-mechanism.html">Dependency mechanism</a>
     */
    final List<Dependency> dependencies;
    /**
     * The lists of the remote repositories for discovering dependencies and
     * extensions.
     */
    final List<Repository> repositories;
    /**
     * The lists of the remote repositories for discovering plugins for builds and
     * reports.
     */
    final List<Repository> pluginRepositories;
    /**
     * This element includes the specification of report plugins to use
     * to generate the reports on the Maven-generated site.
     * These reports will be run when a user executes {@code mvn site}.
     * All the reports will be included in the navigation bar for browsing.
     */
    final Reporting reporting;
    /** Locations */
    final Map<Object, InputLocation> locations;
    /** Location tracking */
    final InputLocation importedFrom;

    /**
      * Constructor for this class, to be called from its subclasses and {@link Builder}.
      * @see Builder#build()
      */
    protected ModelBase(Builder builder) {
        this.modules = ImmutableCollections.copy(builder.modules != null ? builder.modules : (builder.base != null ? builder.base.modules : null));
        this.subprojects = ImmutableCollections.copy(builder.subprojects != null ? builder.subprojects : (builder.base != null ? builder.base.subprojects : null));
        this.distributionManagement = builder.distributionManagement != null ? builder.distributionManagement : (builder.base != null ? builder.base.distributionManagement : null);
        this.properties = ImmutableCollections.copy(builder.properties != null ? builder.properties : (builder.base != null ? builder.base.properties : null));
        this.dependencyManagement = builder.dependencyManagement != null ? builder.dependencyManagement : (builder.base != null ? builder.base.dependencyManagement : null);
        this.dependencies = ImmutableCollections.copy(builder.dependencies != null ? builder.dependencies : (builder.base != null ? builder.base.dependencies : null));
        this.repositories = ImmutableCollections.copy(builder.repositories != null ? builder.repositories : (builder.base != null ? builder.base.repositories : null));
        this.pluginRepositories = ImmutableCollections.copy(builder.pluginRepositories != null ? builder.pluginRepositories : (builder.base != null ? builder.base.pluginRepositories : null));
        this.reporting = builder.reporting != null ? builder.reporting : (builder.base != null ? builder.base.reporting : null);
        this.locations = builder.computeLocations();
        this.importedFrom = builder.importedFrom;
    }

    /**
     * @deprecated Use {@link #subprojects} instead.
     *
     * @return a {@code List<String>}
     */
    @Deprecated(since = "4.0.0")
    @Nonnull
    public List<String> getModules() {
        return this.modules;
    }

    /**
     * The subprojects (formerly called modules) to build as a part of this
     * project. Each subproject listed is a relative path to the directory containing the subproject.
     * To be consistent with the way default URLs are calculated from parent, it is recommended
     * to have subproject names match artifact ids.
     *
     * @return a {@code List<String>}
     */
    @Nonnull
    public List<String> getSubprojects() {
        return this.subprojects;
    }

    /**
     * Distribution information for a project that enables deployment of the site
     * and artifacts to remote web servers and repositories respectively.
     *
     * @return a {@code DistributionManagement}
     */
    public DistributionManagement getDistributionManagement() {
        return this.distributionManagement;
    }

    /**
     * Properties that can be used throughout the POM as a substitution, and
     * are used as filters in resources if enabled.
     * The format is {@code <name>value</name>}.
     *
     * @return a {@code Map<String, String>}
     */
    @Nonnull
    public Map<String, String> getProperties() {
        return this.properties;
    }

    /**
     * Default dependency information for projects that inherit from this one. The
     * dependencies in this section are not immediately resolved. Instead, when a POM derived
     * from this one declares a dependency described by a matching groupId and artifactId, the
     * version and other values from this section are used for that dependency if they were not
     * already specified.
     *
     * @return a {@code DependencyManagement}
     */
    public DependencyManagement getDependencyManagement() {
        return this.dependencyManagement;
    }

    /**
     * This element describes all the dependencies associated with a project.
     * These dependencies are used to construct a classpath for your
     * project during the build process. They are automatically downloaded from the
     * repositories defined in this project.
     * 
     * @see <a href="https://maven.apache.org/guides/introduction/introduction-to-dependency-mechanism.html">Dependency mechanism</a>
     *
     * @return a {@code List<Dependency>}
     */
    @Nonnull
    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    /**
     * The lists of the remote repositories for discovering dependencies and
     * extensions.
     *
     * @return a {@code List<Repository>}
     */
    @Nonnull
    public List<Repository> getRepositories() {
        return this.repositories;
    }

    /**
     * The lists of the remote repositories for discovering plugins for builds and
     * reports.
     *
     * @return a {@code List<Repository>}
     */
    @Nonnull
    public List<Repository> getPluginRepositories() {
        return this.pluginRepositories;
    }

    /**
     * This element includes the specification of report plugins to use
     * to generate the reports on the Maven-generated site.
     * These reports will be run when a user executes {@code mvn site}.
     * All the reports will be included in the navigation bar for browsing.
     *
     * @return a {@code Reporting}
     */
    public Reporting getReporting() {
        return this.reporting;
    }

    /**
     * Gets the location of the specified field in the input source.
     *
     * @param key the key of the field, must not be {@code null}
     * @return the location of the field in the input source or {@code null} if unknown
     * @throws NullPointerException if {@code key} is {@code null}
     */
    public InputLocation getLocation(Object key) {
        Objects.requireNonNull(key, "key");
        return locations.get(key);
    }

    /**
     * Gets the keys of the locations of the input source.
     */
    public Set<Object> getLocationKeys() {
        return locations.keySet();
    }

    protected Stream<Object> getLocationKeyStream() {
        return locations.keySet().stream();
    }

    /**
     * Gets the input location that caused this model to be read.
     */
    public InputLocation getImportedFrom() {
        return importedFrom;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with() {
        return newBuilder(this);
    }
    /**
     * Creates a new {@code ModelBase} instance using the specified modules.
     *
     * @param modules the new {@code Collection<String>} to use
     * @return a {@code ModelBase} with the specified modules
     */
    @Deprecated(since = "4.0.0")
    @Nonnull
    public ModelBase withModules(Collection<String> modules) {
        return newBuilder(this, true).modules(modules).build();
    }
    /**
     * Creates a new {@code ModelBase} instance using the specified subprojects.
     *
     * @param subprojects the new {@code Collection<String>} to use
     * @return a {@code ModelBase} with the specified subprojects
     */
    @Nonnull
    public ModelBase withSubprojects(Collection<String> subprojects) {
        return newBuilder(this, true).subprojects(subprojects).build();
    }
    /**
     * Creates a new {@code ModelBase} instance using the specified distributionManagement.
     *
     * @param distributionManagement the new {@code DistributionManagement} to use
     * @return a {@code ModelBase} with the specified distributionManagement
     */
    @Nonnull
    public ModelBase withDistributionManagement(DistributionManagement distributionManagement) {
        return newBuilder(this, true).distributionManagement(distributionManagement).build();
    }
    /**
     * Creates a new {@code ModelBase} instance using the specified properties.
     *
     * @param properties the new {@code Map<String, String>} to use
     * @return a {@code ModelBase} with the specified properties
     */
    @Nonnull
    public ModelBase withProperties(Map<String, String> properties) {
        return newBuilder(this, true).properties(properties).build();
    }
    /**
     * Creates a new {@code ModelBase} instance using the specified dependencyManagement.
     *
     * @param dependencyManagement the new {@code DependencyManagement} to use
     * @return a {@code ModelBase} with the specified dependencyManagement
     */
    @Nonnull
    public ModelBase withDependencyManagement(DependencyManagement dependencyManagement) {
        return newBuilder(this, true).dependencyManagement(dependencyManagement).build();
    }
    /**
     * Creates a new {@code ModelBase} instance using the specified dependencies.
     *
     * @param dependencies the new {@code Collection<Dependency>} to use
     * @return a {@code ModelBase} with the specified dependencies
     */
    @Nonnull
    public ModelBase withDependencies(Collection<Dependency> dependencies) {
        return newBuilder(this, true).dependencies(dependencies).build();
    }
    /**
     * Creates a new {@code ModelBase} instance using the specified repositories.
     *
     * @param repositories the new {@code Collection<Repository>} to use
     * @return a {@code ModelBase} with the specified repositories
     */
    @Nonnull
    public ModelBase withRepositories(Collection<Repository> repositories) {
        return newBuilder(this, true).repositories(repositories).build();
    }
    /**
     * Creates a new {@code ModelBase} instance using the specified pluginRepositories.
     *
     * @param pluginRepositories the new {@code Collection<Repository>} to use
     * @return a {@code ModelBase} with the specified pluginRepositories
     */
    @Nonnull
    public ModelBase withPluginRepositories(Collection<Repository> pluginRepositories) {
        return newBuilder(this, true).pluginRepositories(pluginRepositories).build();
    }
    /**
     * Creates a new {@code ModelBase} instance using the specified reporting.
     *
     * @param reporting the new {@code Reporting} to use
     * @return a {@code ModelBase} with the specified reporting
     */
    @Nonnull
    public ModelBase withReporting(Reporting reporting) {
        return newBuilder(this, true).reporting(reporting).build();
    }

    /**
     * Creates a new {@code ModelBase} instance.
     * Equivalent to {@code newInstance(true)}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code ModelBase}
     */
    @Nonnull
    public static ModelBase newInstance() {
        return newInstance(true);
    }

    /**
     * Creates a new {@code ModelBase} instance using default values or not.
     * Equivalent to {@code newBuilder(withDefaults).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code ModelBase}
     */
    @Nonnull
    public static ModelBase newInstance(boolean withDefaults) {
        return newBuilder(withDefaults).build();
    }

    /**
     * Creates a new {@code ModelBase} builder instance.
     * Equivalent to {@code newBuilder(true)}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder() {
        return newBuilder(true);
    }

    /**
     * Creates a new {@code ModelBase} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    /**
     * Creates a new {@code ModelBase} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder(from, false)}.
     *
     * @param from the {@code ModelBase} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(ModelBase from) {
        return newBuilder(from, false);
    }

    /**
     * Creates a new {@code ModelBase} builder instance using the specified object as a basis.
     *
     * @param from the {@code ModelBase} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(ModelBase from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    /**
     * Builder class used to create ModelBase instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
    {
        ModelBase base;
        Collection<String> modules;
        Collection<String> subprojects;
        DistributionManagement distributionManagement;
        Map<String, String> properties;
        DependencyManagement dependencyManagement;
        Collection<Dependency> dependencies;
        Collection<Repository> repositories;
        Collection<Repository> pluginRepositories;
        Reporting reporting;
        Map<Object, InputLocation> locations;
        InputLocation importedFrom;

        protected Builder(boolean withDefaults) {
            if (withDefaults) {
            }
        }

        protected Builder(ModelBase base, boolean forceCopy) {
            if (forceCopy) {
                this.modules = base.modules;
                this.subprojects = base.subprojects;
                this.distributionManagement = base.distributionManagement;
                this.properties = base.properties;
                this.dependencyManagement = base.dependencyManagement;
                this.dependencies = base.dependencies;
                this.repositories = base.repositories;
                this.pluginRepositories = base.pluginRepositories;
                this.reporting = base.reporting;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Deprecated(since = "4.0.0")
        @Nonnull
        public Builder modules(Collection<String> modules) {
            this.modules = modules;
            return this;
        }

        @Nonnull
        public Builder subprojects(Collection<String> subprojects) {
            this.subprojects = subprojects;
            return this;
        }

        @Nonnull
        public Builder distributionManagement(DistributionManagement distributionManagement) {
            this.distributionManagement = distributionManagement;
            return this;
        }

        @Nonnull
        public Builder properties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        @Nonnull
        public Builder dependencyManagement(DependencyManagement dependencyManagement) {
            this.dependencyManagement = dependencyManagement;
            return this;
        }

        @Nonnull
        public Builder dependencies(Collection<Dependency> dependencies) {
            this.dependencies = dependencies;
            return this;
        }

        @Nonnull
        public Builder repositories(Collection<Repository> repositories) {
            this.repositories = repositories;
            return this;
        }

        @Nonnull
        public Builder pluginRepositories(Collection<Repository> pluginRepositories) {
            this.pluginRepositories = pluginRepositories;
            return this;
        }

        @Nonnull
        public Builder reporting(Reporting reporting) {
            this.reporting = reporting;
            return this;
        }


        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<>(this.locations) : new HashMap<>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Nonnull
        public ModelBase build() {
            // this method should not contain any logic other than creating (or reusing) an object in order to ease subclassing
            if (base != null
                    && (modules == null || modules == base.modules)
                    && (subprojects == null || subprojects == base.subprojects)
                    && (distributionManagement == null || distributionManagement == base.distributionManagement)
                    && (properties == null || properties == base.properties)
                    && (dependencyManagement == null || dependencyManagement == base.dependencyManagement)
                    && (dependencies == null || dependencies == base.dependencies)
                    && (repositories == null || repositories == base.repositories)
                    && (pluginRepositories == null || pluginRepositories == base.pluginRepositories)
                    && (reporting == null || reporting == base.reporting)
            ) {
                return base;
            }
            return new ModelBase(this);
        }

        Map<Object, InputLocation> computeLocations() {
            Map<Object, InputLocation> newlocs = locations != null ? locations : Map.of();
            Map<Object, InputLocation> oldlocs = base != null ? base.locations : Map.of();
            if (newlocs.isEmpty()) {
                return Map.copyOf(oldlocs);
            }
            if (oldlocs.isEmpty()) {
                return Map.copyOf(newlocs);
            }
            return Stream.concat(newlocs.entrySet().stream(), oldlocs.entrySet().stream())
                    // Keep value from newlocs in case of duplicates
                    .collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v1));
        }
    }

}
