// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * Section for management of default dependency information for use in a group of
 * POMs.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class DependencyManagement
    implements Serializable, InputLocationTracker
{
    /**
     * The dependencies specified here are not used until they are referenced in a
     * POM within the group. This allows the specification of a "standard" version for a
     * particular dependency.
     */
    final List<Dependency> dependencies;
    /** Locations */
    final Map<Object, InputLocation> locations;
    /** Location tracking */
    final InputLocation importedFrom;

    /**
      * Constructor for this class, to be called from its subclasses and {@link Builder}.
      * @see Builder#build()
      */
    protected DependencyManagement(Builder builder) {
        this.dependencies = ImmutableCollections.copy(builder.dependencies != null ? builder.dependencies : (builder.base != null ? builder.base.dependencies : null));
        this.locations = builder.computeLocations();
        this.importedFrom = builder.importedFrom;
    }

    /**
     * The dependencies specified here are not used until they are referenced in a
     * POM within the group. This allows the specification of a "standard" version for a
     * particular dependency.
     *
     * @return a {@code List<Dependency>}
     */
    @Nonnull
    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    /**
     * Gets the location of the specified field in the input source.
     *
     * @param key the key of the field, must not be {@code null}
     * @return the location of the field in the input source or {@code null} if unknown
     * @throws NullPointerException if {@code key} is {@code null}
     */
    public InputLocation getLocation(Object key) {
        Objects.requireNonNull(key, "key");
        return locations.get(key);
    }

    /**
     * Gets the keys of the locations of the input source.
     */
    public Set<Object> getLocationKeys() {
        return locations.keySet();
    }

    protected Stream<Object> getLocationKeyStream() {
        return locations.keySet().stream();
    }

    /**
     * Gets the input location that caused this model to be read.
     */
    public InputLocation getImportedFrom() {
        return importedFrom;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with() {
        return newBuilder(this);
    }
    /**
     * Creates a new {@code DependencyManagement} instance using the specified dependencies.
     *
     * @param dependencies the new {@code Collection<Dependency>} to use
     * @return a {@code DependencyManagement} with the specified dependencies
     */
    @Nonnull
    public DependencyManagement withDependencies(Collection<Dependency> dependencies) {
        return newBuilder(this, true).dependencies(dependencies).build();
    }

    /**
     * Creates a new {@code DependencyManagement} instance.
     * Equivalent to {@code newInstance(true)}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code DependencyManagement}
     */
    @Nonnull
    public static DependencyManagement newInstance() {
        return newInstance(true);
    }

    /**
     * Creates a new {@code DependencyManagement} instance using default values or not.
     * Equivalent to {@code newBuilder(withDefaults).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code DependencyManagement}
     */
    @Nonnull
    public static DependencyManagement newInstance(boolean withDefaults) {
        return newBuilder(withDefaults).build();
    }

    /**
     * Creates a new {@code DependencyManagement} builder instance.
     * Equivalent to {@code newBuilder(true)}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder() {
        return newBuilder(true);
    }

    /**
     * Creates a new {@code DependencyManagement} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    /**
     * Creates a new {@code DependencyManagement} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder(from, false)}.
     *
     * @param from the {@code DependencyManagement} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(DependencyManagement from) {
        return newBuilder(from, false);
    }

    /**
     * Creates a new {@code DependencyManagement} builder instance using the specified object as a basis.
     *
     * @param from the {@code DependencyManagement} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(DependencyManagement from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    /**
     * Builder class used to create DependencyManagement instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
    {
        DependencyManagement base;
        Collection<Dependency> dependencies;
        Map<Object, InputLocation> locations;
        InputLocation importedFrom;

        protected Builder(boolean withDefaults) {
            if (withDefaults) {
            }
        }

        protected Builder(DependencyManagement base, boolean forceCopy) {
            if (forceCopy) {
                this.dependencies = base.dependencies;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder dependencies(Collection<Dependency> dependencies) {
            this.dependencies = dependencies;
            return this;
        }


        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<>(this.locations) : new HashMap<>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Nonnull
        public DependencyManagement build() {
            // this method should not contain any logic other than creating (or reusing) an object in order to ease subclassing
            if (base != null
                    && (dependencies == null || dependencies == base.dependencies)
            ) {
                return base;
            }
            return new DependencyManagement(this);
        }

        Map<Object, InputLocation> computeLocations() {
            Map<Object, InputLocation> newlocs = locations != null ? locations : Map.of();
            Map<Object, InputLocation> oldlocs = base != null ? base.locations : Map.of();
            if (newlocs.isEmpty()) {
                return Map.copyOf(oldlocs);
            }
            if (oldlocs.isEmpty()) {
                return Map.copyOf(newlocs);
            }
            return Stream.concat(newlocs.entrySet().stream(), oldlocs.entrySet().stream())
                    // Keep value from newlocs in case of duplicates
                    .collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v1));
        }
    }

}
