// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.xml.XmlNode;

/**
 * Contains the configuration information of the container like Plugin.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class ConfigurationContainer
    implements Serializable, InputLocationTracker
{
    /**
     * Whether any configuration should be propagated to child POMs. Note: While the type
     * of this field is {@code String} for technical reasons, the semantic type is actually
     * {@code Boolean}. Default value is {@code true}.
     */
    final String inherited;
    /**
     * <p>The configuration as DOM object.</p>
     * <p>By default, every element content is trimmed, but starting with Maven 3.1.0, you can add
     * {@code xml:space="preserve"} to elements you want to preserve whitespace.</p>
     * <p>You can control how child POMs inherit configuration from parent POMs by adding {@code combine.children}
     * or {@code combine.self} attributes to the children of the configuration element:</p>
     * <ul>
     * <li>{@code combine.children}: available values are {@code merge} (default) and {@code append},</li>
     * <li>{@code combine.self}: available values are {@code merge} (default) and {@code override}.</li>
     * </ul>
     * 
     * @see <a href="https://maven.apache.org/pom.html#Plugins">POM Reference documentation</a>
     * @see <a href="https://codehaus-plexus.github.io/plexus-utils/apidocs/org/codehaus/plexus/util/xml/Xpp3DomUtils.html">Xpp3DomUtils</a>
     */
    final XmlNode configuration;
    /** Locations */
    final Map<Object, InputLocation> locations;
    /** Location tracking */
    final InputLocation importedFrom;

    /**
      * Constructor for this class, to be called from its subclasses and {@link Builder}.
      * @see Builder#build()
      */
    protected ConfigurationContainer(Builder builder) {
        this.inherited = builder.inherited != null ? builder.inherited : (builder.base != null ? builder.base.inherited : null);
        this.configuration = builder.configuration != null ? builder.configuration : (builder.base != null ? builder.base.configuration : null);
        this.locations = builder.computeLocations();
        this.importedFrom = builder.importedFrom;
    }

    /**
     * Whether any configuration should be propagated to child POMs. Note: While the type
     * of this field is {@code String} for technical reasons, the semantic type is actually
     * {@code Boolean}. Default value is {@code true}.
     *
     * @return a {@code String}
     */
    public String getInherited() {
        return this.inherited;
    }

    /**
     * <p>The configuration as DOM object.</p>
     * <p>By default, every element content is trimmed, but starting with Maven 3.1.0, you can add
     * {@code xml:space="preserve"} to elements you want to preserve whitespace.</p>
     * <p>You can control how child POMs inherit configuration from parent POMs by adding {@code combine.children}
     * or {@code combine.self} attributes to the children of the configuration element:</p>
     * <ul>
     * <li>{@code combine.children}: available values are {@code merge} (default) and {@code append},</li>
     * <li>{@code combine.self}: available values are {@code merge} (default) and {@code override}.</li>
     * </ul>
     * 
     * @see <a href="https://maven.apache.org/pom.html#Plugins">POM Reference documentation</a>
     * @see <a href="https://codehaus-plexus.github.io/plexus-utils/apidocs/org/codehaus/plexus/util/xml/Xpp3DomUtils.html">Xpp3DomUtils</a>
     *
     * @return a {@code XmlNode}
     */
    public XmlNode getConfiguration() {
        return this.configuration;
    }

    /**
     * Gets the location of the specified field in the input source.
     *
     * @param key the key of the field, must not be {@code null}
     * @return the location of the field in the input source or {@code null} if unknown
     * @throws NullPointerException if {@code key} is {@code null}
     */
    public InputLocation getLocation(Object key) {
        Objects.requireNonNull(key, "key");
        return locations.get(key);
    }

    /**
     * Gets the keys of the locations of the input source.
     */
    public Set<Object> getLocationKeys() {
        return locations.keySet();
    }

    protected Stream<Object> getLocationKeyStream() {
        return locations.keySet().stream();
    }

    /**
     * Gets the input location that caused this model to be read.
     */
    public InputLocation getImportedFrom() {
        return importedFrom;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with() {
        return newBuilder(this);
    }
    /**
     * Creates a new {@code ConfigurationContainer} instance using the specified inherited.
     *
     * @param inherited the new {@code String} to use
     * @return a {@code ConfigurationContainer} with the specified inherited
     */
    @Nonnull
    public ConfigurationContainer withInherited(String inherited) {
        return newBuilder(this, true).inherited(inherited).build();
    }
    /**
     * Creates a new {@code ConfigurationContainer} instance using the specified configuration.
     *
     * @param configuration the new {@code XmlNode} to use
     * @return a {@code ConfigurationContainer} with the specified configuration
     */
    @Nonnull
    public ConfigurationContainer withConfiguration(XmlNode configuration) {
        return newBuilder(this, true).configuration(configuration).build();
    }

    /**
     * Creates a new {@code ConfigurationContainer} instance.
     * Equivalent to {@code newInstance(true)}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code ConfigurationContainer}
     */
    @Nonnull
    public static ConfigurationContainer newInstance() {
        return newInstance(true);
    }

    /**
     * Creates a new {@code ConfigurationContainer} instance using default values or not.
     * Equivalent to {@code newBuilder(withDefaults).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code ConfigurationContainer}
     */
    @Nonnull
    public static ConfigurationContainer newInstance(boolean withDefaults) {
        return newBuilder(withDefaults).build();
    }

    /**
     * Creates a new {@code ConfigurationContainer} builder instance.
     * Equivalent to {@code newBuilder(true)}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder() {
        return newBuilder(true);
    }

    /**
     * Creates a new {@code ConfigurationContainer} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    /**
     * Creates a new {@code ConfigurationContainer} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder(from, false)}.
     *
     * @param from the {@code ConfigurationContainer} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(ConfigurationContainer from) {
        return newBuilder(from, false);
    }

    /**
     * Creates a new {@code ConfigurationContainer} builder instance using the specified object as a basis.
     *
     * @param from the {@code ConfigurationContainer} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(ConfigurationContainer from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    /**
     * Builder class used to create ConfigurationContainer instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
    {
        ConfigurationContainer base;
        String inherited;
        XmlNode configuration;
        Map<Object, InputLocation> locations;
        InputLocation importedFrom;

        protected Builder(boolean withDefaults) {
            if (withDefaults) {
            }
        }

        protected Builder(ConfigurationContainer base, boolean forceCopy) {
            if (forceCopy) {
                this.inherited = base.inherited;
                this.configuration = base.configuration;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder inherited(String inherited) {
            this.inherited = inherited;
            return this;
        }

        @Nonnull
        public Builder configuration(XmlNode configuration) {
            this.configuration = configuration;
            return this;
        }


        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<>(this.locations) : new HashMap<>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Nonnull
        public ConfigurationContainer build() {
            // this method should not contain any logic other than creating (or reusing) an object in order to ease subclassing
            if (base != null
                    && (inherited == null || inherited == base.inherited)
                    && (configuration == null || configuration == base.configuration)
            ) {
                return base;
            }
            return new ConfigurationContainer(this);
        }

        Map<Object, InputLocation> computeLocations() {
            Map<Object, InputLocation> newlocs = locations != null ? locations : Map.of();
            Map<Object, InputLocation> oldlocs = base != null ? base.locations : Map.of();
            if (newlocs.isEmpty()) {
                return Map.copyOf(oldlocs);
            }
            if (oldlocs.isEmpty()) {
                return Map.copyOf(newlocs);
            }
            return Stream.concat(newlocs.entrySet().stream(), oldlocs.entrySet().stream())
                    // Keep value from newlocs in case of duplicates
                    .collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v1));
        }
    }


            
    public boolean isInherited() {
        return ( getInherited() != null ) ? Boolean.parseBoolean( getInherited() ) : true;
    }

            
          
}
