// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * The {@code <ciManagement>} element contains information required to the
 * continuous integration system of the project.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class CiManagement
    implements Serializable, InputLocationTracker
{
    /**
     * The name of the continuous integration system, e.g. {@code continuum}.
     */
    final String system;
    /**
     * URL for the continuous integration system used by the project if it has a web interface.
     */
    final String url;
    /**
     * Configuration for notifying developers/users when a build is unsuccessful,
     * including user information and notification mode.
     */
    final List<Notifier> notifiers;
    /** Locations */
    final Map<Object, InputLocation> locations;
    /** Location tracking */
    final InputLocation importedFrom;

    /**
      * Constructor for this class, to be called from its subclasses and {@link Builder}.
      * @see Builder#build()
      */
    protected CiManagement(Builder builder) {
        this.system = builder.system != null ? builder.system : (builder.base != null ? builder.base.system : null);
        this.url = builder.url != null ? builder.url : (builder.base != null ? builder.base.url : null);
        this.notifiers = ImmutableCollections.copy(builder.notifiers != null ? builder.notifiers : (builder.base != null ? builder.base.notifiers : null));
        this.locations = builder.computeLocations();
        this.importedFrom = builder.importedFrom;
    }

    /**
     * The name of the continuous integration system, e.g. {@code continuum}.
     *
     * @return a {@code String}
     */
    public String getSystem() {
        return this.system;
    }

    /**
     * URL for the continuous integration system used by the project if it has a web interface.
     *
     * @return a {@code String}
     */
    public String getUrl() {
        return this.url;
    }

    /**
     * Configuration for notifying developers/users when a build is unsuccessful,
     * including user information and notification mode.
     *
     * @return a {@code List<Notifier>}
     */
    @Nonnull
    public List<Notifier> getNotifiers() {
        return this.notifiers;
    }

    /**
     * Gets the location of the specified field in the input source.
     *
     * @param key the key of the field, must not be {@code null}
     * @return the location of the field in the input source or {@code null} if unknown
     * @throws NullPointerException if {@code key} is {@code null}
     */
    public InputLocation getLocation(Object key) {
        Objects.requireNonNull(key, "key");
        return locations.get(key);
    }

    /**
     * Gets the keys of the locations of the input source.
     */
    public Set<Object> getLocationKeys() {
        return locations.keySet();
    }

    protected Stream<Object> getLocationKeyStream() {
        return locations.keySet().stream();
    }

    /**
     * Gets the input location that caused this model to be read.
     */
    public InputLocation getImportedFrom() {
        return importedFrom;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with() {
        return newBuilder(this);
    }
    /**
     * Creates a new {@code CiManagement} instance using the specified system.
     *
     * @param system the new {@code String} to use
     * @return a {@code CiManagement} with the specified system
     */
    @Nonnull
    public CiManagement withSystem(String system) {
        return newBuilder(this, true).system(system).build();
    }
    /**
     * Creates a new {@code CiManagement} instance using the specified url.
     *
     * @param url the new {@code String} to use
     * @return a {@code CiManagement} with the specified url
     */
    @Nonnull
    public CiManagement withUrl(String url) {
        return newBuilder(this, true).url(url).build();
    }
    /**
     * Creates a new {@code CiManagement} instance using the specified notifiers.
     *
     * @param notifiers the new {@code Collection<Notifier>} to use
     * @return a {@code CiManagement} with the specified notifiers
     */
    @Nonnull
    public CiManagement withNotifiers(Collection<Notifier> notifiers) {
        return newBuilder(this, true).notifiers(notifiers).build();
    }

    /**
     * Creates a new {@code CiManagement} instance.
     * Equivalent to {@code newInstance(true)}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code CiManagement}
     */
    @Nonnull
    public static CiManagement newInstance() {
        return newInstance(true);
    }

    /**
     * Creates a new {@code CiManagement} instance using default values or not.
     * Equivalent to {@code newBuilder(withDefaults).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code CiManagement}
     */
    @Nonnull
    public static CiManagement newInstance(boolean withDefaults) {
        return newBuilder(withDefaults).build();
    }

    /**
     * Creates a new {@code CiManagement} builder instance.
     * Equivalent to {@code newBuilder(true)}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder() {
        return newBuilder(true);
    }

    /**
     * Creates a new {@code CiManagement} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    /**
     * Creates a new {@code CiManagement} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder(from, false)}.
     *
     * @param from the {@code CiManagement} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(CiManagement from) {
        return newBuilder(from, false);
    }

    /**
     * Creates a new {@code CiManagement} builder instance using the specified object as a basis.
     *
     * @param from the {@code CiManagement} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(CiManagement from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    /**
     * Builder class used to create CiManagement instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
    {
        CiManagement base;
        String system;
        String url;
        Collection<Notifier> notifiers;
        Map<Object, InputLocation> locations;
        InputLocation importedFrom;

        protected Builder(boolean withDefaults) {
            if (withDefaults) {
            }
        }

        protected Builder(CiManagement base, boolean forceCopy) {
            if (forceCopy) {
                this.system = base.system;
                this.url = base.url;
                this.notifiers = base.notifiers;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder system(String system) {
            this.system = system;
            return this;
        }

        @Nonnull
        public Builder url(String url) {
            this.url = url;
            return this;
        }

        @Nonnull
        public Builder notifiers(Collection<Notifier> notifiers) {
            this.notifiers = notifiers;
            return this;
        }


        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<>(this.locations) : new HashMap<>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Nonnull
        public CiManagement build() {
            // this method should not contain any logic other than creating (or reusing) an object in order to ease subclassing
            if (base != null
                    && (system == null || system == base.system)
                    && (url == null || url == base.url)
                    && (notifiers == null || notifiers == base.notifiers)
            ) {
                return base;
            }
            return new CiManagement(this);
        }

        Map<Object, InputLocation> computeLocations() {
            Map<Object, InputLocation> newlocs = locations != null ? locations : Map.of();
            Map<Object, InputLocation> oldlocs = base != null ? base.locations : Map.of();
            if (newlocs.isEmpty()) {
                return Map.copyOf(oldlocs);
            }
            if (oldlocs.isEmpty()) {
                return Map.copyOf(newlocs);
            }
            return Stream.concat(newlocs.entrySet().stream(), oldlocs.entrySet().stream())
                    // Keep value from newlocs in case of duplicates
                    .collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v1));
        }
    }

}
