// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * Information about the issue tracking (or bug tracking) system used to manage this
 * project.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class IssueManagement
    implements Serializable, InputLocationTracker
{
    /**
     * The name of the issue management system, e.g. Bugzilla
     */
    final String system;
    /**
     * URL for the issue management system used by the project.
     */
    final String url;
    /** Locations (this potentially hides the same name field from the super class) */
    final Map<Object, InputLocation> locations;
    /** Location tracking */
    final InputLocation importedFrom;

    /**
      * Constructor for this class, to be called from its subclasses and {@link Builder}.
      * @see Builder#build()
      */
    protected IssueManagement(Builder builder) {
        this.system = builder.system != null ? builder.system : (builder.base != null ? builder.base.system : null);
        this.url = builder.url != null ? builder.url : (builder.base != null ? builder.base.url : null);
        Map<Object, InputLocation> newlocs = builder.locations != null ? builder.locations : Collections.emptyMap();
        Map<Object, InputLocation> oldlocs = builder.base != null && builder.base.locations != null ? builder.base.locations : Collections.emptyMap();
        Map<Object, InputLocation> mutableLocations = new HashMap<>();
        this.importedFrom = builder.importedFrom;
        mutableLocations.put("", newlocs.containsKey("") ? newlocs.get("") : oldlocs.get(""));
        mutableLocations.put("system", newlocs.containsKey("system") ? newlocs.get("system") : oldlocs.get("system"));
        mutableLocations.put("url", newlocs.containsKey("url") ? newlocs.get("url") : oldlocs.get("url"));
        this.locations = Collections.unmodifiableMap(mutableLocations);
    }

    /**
     * The name of the issue management system, e.g. Bugzilla
     *
     * @return a {@code String}
     */
    public String getSystem() {
        return this.system;
    }

    /**
     * URL for the issue management system used by the project.
     *
     * @return a {@code String}
     */
    public String getUrl() {
        return this.url;
    }

    /**
     * Gets the location of the specified field in the input source.
     */
    public InputLocation getLocation(Object key) {
        return locations != null ? locations.get(key) : null;
    }

    /**
    * Gets the keys of the locations of the input source.
    */
    public Set<Object> getLocationKeys() {
        return locations != null ? locations.keySet() : null;
    }

    /**
     * Gets the input location that caused this model to be read.
     */
    public InputLocation getImportedFrom()
    {
        return importedFrom;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with() {
        return newBuilder(this);
    }
    /**
     * Creates a new {@code IssueManagement} instance using the specified system.
     *
     * @param system the new {@code String} to use
     * @return a {@code IssueManagement} with the specified system
     */
    @Nonnull
    public IssueManagement withSystem(String system) {
        return newBuilder(this, true).system(system).build();
    }
    /**
     * Creates a new {@code IssueManagement} instance using the specified url.
     *
     * @param url the new {@code String} to use
     * @return a {@code IssueManagement} with the specified url
     */
    @Nonnull
    public IssueManagement withUrl(String url) {
        return newBuilder(this, true).url(url).build();
    }

    /**
     * Creates a new {@code IssueManagement} instance.
     * Equivalent to {@code newInstance(true)}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code IssueManagement}
     */
    @Nonnull
    public static IssueManagement newInstance() {
        return newInstance(true);
    }

    /**
     * Creates a new {@code IssueManagement} instance using default values or not.
     * Equivalent to {@code newBuilder(withDefaults).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code IssueManagement}
     */
    @Nonnull
    public static IssueManagement newInstance(boolean withDefaults) {
        return newBuilder(withDefaults).build();
    }

    /**
     * Creates a new {@code IssueManagement} builder instance.
     * Equivalent to {@code newBuilder(true)}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder() {
        return newBuilder(true);
    }

    /**
     * Creates a new {@code IssueManagement} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    /**
     * Creates a new {@code IssueManagement} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder(from, false)}.
     *
     * @param from the {@code IssueManagement} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(IssueManagement from) {
        return newBuilder(from, false);
    }

    /**
     * Creates a new {@code IssueManagement} builder instance using the specified object as a basis.
     *
     * @param from the {@code IssueManagement} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(IssueManagement from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    /**
     * Builder class used to create IssueManagement instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
    {
        IssueManagement base;
        String system;
        String url;
        Map<Object, InputLocation> locations;
        InputLocation importedFrom;

        protected Builder(boolean withDefaults) {
            if (withDefaults) {
            }
        }

        protected Builder(IssueManagement base, boolean forceCopy) {
            if (forceCopy) {
                this.system = base.system;
                this.url = base.url;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder system(String system) {
            this.system = system;
            return this;
        }

        @Nonnull
        public Builder url(String url) {
            this.url = url;
            return this;
        }


        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<>(this.locations) : new HashMap<>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Nonnull
        public IssueManagement build() {
            // this method should not contain any logic other than creating (or reusing) an object in order to ease subclassing
            if (base != null
                    && (system == null || system == base.system)
                    && (url == null || url == base.url)
            ) {
                return base;
            }
            return new IssueManagement(this);
        }
    }


            
    /**
     * @see java.lang.Object#toString()
     */
    public String toString()
    {
        return "IssueManagement {system=" + getSystem() + ", url=" + getUrl() + "}";
    }
            
          
}
