/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.ConfigurationContainer;
import org.apache.maven.api.model.Dependency;
import org.apache.maven.api.model.ImmutableCollections;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;
import org.apache.maven.api.model.PluginExecution;
import org.apache.maven.api.xml.XmlNode;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class Plugin
extends ConfigurationContainer
implements Serializable,
InputLocationTracker {
    final String groupId;
    final String artifactId;
    final String version;
    final String extensions;
    final List<PluginExecution> executions;
    final List<Dependency> dependencies;

    Plugin(String inherited, XmlNode configuration, String groupId, String artifactId, String version, String extensions, Collection<PluginExecution> executions, Collection<Dependency> dependencies, Map<Object, InputLocation> locations) {
        super(inherited, configuration, locations);
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.extensions = extensions;
        this.executions = ImmutableCollections.copy(executions);
        this.dependencies = ImmutableCollections.copy(dependencies);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getExtensions() {
        return this.extensions;
    }

    @Nonnull
    public List<PluginExecution> getExecutions() {
        return this.executions;
    }

    @Nonnull
    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    @Override
    @Nonnull
    public Builder with() {
        return Plugin.newBuilder(this);
    }

    @Override
    @Nonnull
    public Plugin withInherited(String inherited) {
        return Plugin.newBuilder(this, true).inherited(inherited).build();
    }

    @Override
    @Nonnull
    public Plugin withConfiguration(XmlNode configuration) {
        return Plugin.newBuilder(this, true).configuration(configuration).build();
    }

    @Nonnull
    public Plugin withGroupId(String groupId) {
        return Plugin.newBuilder(this, true).groupId(groupId).build();
    }

    @Nonnull
    public Plugin withArtifactId(String artifactId) {
        return Plugin.newBuilder(this, true).artifactId(artifactId).build();
    }

    @Nonnull
    public Plugin withVersion(String version) {
        return Plugin.newBuilder(this, true).version(version).build();
    }

    @Nonnull
    public Plugin withExtensions(String extensions) {
        return Plugin.newBuilder(this, true).extensions(extensions).build();
    }

    @Nonnull
    public Plugin withExecutions(Collection<PluginExecution> executions) {
        return Plugin.newBuilder(this, true).executions(executions).build();
    }

    @Nonnull
    public Plugin withDependencies(Collection<Dependency> dependencies) {
        return Plugin.newBuilder(this, true).dependencies(dependencies).build();
    }

    @Nonnull
    public static Plugin newInstance() {
        return Plugin.newInstance(true);
    }

    @Nonnull
    public static Plugin newInstance(boolean withDefaults) {
        return Plugin.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Plugin.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Plugin from) {
        return Plugin.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Plugin from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    public boolean isExtensions() {
        return this.getExtensions() != null ? Boolean.parseBoolean(this.getExtensions()) : false;
    }

    public String getId() {
        return new StringBuilder(128).append(this.getGroupId() == null ? "[unknown-group-id]" : this.getGroupId()).append(":").append(this.getArtifactId() == null ? "[unknown-artifact-id]" : this.getArtifactId()).append(":").append(this.getVersion() == null ? "[unknown-version]" : this.getVersion()).toString();
    }

    public String getKey() {
        return Plugin.constructKey(this.getGroupId(), this.getArtifactId());
    }

    public static String constructKey(String groupId, String artifactId) {
        return groupId + ":" + artifactId;
    }

    public boolean equals(Object other) {
        if (other instanceof Plugin) {
            Plugin otherPlugin = (Plugin)other;
            return this.getKey().equals(otherPlugin.getKey());
        }
        return false;
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public String toString() {
        return "Plugin [" + this.getKey() + "]";
    }

    @NotThreadSafe
    public static class Builder
    extends ConfigurationContainer.Builder {
        Plugin base;
        String groupId;
        String artifactId;
        String version;
        String extensions;
        Collection<PluginExecution> executions;
        Collection<Dependency> dependencies;

        Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
                this.groupId = "org.apache.maven.plugins";
            }
        }

        Builder(Plugin base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.groupId = base.groupId;
                this.artifactId = base.artifactId;
                this.version = base.version;
                this.extensions = base.extensions;
                this.executions = base.executions;
                this.dependencies = base.dependencies;
                this.locations = base.locations;
            } else {
                this.base = base;
            }
        }

        @Override
        @Nonnull
        public Builder inherited(String inherited) {
            this.inherited = inherited;
            return this;
        }

        @Override
        @Nonnull
        public Builder configuration(XmlNode configuration) {
            this.configuration = configuration;
            return this;
        }

        @Nonnull
        public Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        @Nonnull
        public Builder artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        @Nonnull
        public Builder version(String version) {
            this.version = version;
            return this;
        }

        @Nonnull
        public Builder extensions(String extensions) {
            this.extensions = extensions;
            return this;
        }

        @Nonnull
        public Builder executions(Collection<PluginExecution> executions) {
            this.executions = executions;
            return this;
        }

        @Nonnull
        public Builder dependencies(Collection<Dependency> dependencies) {
            this.dependencies = dependencies;
            return this;
        }

        @Override
        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Override
        @Nonnull
        public Plugin build() {
            if (!(this.base == null || this.inherited != null && this.inherited != this.base.inherited || this.configuration != null && this.configuration != this.base.configuration || this.groupId != null && this.groupId != this.base.groupId || this.artifactId != null && this.artifactId != this.base.artifactId || this.version != null && this.version != this.base.version || this.extensions != null && this.extensions != this.base.extensions || this.executions != null && this.executions != this.base.executions || this.dependencies != null && this.dependencies != this.base.dependencies)) {
                return this.base;
            }
            Map newlocs = this.locations != null ? this.locations : Collections.emptyMap();
            Map oldlocs = this.base != null && this.base.locations != null ? this.base.locations : Collections.emptyMap();
            HashMap<Object, InputLocation> locations = new HashMap<Object, InputLocation>();
            locations.put("", newlocs.containsKey("") ? (InputLocation)newlocs.get("") : (InputLocation)oldlocs.get(""));
            locations.put("inherited", newlocs.containsKey("inherited") ? (InputLocation)newlocs.get("inherited") : (InputLocation)oldlocs.get("inherited"));
            locations.put("configuration", newlocs.containsKey("configuration") ? (InputLocation)newlocs.get("configuration") : (InputLocation)oldlocs.get("configuration"));
            locations.put("groupId", newlocs.containsKey("groupId") ? (InputLocation)newlocs.get("groupId") : (InputLocation)oldlocs.get("groupId"));
            locations.put("artifactId", newlocs.containsKey("artifactId") ? (InputLocation)newlocs.get("artifactId") : (InputLocation)oldlocs.get("artifactId"));
            locations.put("version", newlocs.containsKey("version") ? (InputLocation)newlocs.get("version") : (InputLocation)oldlocs.get("version"));
            locations.put("extensions", newlocs.containsKey("extensions") ? (InputLocation)newlocs.get("extensions") : (InputLocation)oldlocs.get("extensions"));
            locations.put("executions", newlocs.containsKey("executions") ? (InputLocation)newlocs.get("executions") : (InputLocation)oldlocs.get("executions"));
            locations.put("dependencies", newlocs.containsKey("dependencies") ? (InputLocation)newlocs.get("dependencies") : (InputLocation)oldlocs.get("dependencies"));
            return new Plugin(this.inherited != null ? this.inherited : (this.base != null ? this.base.inherited : null), (XmlNode)(this.configuration != null ? this.configuration : (this.base != null ? this.base.configuration : null)), this.groupId != null ? this.groupId : (this.base != null ? this.base.groupId : null), this.artifactId != null ? this.artifactId : (this.base != null ? this.base.artifactId : null), this.version != null ? this.version : (this.base != null ? this.base.version : null), this.extensions != null ? this.extensions : (this.base != null ? this.base.extensions : null), this.executions != null ? this.executions : (this.base != null ? this.base.executions : null), this.dependencies != null ? this.dependencies : (this.base != null ? this.base.dependencies : null), locations);
        }
    }
}

