/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.BuildBase;
import org.apache.maven.api.model.Extension;
import org.apache.maven.api.model.ImmutableCollections;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;
import org.apache.maven.api.model.Plugin;
import org.apache.maven.api.model.PluginManagement;
import org.apache.maven.api.model.Resource;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class Build
extends BuildBase
implements Serializable,
InputLocationTracker {
    final String sourceDirectory;
    final String scriptSourceDirectory;
    final String testSourceDirectory;
    final String outputDirectory;
    final String testOutputDirectory;
    final List<Extension> extensions;

    Build(Collection<Plugin> plugins, PluginManagement pluginManagement, String defaultGoal, Collection<Resource> resources, Collection<Resource> testResources, String directory, String finalName, Collection<String> filters, String sourceDirectory, String scriptSourceDirectory, String testSourceDirectory, String outputDirectory, String testOutputDirectory, Collection<Extension> extensions, Map<Object, InputLocation> locations) {
        super(plugins, pluginManagement, defaultGoal, resources, testResources, directory, finalName, filters, locations);
        this.sourceDirectory = sourceDirectory;
        this.scriptSourceDirectory = scriptSourceDirectory;
        this.testSourceDirectory = testSourceDirectory;
        this.outputDirectory = outputDirectory;
        this.testOutputDirectory = testOutputDirectory;
        this.extensions = ImmutableCollections.copy(extensions);
    }

    public String getSourceDirectory() {
        return this.sourceDirectory;
    }

    public String getScriptSourceDirectory() {
        return this.scriptSourceDirectory;
    }

    public String getTestSourceDirectory() {
        return this.testSourceDirectory;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public String getTestOutputDirectory() {
        return this.testOutputDirectory;
    }

    @Nonnull
    public List<Extension> getExtensions() {
        return this.extensions;
    }

    @Override
    @Nonnull
    public Builder with() {
        return Build.newBuilder(this);
    }

    @Override
    @Nonnull
    public Build withPlugins(Collection<Plugin> plugins) {
        return ((Builder)Build.newBuilder(this, true).plugins((Collection)plugins)).build();
    }

    @Override
    @Nonnull
    public Build withPluginManagement(PluginManagement pluginManagement) {
        return Build.newBuilder(this, true).pluginManagement(pluginManagement).build();
    }

    @Override
    @Nonnull
    public Build withDefaultGoal(String defaultGoal) {
        return Build.newBuilder(this, true).defaultGoal(defaultGoal).build();
    }

    @Override
    @Nonnull
    public Build withResources(Collection<Resource> resources) {
        return ((Builder)Build.newBuilder(this, true).resources((Collection)resources)).build();
    }

    @Override
    @Nonnull
    public Build withTestResources(Collection<Resource> testResources) {
        return ((Builder)Build.newBuilder(this, true).testResources((Collection)testResources)).build();
    }

    @Override
    @Nonnull
    public Build withDirectory(String directory) {
        return Build.newBuilder(this, true).directory(directory).build();
    }

    @Override
    @Nonnull
    public Build withFinalName(String finalName) {
        return Build.newBuilder(this, true).finalName(finalName).build();
    }

    @Override
    @Nonnull
    public Build withFilters(Collection<String> filters) {
        return ((Builder)Build.newBuilder(this, true).filters((Collection)filters)).build();
    }

    @Nonnull
    public Build withSourceDirectory(String sourceDirectory) {
        return Build.newBuilder(this, true).sourceDirectory(sourceDirectory).build();
    }

    @Nonnull
    public Build withScriptSourceDirectory(String scriptSourceDirectory) {
        return Build.newBuilder(this, true).scriptSourceDirectory(scriptSourceDirectory).build();
    }

    @Nonnull
    public Build withTestSourceDirectory(String testSourceDirectory) {
        return Build.newBuilder(this, true).testSourceDirectory(testSourceDirectory).build();
    }

    @Nonnull
    public Build withOutputDirectory(String outputDirectory) {
        return Build.newBuilder(this, true).outputDirectory(outputDirectory).build();
    }

    @Nonnull
    public Build withTestOutputDirectory(String testOutputDirectory) {
        return Build.newBuilder(this, true).testOutputDirectory(testOutputDirectory).build();
    }

    @Nonnull
    public Build withExtensions(Collection<Extension> extensions) {
        return Build.newBuilder(this, true).extensions(extensions).build();
    }

    @Nonnull
    public static Build newInstance() {
        return Build.newInstance(true);
    }

    @Nonnull
    public static Build newInstance(boolean withDefaults) {
        return Build.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Build.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Build from) {
        return Build.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Build from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @Override
    public String toString() {
        return "Build {" + super.toString() + "}";
    }

    @NotThreadSafe
    public static class Builder
    extends BuildBase.Builder {
        Build base;
        String sourceDirectory;
        String scriptSourceDirectory;
        String testSourceDirectory;
        String outputDirectory;
        String testOutputDirectory;
        Collection<Extension> extensions;

        Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
                // empty if block
            }
        }

        Builder(Build base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.sourceDirectory = base.sourceDirectory;
                this.scriptSourceDirectory = base.scriptSourceDirectory;
                this.testSourceDirectory = base.testSourceDirectory;
                this.outputDirectory = base.outputDirectory;
                this.testOutputDirectory = base.testOutputDirectory;
                this.extensions = base.extensions;
                this.locations = base.locations;
            } else {
                this.base = base;
            }
        }

        @Override
        @Nonnull
        public Builder plugins(Collection<Plugin> plugins) {
            this.plugins = plugins;
            return this;
        }

        @Override
        @Nonnull
        public Builder pluginManagement(PluginManagement pluginManagement) {
            this.pluginManagement = pluginManagement;
            return this;
        }

        @Override
        @Nonnull
        public Builder defaultGoal(String defaultGoal) {
            this.defaultGoal = defaultGoal;
            return this;
        }

        @Override
        @Nonnull
        public Builder resources(Collection<Resource> resources) {
            this.resources = resources;
            return this;
        }

        @Override
        @Nonnull
        public Builder testResources(Collection<Resource> testResources) {
            this.testResources = testResources;
            return this;
        }

        @Override
        @Nonnull
        public Builder directory(String directory) {
            this.directory = directory;
            return this;
        }

        @Override
        @Nonnull
        public Builder finalName(String finalName) {
            this.finalName = finalName;
            return this;
        }

        @Override
        @Nonnull
        public Builder filters(Collection<String> filters) {
            this.filters = filters;
            return this;
        }

        @Nonnull
        public Builder sourceDirectory(String sourceDirectory) {
            this.sourceDirectory = sourceDirectory;
            return this;
        }

        @Nonnull
        public Builder scriptSourceDirectory(String scriptSourceDirectory) {
            this.scriptSourceDirectory = scriptSourceDirectory;
            return this;
        }

        @Nonnull
        public Builder testSourceDirectory(String testSourceDirectory) {
            this.testSourceDirectory = testSourceDirectory;
            return this;
        }

        @Nonnull
        public Builder outputDirectory(String outputDirectory) {
            this.outputDirectory = outputDirectory;
            return this;
        }

        @Nonnull
        public Builder testOutputDirectory(String testOutputDirectory) {
            this.testOutputDirectory = testOutputDirectory;
            return this;
        }

        @Nonnull
        public Builder extensions(Collection<Extension> extensions) {
            this.extensions = extensions;
            return this;
        }

        @Override
        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Override
        @Nonnull
        public Build build() {
            if (!(this.base == null || this.plugins != null && this.plugins != this.base.plugins || this.pluginManagement != null && this.pluginManagement != this.base.pluginManagement || this.defaultGoal != null && this.defaultGoal != this.base.defaultGoal || this.resources != null && this.resources != this.base.resources || this.testResources != null && this.testResources != this.base.testResources || this.directory != null && this.directory != this.base.directory || this.finalName != null && this.finalName != this.base.finalName || this.filters != null && this.filters != this.base.filters || this.sourceDirectory != null && this.sourceDirectory != this.base.sourceDirectory || this.scriptSourceDirectory != null && this.scriptSourceDirectory != this.base.scriptSourceDirectory || this.testSourceDirectory != null && this.testSourceDirectory != this.base.testSourceDirectory || this.outputDirectory != null && this.outputDirectory != this.base.outputDirectory || this.testOutputDirectory != null && this.testOutputDirectory != this.base.testOutputDirectory || this.extensions != null && this.extensions != this.base.extensions)) {
                return this.base;
            }
            Map newlocs = this.locations != null ? this.locations : Collections.emptyMap();
            Map oldlocs = this.base != null && this.base.locations != null ? this.base.locations : Collections.emptyMap();
            HashMap<Object, InputLocation> locations = new HashMap<Object, InputLocation>();
            locations.put("", newlocs.containsKey("") ? (InputLocation)newlocs.get("") : (InputLocation)oldlocs.get(""));
            locations.put("plugins", newlocs.containsKey("plugins") ? (InputLocation)newlocs.get("plugins") : (InputLocation)oldlocs.get("plugins"));
            locations.put("pluginManagement", newlocs.containsKey("pluginManagement") ? (InputLocation)newlocs.get("pluginManagement") : (InputLocation)oldlocs.get("pluginManagement"));
            locations.put("defaultGoal", newlocs.containsKey("defaultGoal") ? (InputLocation)newlocs.get("defaultGoal") : (InputLocation)oldlocs.get("defaultGoal"));
            locations.put("resources", newlocs.containsKey("resources") ? (InputLocation)newlocs.get("resources") : (InputLocation)oldlocs.get("resources"));
            locations.put("testResources", newlocs.containsKey("testResources") ? (InputLocation)newlocs.get("testResources") : (InputLocation)oldlocs.get("testResources"));
            locations.put("directory", newlocs.containsKey("directory") ? (InputLocation)newlocs.get("directory") : (InputLocation)oldlocs.get("directory"));
            locations.put("finalName", newlocs.containsKey("finalName") ? (InputLocation)newlocs.get("finalName") : (InputLocation)oldlocs.get("finalName"));
            locations.put("filters", newlocs.containsKey("filters") ? (InputLocation)newlocs.get("filters") : (InputLocation)oldlocs.get("filters"));
            locations.put("sourceDirectory", newlocs.containsKey("sourceDirectory") ? (InputLocation)newlocs.get("sourceDirectory") : (InputLocation)oldlocs.get("sourceDirectory"));
            locations.put("scriptSourceDirectory", newlocs.containsKey("scriptSourceDirectory") ? (InputLocation)newlocs.get("scriptSourceDirectory") : (InputLocation)oldlocs.get("scriptSourceDirectory"));
            locations.put("testSourceDirectory", newlocs.containsKey("testSourceDirectory") ? (InputLocation)newlocs.get("testSourceDirectory") : (InputLocation)oldlocs.get("testSourceDirectory"));
            locations.put("outputDirectory", newlocs.containsKey("outputDirectory") ? (InputLocation)newlocs.get("outputDirectory") : (InputLocation)oldlocs.get("outputDirectory"));
            locations.put("testOutputDirectory", newlocs.containsKey("testOutputDirectory") ? (InputLocation)newlocs.get("testOutputDirectory") : (InputLocation)oldlocs.get("testOutputDirectory"));
            locations.put("extensions", newlocs.containsKey("extensions") ? (InputLocation)newlocs.get("extensions") : (InputLocation)oldlocs.get("extensions"));
            return new Build(this.plugins != null ? this.plugins : (this.base != null ? this.base.plugins : null), this.pluginManagement != null ? this.pluginManagement : (this.base != null ? this.base.pluginManagement : null), this.defaultGoal != null ? this.defaultGoal : (this.base != null ? this.base.defaultGoal : null), this.resources != null ? this.resources : (this.base != null ? this.base.resources : null), this.testResources != null ? this.testResources : (this.base != null ? this.base.testResources : null), this.directory != null ? this.directory : (this.base != null ? this.base.directory : null), this.finalName != null ? this.finalName : (this.base != null ? this.base.finalName : null), this.filters != null ? this.filters : (this.base != null ? this.base.filters : null), this.sourceDirectory != null ? this.sourceDirectory : (this.base != null ? this.base.sourceDirectory : null), this.scriptSourceDirectory != null ? this.scriptSourceDirectory : (this.base != null ? this.base.scriptSourceDirectory : null), this.testSourceDirectory != null ? this.testSourceDirectory : (this.base != null ? this.base.testSourceDirectory : null), this.outputDirectory != null ? this.outputDirectory : (this.base != null ? this.base.outputDirectory : null), this.testOutputDirectory != null ? this.testOutputDirectory : (this.base != null ? this.base.testOutputDirectory : null), this.extensions != null ? this.extensions : (this.base != null ? this.base.extensions : null), locations);
        }
    }
}

