// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * Describes where an artifact has moved to. If any of the values are omitted, it is
 * assumed to be the same as it was before.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class Relocation
    implements Serializable, InputLocationTracker
{
    /**
     * The group ID the artifact has moved to.
     */
    final String groupId;
    /**
     * The new artifact ID of the artifact.
     */
    final String artifactId;
    /**
     * The new version of the artifact.
     */
    final String version;
    /**
     * An additional message to show the user about the move, such as the reason.
     */
    final String message;
    /** Locations */
    final Map<Object, InputLocation> locations;

    /**
      * Constructor for this class, package protected.
      * @see Builder#build()
      */
    Relocation(
        String groupId,
        String artifactId,
        String version,
        String message,
        Map<Object, InputLocation> locations
    ) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.message = message;
        this.locations = ImmutableCollections.copy(locations);
    }

    /**
     * The group ID the artifact has moved to.
     *
     * @return a {@code String}
     */
    public String getGroupId() {
        return this.groupId;
    }

    /**
     * The new artifact ID of the artifact.
     *
     * @return a {@code String}
     */
    public String getArtifactId() {
        return this.artifactId;
    }

    /**
     * The new version of the artifact.
     *
     * @return a {@code String}
     */
    public String getVersion() {
        return this.version;
    }

    /**
     * An additional message to show the user about the move, such as the reason.
     *
     * @return a {@code String}
     */
    public String getMessage() {
        return this.message;
    }

    /**
     * Gets the location of the specified field in the input source.
     */
    public InputLocation getLocation(Object key) {
        return locations != null ? locations.get(key) : null;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with() {
        return newBuilder(this);
    }
    /**
     * Creates a new {@code Relocation} instance using the specified groupId.
     *
     * @param groupId the new {@code String} to use
     * @return a {@code Relocation} with the specified groupId
     */
    @Nonnull
    public Relocation withGroupId(String groupId) {
        return newBuilder(this, true).groupId(groupId).build();
    }
    /**
     * Creates a new {@code Relocation} instance using the specified artifactId.
     *
     * @param artifactId the new {@code String} to use
     * @return a {@code Relocation} with the specified artifactId
     */
    @Nonnull
    public Relocation withArtifactId(String artifactId) {
        return newBuilder(this, true).artifactId(artifactId).build();
    }
    /**
     * Creates a new {@code Relocation} instance using the specified version.
     *
     * @param version the new {@code String} to use
     * @return a {@code Relocation} with the specified version
     */
    @Nonnull
    public Relocation withVersion(String version) {
        return newBuilder(this, true).version(version).build();
    }
    /**
     * Creates a new {@code Relocation} instance using the specified message.
     *
     * @param message the new {@code String} to use
     * @return a {@code Relocation} with the specified message
     */
    @Nonnull
    public Relocation withMessage(String message) {
        return newBuilder(this, true).message(message).build();
    }

    /**
     * Creates a new {@code Relocation} instance.
     * Equivalent to {@code newInstance(true)}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code Relocation}
     */
    @Nonnull
    public static Relocation newInstance() {
        return newInstance(true);
    }

    /**
     * Creates a new {@code Relocation} instance using default values or not.
     * Equivalent to {@code newBuilder(withDefaults).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Relocation}
     */
    @Nonnull
    public static Relocation newInstance(boolean withDefaults) {
        return newBuilder(withDefaults).build();
    }

    /**
     * Creates a new {@code Relocation} builder instance.
     * Equivalent to {@code newBuilder(true)}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder() {
        return newBuilder(true);
    }

    /**
     * Creates a new {@code Relocation} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    /**
     * Creates a new {@code Relocation} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder(from, false)}.
     *
     * @param from the {@code Relocation} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(Relocation from) {
        return newBuilder(from, false);
    }

    /**
     * Creates a new {@code Relocation} builder instance using the specified object as a basis.
     *
     * @param from the {@code Relocation} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(Relocation from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    /**
     * Builder class used to create Relocation instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
    {
        Relocation base;
        String groupId;
        String artifactId;
        String version;
        String message;
        Map<Object, InputLocation> locations;

        Builder(boolean withDefaults) {
            if (withDefaults) {
            }
        }

        Builder(Relocation base, boolean forceCopy) {
            if (forceCopy) {
                this.groupId = base.groupId;
                this.artifactId = base.artifactId;
                this.version = base.version;
                this.message = base.message;
                this.locations = base.locations;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        @Nonnull
        public Builder artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        @Nonnull
        public Builder version(String version) {
            this.version = version;
            return this;
        }

        @Nonnull
        public Builder message(String message) {
            this.message = message;
            return this;
        }


        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<>(this.locations) : new HashMap<>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Relocation build() {
            if (base != null
                    && (groupId == null || groupId == base.groupId)
                    && (artifactId == null || artifactId == base.artifactId)
                    && (version == null || version == base.version)
                    && (message == null || message == base.message)
            ) {
                return base;
            }
            Map<Object, InputLocation> newlocs = this.locations != null ? this.locations : Collections.emptyMap();
            Map<Object, InputLocation> oldlocs = this.base != null && this.base.locations != null ? this.base.locations : Collections.emptyMap();
            Map<Object, InputLocation> locations = new HashMap<>();
            locations.put("", newlocs.containsKey("") ? newlocs.get("") : oldlocs.get(""));
            locations.put("groupId", newlocs.containsKey("groupId") ? newlocs.get("groupId") : oldlocs.get("groupId"));
            locations.put("artifactId", newlocs.containsKey("artifactId") ? newlocs.get("artifactId") : oldlocs.get("artifactId"));
            locations.put("version", newlocs.containsKey("version") ? newlocs.get("version") : oldlocs.get("version"));
            locations.put("message", newlocs.containsKey("message") ? newlocs.get("message") : oldlocs.get("message"));
            return new Relocation(
                groupId != null ? groupId : (base != null ? base.groupId : null),
                artifactId != null ? artifactId : (base != null ? base.artifactId : null),
                version != null ? version : (base != null ? base.version : null),
                message != null ? message : (base != null ? base.message : null),
                locations
            );
        }
    }

}
