// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.xml.XmlNode;

/**
 * The {@code @lt;execution>} element contains information required for the
 * execution of a plugin.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class PluginExecution
    extends ConfigurationContainer
    implements Serializable, InputLocationTracker
{
    /**
     * The identifier of this execution for labelling the goals during the build,
     * and for matching executions to merge during inheritance and profile injection.
     */
    final String id;
    /**
     * The build lifecycle phase to bind the goals in this execution to. If omitted,
     * the goals will be bound to the default phase specified by the plugin.
     */
    final String phase;
    /**
     * The priority of this execution compared to other executions which are bound to the same phase.
     * Executions derived from the default lifecycle have a negative priority by default so that they are executed
     * before any custom plugin executions.
     * @since Maven 4.0.0
     */
    final int priority;
    /**
     * The goals to execute with the given configuration.
     */
    final List<String> goals;

    /**
      * Constructor for this class, package protected.
      * @see Builder#build()
      */
    PluginExecution(
        String inherited,
        XmlNode configuration,
        String id,
        String phase,
        int priority,
        Collection<String> goals,
        Map<Object, InputLocation> locations
    ) {
        super(
            inherited,
            configuration,
            locations
        );
        this.id = id;
        this.phase = phase;
        this.priority = priority;
        this.goals = ImmutableCollections.copy(goals);
    }

    /**
     * The identifier of this execution for labelling the goals during the build,
     * and for matching executions to merge during inheritance and profile injection.
     *
     * @return a {@code String}
     */
    public String getId() {
        return this.id;
    }

    /**
     * The build lifecycle phase to bind the goals in this execution to. If omitted,
     * the goals will be bound to the default phase specified by the plugin.
     *
     * @return a {@code String}
     */
    public String getPhase() {
        return this.phase;
    }

    /**
     * The priority of this execution compared to other executions which are bound to the same phase.
     * Executions derived from the default lifecycle have a negative priority by default so that they are executed
     * before any custom plugin executions.
     * @since Maven 4.0.0
     *
     * @return a {@code int}
     */
    public int getPriority() {
        return this.priority;
    }

    /**
     * The goals to execute with the given configuration.
     *
     * @return a {@code List<String>}
     */
    @Nonnull
    public List<String> getGoals() {
        return this.goals;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with() {
        return newBuilder(this);
    }
    /**
     * Creates a new {@code PluginExecution} instance using the specified inherited.
     *
     * @param inherited the new {@code String} to use
     * @return a {@code PluginExecution} with the specified inherited
     */
    @Nonnull
    public PluginExecution withInherited(String inherited) {
        return newBuilder(this, true).inherited(inherited).build();
    }
    /**
     * Creates a new {@code PluginExecution} instance using the specified configuration.
     *
     * @param configuration the new {@code XmlNode} to use
     * @return a {@code PluginExecution} with the specified configuration
     */
    @Nonnull
    public PluginExecution withConfiguration(XmlNode configuration) {
        return newBuilder(this, true).configuration(configuration).build();
    }
    /**
     * Creates a new {@code PluginExecution} instance using the specified id.
     *
     * @param id the new {@code String} to use
     * @return a {@code PluginExecution} with the specified id
     */
    @Nonnull
    public PluginExecution withId(String id) {
        return newBuilder(this, true).id(id).build();
    }
    /**
     * Creates a new {@code PluginExecution} instance using the specified phase.
     *
     * @param phase the new {@code String} to use
     * @return a {@code PluginExecution} with the specified phase
     */
    @Nonnull
    public PluginExecution withPhase(String phase) {
        return newBuilder(this, true).phase(phase).build();
    }
    /**
     * Creates a new {@code PluginExecution} instance using the specified priority.
     *
     * @param priority the new {@code int} to use
     * @return a {@code PluginExecution} with the specified priority
     */
    @Nonnull
    public PluginExecution withPriority(int priority) {
        return newBuilder(this, true).priority(priority).build();
    }
    /**
     * Creates a new {@code PluginExecution} instance using the specified goals.
     *
     * @param goals the new {@code Collection<String>} to use
     * @return a {@code PluginExecution} with the specified goals
     */
    @Nonnull
    public PluginExecution withGoals(Collection<String> goals) {
        return newBuilder(this, true).goals(goals).build();
    }

    /**
     * Creates a new {@code PluginExecution} instance.
     * Equivalent to {@code newInstance(true)}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code PluginExecution}
     */
    @Nonnull
    public static PluginExecution newInstance() {
        return newInstance(true);
    }

    /**
     * Creates a new {@code PluginExecution} instance using default values or not.
     * Equivalent to {@code newBuilder(withDefaults).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code PluginExecution}
     */
    @Nonnull
    public static PluginExecution newInstance(boolean withDefaults) {
        return newBuilder(withDefaults).build();
    }

    /**
     * Creates a new {@code PluginExecution} builder instance.
     * Equivalent to {@code newBuilder(true)}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder() {
        return newBuilder(true);
    }

    /**
     * Creates a new {@code PluginExecution} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    /**
     * Creates a new {@code PluginExecution} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder(from, false)}.
     *
     * @param from the {@code PluginExecution} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(PluginExecution from) {
        return newBuilder(from, false);
    }

    /**
     * Creates a new {@code PluginExecution} builder instance using the specified object as a basis.
     *
     * @param from the {@code PluginExecution} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(PluginExecution from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    /**
     * Builder class used to create PluginExecution instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
        extends ConfigurationContainer.Builder
    {
        PluginExecution base;
        String id;
        String phase;
        Integer priority;
        Collection<String> goals;

        Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
                this.id = "default";
                this.priority = 0;
            }
        }

        Builder(PluginExecution base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.id = base.id;
                this.phase = base.phase;
                this.priority = base.priority;
                this.goals = base.goals;
                this.locations = base.locations;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder inherited(String inherited) {
            this.inherited = inherited;
            return this;
        }

        @Nonnull
        public Builder configuration(XmlNode configuration) {
            this.configuration = configuration;
            return this;
        }

        @Nonnull
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        @Nonnull
        public Builder phase(String phase) {
            this.phase = phase;
            return this;
        }

        @Nonnull
        public Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        @Nonnull
        public Builder goals(Collection<String> goals) {
            this.goals = goals;
            return this;
        }


        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<>(this.locations) : new HashMap<>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public PluginExecution build() {
            if (base != null
                    && (inherited == null || inherited == base.inherited)
                    && (configuration == null || configuration == base.configuration)
                    && (id == null || id == base.id)
                    && (phase == null || phase == base.phase)
                    && (priority == null || priority == base.priority)
                    && (goals == null || goals == base.goals)
            ) {
                return base;
            }
            Map<Object, InputLocation> newlocs = this.locations != null ? this.locations : Collections.emptyMap();
            Map<Object, InputLocation> oldlocs = this.base != null && this.base.locations != null ? this.base.locations : Collections.emptyMap();
            Map<Object, InputLocation> locations = new HashMap<>();
            locations.put("", newlocs.containsKey("") ? newlocs.get("") : oldlocs.get(""));
            locations.put("inherited", newlocs.containsKey("inherited") ? newlocs.get("inherited") : oldlocs.get("inherited"));
            locations.put("configuration", newlocs.containsKey("configuration") ? newlocs.get("configuration") : oldlocs.get("configuration"));
            locations.put("id", newlocs.containsKey("id") ? newlocs.get("id") : oldlocs.get("id"));
            locations.put("phase", newlocs.containsKey("phase") ? newlocs.get("phase") : oldlocs.get("phase"));
            locations.put("priority", newlocs.containsKey("priority") ? newlocs.get("priority") : oldlocs.get("priority"));
            locations.put("goals", newlocs.containsKey("goals") ? newlocs.get("goals") : oldlocs.get("goals"));
            return new PluginExecution(
                inherited != null ? inherited : (base != null ? base.inherited : null),
                configuration != null ? configuration : (base != null ? base.configuration : null),
                id != null ? id : (base != null ? base.id : null),
                phase != null ? phase : (base != null ? base.phase : null),
                priority != null ? priority : (base != null ? base.priority : 0),
                goals != null ? goals : (base != null ? base.goals : null),
                locations
            );
        }
    }


            
    public static final String DEFAULT_EXECUTION_ID = "default";

    @Override
    public String toString() {
        return getId();
    }
            
          
}
