// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * The {@code <ciManagement>} element contains information required to the
 * continuous integration system of the project.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class CiManagement
    implements Serializable, InputLocationTracker
{
    /**
     * The name of the continuous integration system, e.g. {@code continuum}.
     */
    final String system;
    /**
     * URL for the continuous integration system used by the project if it has a web interface.
     */
    final String url;
    /**
     * Configuration for notifying developers/users when a build is unsuccessful,
     * including user information and notification mode.
     */
    final List<Notifier> notifiers;
    /** Locations */
    final Map<Object, InputLocation> locations;

    /**
      * Constructor for this class, package protected.
      * @see Builder#build()
      */
    CiManagement(
        String system,
        String url,
        Collection<Notifier> notifiers,
        Map<Object, InputLocation> locations
    ) {
        this.system = system;
        this.url = url;
        this.notifiers = ImmutableCollections.copy(notifiers);
        this.locations = ImmutableCollections.copy(locations);
    }

    /**
     * The name of the continuous integration system, e.g. {@code continuum}.
     *
     * @return a {@code String}
     */
    public String getSystem() {
        return this.system;
    }

    /**
     * URL for the continuous integration system used by the project if it has a web interface.
     *
     * @return a {@code String}
     */
    public String getUrl() {
        return this.url;
    }

    /**
     * Configuration for notifying developers/users when a build is unsuccessful,
     * including user information and notification mode.
     *
     * @return a {@code List<Notifier>}
     */
    @Nonnull
    public List<Notifier> getNotifiers() {
        return this.notifiers;
    }

    /**
     * Gets the location of the specified field in the input source.
     */
    public InputLocation getLocation(Object key) {
        return locations != null ? locations.get(key) : null;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with() {
        return newBuilder(this);
    }
    /**
     * Creates a new {@code CiManagement} instance using the specified system.
     *
     * @param system the new {@code String} to use
     * @return a {@code CiManagement} with the specified system
     */
    @Nonnull
    public CiManagement withSystem(String system) {
        return newBuilder(this, true).system(system).build();
    }
    /**
     * Creates a new {@code CiManagement} instance using the specified url.
     *
     * @param url the new {@code String} to use
     * @return a {@code CiManagement} with the specified url
     */
    @Nonnull
    public CiManagement withUrl(String url) {
        return newBuilder(this, true).url(url).build();
    }
    /**
     * Creates a new {@code CiManagement} instance using the specified notifiers.
     *
     * @param notifiers the new {@code Collection<Notifier>} to use
     * @return a {@code CiManagement} with the specified notifiers
     */
    @Nonnull
    public CiManagement withNotifiers(Collection<Notifier> notifiers) {
        return newBuilder(this, true).notifiers(notifiers).build();
    }

    /**
     * Creates a new {@code CiManagement} instance.
     * Equivalent to {@code newInstance(true)}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code CiManagement}
     */
    @Nonnull
    public static CiManagement newInstance() {
        return newInstance(true);
    }

    /**
     * Creates a new {@code CiManagement} instance using default values or not.
     * Equivalent to {@code newBuilder(withDefaults).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code CiManagement}
     */
    @Nonnull
    public static CiManagement newInstance(boolean withDefaults) {
        return newBuilder(withDefaults).build();
    }

    /**
     * Creates a new {@code CiManagement} builder instance.
     * Equivalent to {@code newBuilder(true)}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder() {
        return newBuilder(true);
    }

    /**
     * Creates a new {@code CiManagement} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    /**
     * Creates a new {@code CiManagement} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder(from, false)}.
     *
     * @param from the {@code CiManagement} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(CiManagement from) {
        return newBuilder(from, false);
    }

    /**
     * Creates a new {@code CiManagement} builder instance using the specified object as a basis.
     *
     * @param from the {@code CiManagement} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(CiManagement from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    /**
     * Builder class used to create CiManagement instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
    {
        CiManagement base;
        String system;
        String url;
        Collection<Notifier> notifiers;
        Map<Object, InputLocation> locations;

        Builder(boolean withDefaults) {
            if (withDefaults) {
            }
        }

        Builder(CiManagement base, boolean forceCopy) {
            if (forceCopy) {
                this.system = base.system;
                this.url = base.url;
                this.notifiers = base.notifiers;
                this.locations = base.locations;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder system(String system) {
            this.system = system;
            return this;
        }

        @Nonnull
        public Builder url(String url) {
            this.url = url;
            return this;
        }

        @Nonnull
        public Builder notifiers(Collection<Notifier> notifiers) {
            this.notifiers = notifiers;
            return this;
        }


        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<>(this.locations) : new HashMap<>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public CiManagement build() {
            if (base != null
                    && (system == null || system == base.system)
                    && (url == null || url == base.url)
                    && (notifiers == null || notifiers == base.notifiers)
            ) {
                return base;
            }
            Map<Object, InputLocation> newlocs = this.locations != null ? this.locations : Collections.emptyMap();
            Map<Object, InputLocation> oldlocs = this.base != null && this.base.locations != null ? this.base.locations : Collections.emptyMap();
            Map<Object, InputLocation> locations = new HashMap<>();
            locations.put("", newlocs.containsKey("") ? newlocs.get("") : oldlocs.get(""));
            locations.put("system", newlocs.containsKey("system") ? newlocs.get("system") : oldlocs.get("system"));
            locations.put("url", newlocs.containsKey("url") ? newlocs.get("url") : oldlocs.get("url"));
            locations.put("notifiers", newlocs.containsKey("notifiers") ? newlocs.get("notifiers") : oldlocs.get("notifiers"));
            return new CiManagement(
                system != null ? system : (base != null ? base.system : null),
                url != null ? url : (base != null ? base.url : null),
                notifiers != null ? notifiers : (base != null ? base.notifiers : null),
                locations
            );
        }
    }

}
