/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.Activation;
import org.apache.maven.api.model.BuildBase;
import org.apache.maven.api.model.Dependency;
import org.apache.maven.api.model.DependencyManagement;
import org.apache.maven.api.model.DistributionManagement;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;
import org.apache.maven.api.model.ModelBase;
import org.apache.maven.api.model.Reporting;
import org.apache.maven.api.model.Repository;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class Profile
extends ModelBase
implements Serializable,
InputLocationTracker {
    final String id;
    final Activation activation;
    final BuildBase build;
    public static final String SOURCE_POM = "pom";
    public static final String SOURCE_SETTINGS = "settings.xml";
    private String source = "pom";

    Profile(Collection<String> modules, DistributionManagement distributionManagement, Map<String, String> properties, DependencyManagement dependencyManagement, Collection<Dependency> dependencies, Collection<Repository> repositories, Collection<Repository> pluginRepositories, Reporting reporting, String id, Activation activation, BuildBase build, Map<Object, InputLocation> locations) {
        super(modules, distributionManagement, properties, dependencyManagement, dependencies, repositories, pluginRepositories, reporting, locations);
        this.id = id;
        this.activation = activation;
        this.build = build;
    }

    public String getId() {
        return this.id;
    }

    public Activation getActivation() {
        return this.activation;
    }

    public BuildBase getBuild() {
        return this.build;
    }

    @Override
    @Nonnull
    public Builder with() {
        return Profile.newBuilder(this);
    }

    @Override
    @Nonnull
    public Profile withModules(Collection<String> modules) {
        return ((Builder)Profile.newBuilder(this, true).modules((Collection)modules)).build();
    }

    @Override
    @Nonnull
    public Profile withDistributionManagement(DistributionManagement distributionManagement) {
        return Profile.newBuilder(this, true).distributionManagement(distributionManagement).build();
    }

    @Override
    @Nonnull
    public Profile withProperties(Map<String, String> properties) {
        return ((Builder)Profile.newBuilder(this, true).properties((Map)properties)).build();
    }

    @Override
    @Nonnull
    public Profile withDependencyManagement(DependencyManagement dependencyManagement) {
        return Profile.newBuilder(this, true).dependencyManagement(dependencyManagement).build();
    }

    @Override
    @Nonnull
    public Profile withDependencies(Collection<Dependency> dependencies) {
        return ((Builder)Profile.newBuilder(this, true).dependencies((Collection)dependencies)).build();
    }

    @Override
    @Nonnull
    public Profile withRepositories(Collection<Repository> repositories) {
        return ((Builder)Profile.newBuilder(this, true).repositories((Collection)repositories)).build();
    }

    @Override
    @Nonnull
    public Profile withPluginRepositories(Collection<Repository> pluginRepositories) {
        return ((Builder)Profile.newBuilder(this, true).pluginRepositories((Collection)pluginRepositories)).build();
    }

    @Override
    @Nonnull
    public Profile withReporting(Reporting reporting) {
        return Profile.newBuilder(this, true).reporting(reporting).build();
    }

    @Nonnull
    public Profile withId(String id) {
        return Profile.newBuilder(this, true).id(id).build();
    }

    @Nonnull
    public Profile withActivation(Activation activation) {
        return Profile.newBuilder(this, true).activation(activation).build();
    }

    @Nonnull
    public Profile withBuild(BuildBase build) {
        return Profile.newBuilder(this, true).build(build).build();
    }

    @Nonnull
    public static Profile newInstance() {
        return Profile.newInstance(true);
    }

    @Nonnull
    public static Profile newInstance(boolean withDefaults) {
        return Profile.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Profile.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Profile from) {
        return Profile.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Profile from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public String toString() {
        return "Profile {id: " + this.getId() + ", source: " + this.getSource() + "}";
    }

    @NotThreadSafe
    public static class Builder
    extends ModelBase.Builder {
        Profile base;
        String id;
        Activation activation;
        BuildBase build;

        Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
                this.id = "default";
            }
        }

        Builder(Profile base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.id = base.id;
                this.activation = base.activation;
                this.build = base.build;
                this.locations = base.locations;
            } else {
                this.base = base;
            }
        }

        @Override
        @Nonnull
        public Builder modules(Collection<String> modules) {
            this.modules = modules;
            return this;
        }

        @Override
        @Nonnull
        public Builder distributionManagement(DistributionManagement distributionManagement) {
            this.distributionManagement = distributionManagement;
            return this;
        }

        @Override
        @Nonnull
        public Builder properties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        @Override
        @Nonnull
        public Builder dependencyManagement(DependencyManagement dependencyManagement) {
            this.dependencyManagement = dependencyManagement;
            return this;
        }

        @Override
        @Nonnull
        public Builder dependencies(Collection<Dependency> dependencies) {
            this.dependencies = dependencies;
            return this;
        }

        @Override
        @Nonnull
        public Builder repositories(Collection<Repository> repositories) {
            this.repositories = repositories;
            return this;
        }

        @Override
        @Nonnull
        public Builder pluginRepositories(Collection<Repository> pluginRepositories) {
            this.pluginRepositories = pluginRepositories;
            return this;
        }

        @Override
        @Nonnull
        public Builder reporting(Reporting reporting) {
            this.reporting = reporting;
            return this;
        }

        @Nonnull
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        @Nonnull
        public Builder activation(Activation activation) {
            this.activation = activation;
            return this;
        }

        @Nonnull
        public Builder build(BuildBase build) {
            this.build = build;
            return this;
        }

        @Override
        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Override
        @Nonnull
        public Profile build() {
            if (!(this.base == null || this.modules != null && this.modules != this.base.modules || this.distributionManagement != null && this.distributionManagement != this.base.distributionManagement || this.properties != null && this.properties != this.base.properties || this.dependencyManagement != null && this.dependencyManagement != this.base.dependencyManagement || this.dependencies != null && this.dependencies != this.base.dependencies || this.repositories != null && this.repositories != this.base.repositories || this.pluginRepositories != null && this.pluginRepositories != this.base.pluginRepositories || this.reporting != null && this.reporting != this.base.reporting || this.id != null && this.id != this.base.id || this.activation != null && this.activation != this.base.activation || this.build != null && this.build != this.base.build)) {
                return this.base;
            }
            Map newlocs = this.locations != null ? this.locations : Collections.emptyMap();
            Map oldlocs = this.base != null && this.base.locations != null ? this.base.locations : Collections.emptyMap();
            HashMap<Object, InputLocation> locations = new HashMap<Object, InputLocation>();
            locations.put("", newlocs.containsKey("") ? (InputLocation)newlocs.get("") : (InputLocation)oldlocs.get(""));
            locations.put("modules", newlocs.containsKey("modules") ? (InputLocation)newlocs.get("modules") : (InputLocation)oldlocs.get("modules"));
            locations.put("distributionManagement", newlocs.containsKey("distributionManagement") ? (InputLocation)newlocs.get("distributionManagement") : (InputLocation)oldlocs.get("distributionManagement"));
            locations.put("properties", newlocs.containsKey("properties") ? (InputLocation)newlocs.get("properties") : (InputLocation)oldlocs.get("properties"));
            locations.put("dependencyManagement", newlocs.containsKey("dependencyManagement") ? (InputLocation)newlocs.get("dependencyManagement") : (InputLocation)oldlocs.get("dependencyManagement"));
            locations.put("dependencies", newlocs.containsKey("dependencies") ? (InputLocation)newlocs.get("dependencies") : (InputLocation)oldlocs.get("dependencies"));
            locations.put("repositories", newlocs.containsKey("repositories") ? (InputLocation)newlocs.get("repositories") : (InputLocation)oldlocs.get("repositories"));
            locations.put("pluginRepositories", newlocs.containsKey("pluginRepositories") ? (InputLocation)newlocs.get("pluginRepositories") : (InputLocation)oldlocs.get("pluginRepositories"));
            locations.put("reporting", newlocs.containsKey("reporting") ? (InputLocation)newlocs.get("reporting") : (InputLocation)oldlocs.get("reporting"));
            locations.put("id", newlocs.containsKey("id") ? (InputLocation)newlocs.get("id") : (InputLocation)oldlocs.get("id"));
            locations.put("activation", newlocs.containsKey("activation") ? (InputLocation)newlocs.get("activation") : (InputLocation)oldlocs.get("activation"));
            locations.put("build", newlocs.containsKey("build") ? (InputLocation)newlocs.get("build") : (InputLocation)oldlocs.get("build"));
            return new Profile(this.modules != null ? this.modules : (this.base != null ? this.base.modules : null), this.distributionManagement != null ? this.distributionManagement : (this.base != null ? this.base.distributionManagement : null), this.properties != null ? this.properties : (this.base != null ? this.base.properties : null), this.dependencyManagement != null ? this.dependencyManagement : (this.base != null ? this.base.dependencyManagement : null), this.dependencies != null ? this.dependencies : (this.base != null ? this.base.dependencies : null), this.repositories != null ? this.repositories : (this.base != null ? this.base.repositories : null), this.pluginRepositories != null ? this.pluginRepositories : (this.base != null ? this.base.pluginRepositories : null), this.reporting != null ? this.reporting : (this.base != null ? this.base.reporting : null), this.id != null ? this.id : (this.base != null ? this.base.id : null), this.activation != null ? this.activation : (this.base != null ? this.base.activation : null), this.build != null ? this.build : (this.base != null ? this.base.build : null), locations);
        }
    }
}

