/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;
import org.apache.maven.api.model.RepositoryBase;
import org.apache.maven.api.model.RepositoryPolicy;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class Repository
extends RepositoryBase
implements Serializable,
InputLocationTracker {
    final RepositoryPolicy releases;
    final RepositoryPolicy snapshots;
    final InputLocation releasesLocation;
    final InputLocation snapshotsLocation;

    Repository(String id, String name, String url, String layout, RepositoryPolicy releases, RepositoryPolicy snapshots, Map<Object, InputLocation> locations, InputLocation location, InputLocation idLocation, InputLocation nameLocation, InputLocation urlLocation, InputLocation layoutLocation, InputLocation releasesLocation, InputLocation snapshotsLocation) {
        super(id, name, url, layout, locations, location, idLocation, nameLocation, urlLocation, layoutLocation);
        this.releases = releases;
        this.snapshots = snapshots;
        this.releasesLocation = releasesLocation;
        this.snapshotsLocation = snapshotsLocation;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Repository)) {
            return false;
        }
        Repository that = (Repository)o;
        return Objects.equals(this.id, that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.id);
    }

    public RepositoryPolicy getReleases() {
        return this.releases;
    }

    public RepositoryPolicy getSnapshots() {
        return this.snapshots;
    }

    @Override
    public InputLocation getLocation(Object key) {
        if (key instanceof String) {
            switch ((String)key) {
                case "releases": {
                    return this.releasesLocation;
                }
                case "snapshots": {
                    return this.snapshotsLocation;
                }
            }
        }
        return super.getLocation(key);
    }

    @Override
    @Nonnull
    public Builder with() {
        return Repository.newBuilder(this);
    }

    @Override
    @Nonnull
    public Repository withId(String id) {
        return this.with().id(id).build();
    }

    @Override
    @Nonnull
    public Repository withName(String name) {
        return this.with().name(name).build();
    }

    @Override
    @Nonnull
    public Repository withUrl(String url) {
        return this.with().url(url).build();
    }

    @Override
    @Nonnull
    public Repository withLayout(String layout) {
        return this.with().layout(layout).build();
    }

    @Nonnull
    public Repository withReleases(RepositoryPolicy releases) {
        return this.with().releases(releases).build();
    }

    @Nonnull
    public Repository withSnapshots(RepositoryPolicy snapshots) {
        return this.with().snapshots(snapshots).build();
    }

    @Nonnull
    public static Repository newInstance() {
        return Repository.newInstance(true);
    }

    @Nonnull
    public static Repository newInstance(boolean withDefaults) {
        return Repository.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Repository.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Repository from) {
        return Repository.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Repository from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @NotThreadSafe
    public static class Builder
    extends RepositoryBase.Builder {
        Repository base;
        RepositoryPolicy releases;
        RepositoryPolicy snapshots;

        Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
                // empty if block
            }
        }

        Builder(Repository base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.releases = base.releases;
                this.snapshots = base.snapshots;
            } else {
                this.base = base;
            }
        }

        @Override
        @Nonnull
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        @Nonnull
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        @Nonnull
        public Builder url(String url) {
            this.url = url;
            return this;
        }

        @Override
        @Nonnull
        public Builder layout(String layout) {
            this.layout = layout;
            return this;
        }

        @Nonnull
        public Builder releases(RepositoryPolicy releases) {
            this.releases = releases;
            return this;
        }

        @Nonnull
        public Builder snapshots(RepositoryPolicy snapshots) {
            this.snapshots = snapshots;
            return this;
        }

        @Override
        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (this.locations == null) {
                    this.locations = new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Override
        @Nonnull
        public Repository build() {
            if (!(this.base == null || this.id != null && this.id != this.base.id || this.name != null && this.name != this.base.name || this.url != null && this.url != this.base.url || this.layout != null && this.layout != this.base.layout || this.releases != null && this.releases != this.base.releases || this.snapshots != null && this.snapshots != this.base.snapshots)) {
                return this.base;
            }
            Map locations = null;
            InputLocation location = null;
            InputLocation idLocation = null;
            InputLocation nameLocation = null;
            InputLocation urlLocation = null;
            InputLocation layoutLocation = null;
            InputLocation releasesLocation = null;
            InputLocation snapshotsLocation = null;
            if (this.locations != null) {
                locations = this.locations;
                location = (InputLocation)locations.remove("");
                idLocation = (InputLocation)locations.remove("id");
                nameLocation = (InputLocation)locations.remove("name");
                urlLocation = (InputLocation)locations.remove("url");
                layoutLocation = (InputLocation)locations.remove("layout");
                releasesLocation = (InputLocation)locations.remove("releases");
                snapshotsLocation = (InputLocation)locations.remove("snapshots");
            }
            return new Repository(this.id != null ? this.id : (this.base != null ? this.base.id : null), this.name != null ? this.name : (this.base != null ? this.base.name : null), this.url != null ? this.url : (this.base != null ? this.base.url : null), this.layout != null ? this.layout : (this.base != null ? this.base.layout : null), this.releases != null ? this.releases : (this.base != null ? this.base.releases : null), this.snapshots != null ? this.snapshots : (this.base != null ? this.base.snapshots : null), locations != null ? locations : (this.base != null ? this.base.locations : null), location != null ? location : (this.base != null ? this.base.location : null), idLocation != null ? idLocation : (this.base != null ? this.base.idLocation : null), nameLocation != null ? nameLocation : (this.base != null ? this.base.nameLocation : null), urlLocation != null ? urlLocation : (this.base != null ? this.base.urlLocation : null), layoutLocation != null ? layoutLocation : (this.base != null ? this.base.layoutLocation : null), releasesLocation != null ? releasesLocation : (this.base != null ? this.base.releasesLocation : null), snapshotsLocation != null ? snapshotsLocation : (this.base != null ? this.base.snapshotsLocation : null));
        }
    }
}

