/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.ImmutableCollections;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;
import org.apache.maven.api.model.ReportPlugin;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class Reporting
implements Serializable,
InputLocationTracker {
    final String excludeDefaults;
    final String outputDirectory;
    final List<ReportPlugin> plugins;
    final InputLocation location;
    final InputLocation excludeDefaultsLocation;
    final InputLocation outputDirectoryLocation;
    final InputLocation pluginsLocation;
    final Map<Object, InputLocation> locations;

    Reporting(String excludeDefaults, String outputDirectory, Collection<ReportPlugin> plugins, Map<Object, InputLocation> locations, InputLocation location, InputLocation excludeDefaultsLocation, InputLocation outputDirectoryLocation, InputLocation pluginsLocation) {
        this.excludeDefaults = excludeDefaults;
        this.outputDirectory = outputDirectory;
        this.plugins = ImmutableCollections.copy(plugins);
        this.locations = ImmutableCollections.copy(locations);
        this.location = location;
        this.excludeDefaultsLocation = excludeDefaultsLocation;
        this.outputDirectoryLocation = outputDirectoryLocation;
        this.pluginsLocation = pluginsLocation;
    }

    public String getExcludeDefaults() {
        return this.excludeDefaults;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    @Nonnull
    public List<ReportPlugin> getPlugins() {
        return this.plugins;
    }

    @Override
    public InputLocation getLocation(Object key) {
        if (key instanceof String) {
            switch ((String)key) {
                case "": {
                    return this.location;
                }
                case "excludeDefaults": {
                    return this.excludeDefaultsLocation;
                }
                case "outputDirectory": {
                    return this.outputDirectoryLocation;
                }
                case "plugins": {
                    return this.pluginsLocation;
                }
            }
        }
        return this.locations != null ? this.locations.get(key) : null;
    }

    @Nonnull
    public Builder with() {
        return Reporting.newBuilder(this);
    }

    @Nonnull
    public Reporting withExcludeDefaults(String excludeDefaults) {
        return this.with().excludeDefaults(excludeDefaults).build();
    }

    @Nonnull
    public Reporting withOutputDirectory(String outputDirectory) {
        return this.with().outputDirectory(outputDirectory).build();
    }

    @Nonnull
    public Reporting withPlugins(Collection<ReportPlugin> plugins) {
        return this.with().plugins(plugins).build();
    }

    @Nonnull
    public static Reporting newInstance() {
        return Reporting.newInstance(true);
    }

    @Nonnull
    public static Reporting newInstance(boolean withDefaults) {
        return Reporting.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Reporting.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Reporting from) {
        return Reporting.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Reporting from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    public boolean isExcludeDefaults() {
        return this.getExcludeDefaults() != null ? Boolean.parseBoolean(this.getExcludeDefaults()) : false;
    }

    @NotThreadSafe
    public static class Builder {
        Reporting base;
        String excludeDefaults;
        String outputDirectory;
        Collection<ReportPlugin> plugins;
        Map<Object, InputLocation> locations;

        Builder(boolean withDefaults) {
            if (withDefaults) {
                // empty if block
            }
        }

        Builder(Reporting base, boolean forceCopy) {
            if (forceCopy) {
                this.excludeDefaults = base.excludeDefaults;
                this.outputDirectory = base.outputDirectory;
                this.plugins = base.plugins;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder excludeDefaults(String excludeDefaults) {
            this.excludeDefaults = excludeDefaults;
            return this;
        }

        @Nonnull
        public Builder outputDirectory(String outputDirectory) {
            this.outputDirectory = outputDirectory;
            return this;
        }

        @Nonnull
        public Builder plugins(Collection<ReportPlugin> plugins) {
            this.plugins = plugins;
            return this;
        }

        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (this.locations == null) {
                    this.locations = new HashMap<Object, InputLocation>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Reporting build() {
            if (!(this.base == null || this.excludeDefaults != null && this.excludeDefaults != this.base.excludeDefaults || this.outputDirectory != null && this.outputDirectory != this.base.outputDirectory || this.plugins != null && this.plugins != this.base.plugins)) {
                return this.base;
            }
            Map<Object, InputLocation> locations = null;
            InputLocation location = null;
            InputLocation excludeDefaultsLocation = null;
            InputLocation outputDirectoryLocation = null;
            InputLocation pluginsLocation = null;
            if (this.locations != null) {
                locations = this.locations;
                location = locations.remove("");
                excludeDefaultsLocation = locations.remove("excludeDefaults");
                outputDirectoryLocation = locations.remove("outputDirectory");
                pluginsLocation = locations.remove("plugins");
            }
            return new Reporting(this.excludeDefaults != null ? this.excludeDefaults : (this.base != null ? this.base.excludeDefaults : null), this.outputDirectory != null ? this.outputDirectory : (this.base != null ? this.base.outputDirectory : null), this.plugins != null ? this.plugins : (this.base != null ? this.base.plugins : null), locations != null ? locations : (this.base != null ? this.base.locations : null), location != null ? location : (this.base != null ? this.base.location : null), excludeDefaultsLocation != null ? excludeDefaultsLocation : (this.base != null ? this.base.excludeDefaultsLocation : null), outputDirectoryLocation != null ? outputDirectoryLocation : (this.base != null ? this.base.outputDirectoryLocation : null), pluginsLocation != null ? pluginsLocation : (this.base != null ? this.base.pluginsLocation : null));
        }
    }
}

