/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.ImmutableCollections;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class Relocation
implements Serializable,
InputLocationTracker {
    final String groupId;
    final String artifactId;
    final String version;
    final String message;
    final InputLocation location;
    final InputLocation groupIdLocation;
    final InputLocation artifactIdLocation;
    final InputLocation versionLocation;
    final InputLocation messageLocation;
    final Map<Object, InputLocation> locations;

    Relocation(String groupId, String artifactId, String version, String message, Map<Object, InputLocation> locations, InputLocation location, InputLocation groupIdLocation, InputLocation artifactIdLocation, InputLocation versionLocation, InputLocation messageLocation) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.message = message;
        this.locations = ImmutableCollections.copy(locations);
        this.location = location;
        this.groupIdLocation = groupIdLocation;
        this.artifactIdLocation = artifactIdLocation;
        this.versionLocation = versionLocation;
        this.messageLocation = messageLocation;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getMessage() {
        return this.message;
    }

    @Override
    public InputLocation getLocation(Object key) {
        if (key instanceof String) {
            switch ((String)key) {
                case "": {
                    return this.location;
                }
                case "groupId": {
                    return this.groupIdLocation;
                }
                case "artifactId": {
                    return this.artifactIdLocation;
                }
                case "version": {
                    return this.versionLocation;
                }
                case "message": {
                    return this.messageLocation;
                }
            }
        }
        return this.locations != null ? this.locations.get(key) : null;
    }

    @Nonnull
    public Builder with() {
        return Relocation.newBuilder(this);
    }

    @Nonnull
    public Relocation withGroupId(String groupId) {
        return this.with().groupId(groupId).build();
    }

    @Nonnull
    public Relocation withArtifactId(String artifactId) {
        return this.with().artifactId(artifactId).build();
    }

    @Nonnull
    public Relocation withVersion(String version) {
        return this.with().version(version).build();
    }

    @Nonnull
    public Relocation withMessage(String message) {
        return this.with().message(message).build();
    }

    @Nonnull
    public static Relocation newInstance() {
        return Relocation.newInstance(true);
    }

    @Nonnull
    public static Relocation newInstance(boolean withDefaults) {
        return Relocation.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Relocation.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Relocation from) {
        return Relocation.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Relocation from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @NotThreadSafe
    public static class Builder {
        Relocation base;
        String groupId;
        String artifactId;
        String version;
        String message;
        Map<Object, InputLocation> locations;

        Builder(boolean withDefaults) {
            if (withDefaults) {
                // empty if block
            }
        }

        Builder(Relocation base, boolean forceCopy) {
            if (forceCopy) {
                this.groupId = base.groupId;
                this.artifactId = base.artifactId;
                this.version = base.version;
                this.message = base.message;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        @Nonnull
        public Builder artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        @Nonnull
        public Builder version(String version) {
            this.version = version;
            return this;
        }

        @Nonnull
        public Builder message(String message) {
            this.message = message;
            return this;
        }

        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (this.locations == null) {
                    this.locations = new HashMap<Object, InputLocation>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Relocation build() {
            if (!(this.base == null || this.groupId != null && this.groupId != this.base.groupId || this.artifactId != null && this.artifactId != this.base.artifactId || this.version != null && this.version != this.base.version || this.message != null && this.message != this.base.message)) {
                return this.base;
            }
            Map<Object, InputLocation> locations = null;
            InputLocation location = null;
            InputLocation groupIdLocation = null;
            InputLocation artifactIdLocation = null;
            InputLocation versionLocation = null;
            InputLocation messageLocation = null;
            if (this.locations != null) {
                locations = this.locations;
                location = locations.remove("");
                groupIdLocation = locations.remove("groupId");
                artifactIdLocation = locations.remove("artifactId");
                versionLocation = locations.remove("version");
                messageLocation = locations.remove("message");
            }
            return new Relocation(this.groupId != null ? this.groupId : (this.base != null ? this.base.groupId : null), this.artifactId != null ? this.artifactId : (this.base != null ? this.base.artifactId : null), this.version != null ? this.version : (this.base != null ? this.base.version : null), this.message != null ? this.message : (this.base != null ? this.base.message : null), locations != null ? locations : (this.base != null ? this.base.locations : null), location != null ? location : (this.base != null ? this.base.location : null), groupIdLocation != null ? groupIdLocation : (this.base != null ? this.base.groupIdLocation : null), artifactIdLocation != null ? artifactIdLocation : (this.base != null ? this.base.artifactIdLocation : null), versionLocation != null ? versionLocation : (this.base != null ? this.base.versionLocation : null), messageLocation != null ? messageLocation : (this.base != null ? this.base.messageLocation : null));
        }
    }
}

