/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.ImmutableCollections;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class ActivationOS
implements Serializable,
InputLocationTracker {
    final String name;
    final String family;
    final String arch;
    final String version;
    final InputLocation location;
    final InputLocation nameLocation;
    final InputLocation familyLocation;
    final InputLocation archLocation;
    final InputLocation versionLocation;
    final Map<Object, InputLocation> locations;

    ActivationOS(String name, String family, String arch, String version, Map<Object, InputLocation> locations, InputLocation location, InputLocation nameLocation, InputLocation familyLocation, InputLocation archLocation, InputLocation versionLocation) {
        this.name = name;
        this.family = family;
        this.arch = arch;
        this.version = version;
        this.locations = ImmutableCollections.copy(locations);
        this.location = location;
        this.nameLocation = nameLocation;
        this.familyLocation = familyLocation;
        this.archLocation = archLocation;
        this.versionLocation = versionLocation;
    }

    public String getName() {
        return this.name;
    }

    public String getFamily() {
        return this.family;
    }

    public String getArch() {
        return this.arch;
    }

    public String getVersion() {
        return this.version;
    }

    @Override
    public InputLocation getLocation(Object key) {
        if (key instanceof String) {
            switch ((String)key) {
                case "": {
                    return this.location;
                }
                case "name": {
                    return this.nameLocation;
                }
                case "family": {
                    return this.familyLocation;
                }
                case "arch": {
                    return this.archLocation;
                }
                case "version": {
                    return this.versionLocation;
                }
            }
        }
        return this.locations != null ? this.locations.get(key) : null;
    }

    @Nonnull
    public Builder with() {
        return ActivationOS.newBuilder(this);
    }

    @Nonnull
    public ActivationOS withName(String name) {
        return this.with().name(name).build();
    }

    @Nonnull
    public ActivationOS withFamily(String family) {
        return this.with().family(family).build();
    }

    @Nonnull
    public ActivationOS withArch(String arch) {
        return this.with().arch(arch).build();
    }

    @Nonnull
    public ActivationOS withVersion(String version) {
        return this.with().version(version).build();
    }

    @Nonnull
    public static ActivationOS newInstance() {
        return ActivationOS.newInstance(true);
    }

    @Nonnull
    public static ActivationOS newInstance(boolean withDefaults) {
        return ActivationOS.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return ActivationOS.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(ActivationOS from) {
        return ActivationOS.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(ActivationOS from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @NotThreadSafe
    public static class Builder {
        ActivationOS base;
        String name;
        String family;
        String arch;
        String version;
        Map<Object, InputLocation> locations;

        Builder(boolean withDefaults) {
            if (withDefaults) {
                // empty if block
            }
        }

        Builder(ActivationOS base, boolean forceCopy) {
            if (forceCopy) {
                this.name = base.name;
                this.family = base.family;
                this.arch = base.arch;
                this.version = base.version;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Nonnull
        public Builder family(String family) {
            this.family = family;
            return this;
        }

        @Nonnull
        public Builder arch(String arch) {
            this.arch = arch;
            return this;
        }

        @Nonnull
        public Builder version(String version) {
            this.version = version;
            return this;
        }

        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (this.locations == null) {
                    this.locations = new HashMap<Object, InputLocation>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public ActivationOS build() {
            if (!(this.base == null || this.name != null && this.name != this.base.name || this.family != null && this.family != this.base.family || this.arch != null && this.arch != this.base.arch || this.version != null && this.version != this.base.version)) {
                return this.base;
            }
            Map<Object, InputLocation> locations = null;
            InputLocation location = null;
            InputLocation nameLocation = null;
            InputLocation familyLocation = null;
            InputLocation archLocation = null;
            InputLocation versionLocation = null;
            if (this.locations != null) {
                locations = this.locations;
                location = locations.remove("");
                nameLocation = locations.remove("name");
                familyLocation = locations.remove("family");
                archLocation = locations.remove("arch");
                versionLocation = locations.remove("version");
            }
            return new ActivationOS(this.name != null ? this.name : (this.base != null ? this.base.name : null), this.family != null ? this.family : (this.base != null ? this.base.family : null), this.arch != null ? this.arch : (this.base != null ? this.base.arch : null), this.version != null ? this.version : (this.base != null ? this.base.version : null), locations != null ? locations : (this.base != null ? this.base.locations : null), location != null ? location : (this.base != null ? this.base.location : null), nameLocation != null ? nameLocation : (this.base != null ? this.base.nameLocation : null), familyLocation != null ? familyLocation : (this.base != null ? this.base.familyLocation : null), archLocation != null ? archLocation : (this.base != null ? this.base.archLocation : null), versionLocation != null ? versionLocation : (this.base != null ? this.base.versionLocation : null));
        }
    }
}

