/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.ImmutableCollections;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class Prerequisites
implements Serializable,
InputLocationTracker {
    final String maven;
    final Map<Object, InputLocation> locations;

    Prerequisites(String maven, Map<Object, InputLocation> locations) {
        this.maven = maven;
        this.locations = ImmutableCollections.copy(locations);
    }

    public String getMaven() {
        return this.maven;
    }

    @Override
    public InputLocation getLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    @Nonnull
    public Builder with() {
        return Prerequisites.newBuilder(this);
    }

    @Nonnull
    public Prerequisites withMaven(String maven) {
        return Prerequisites.newBuilder(this, true).maven(maven).build();
    }

    @Nonnull
    public static Prerequisites newInstance() {
        return Prerequisites.newInstance(true);
    }

    @Nonnull
    public static Prerequisites newInstance(boolean withDefaults) {
        return Prerequisites.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Prerequisites.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Prerequisites from) {
        return Prerequisites.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Prerequisites from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @NotThreadSafe
    public static class Builder {
        Prerequisites base;
        String maven;
        Map<Object, InputLocation> locations;

        Builder(boolean withDefaults) {
            if (withDefaults) {
                this.maven = "2.0";
            }
        }

        Builder(Prerequisites base, boolean forceCopy) {
            if (forceCopy) {
                this.maven = base.maven;
                this.locations = base.locations;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder maven(String maven) {
            this.maven = maven;
            return this;
        }

        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<Object, InputLocation>(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Prerequisites build() {
            if (this.base != null && (this.maven == null || this.maven == this.base.maven)) {
                return this.base;
            }
            Map<Object, Object> newlocs = this.locations != null ? this.locations : Collections.emptyMap();
            Map oldlocs = this.base != null && this.base.locations != null ? this.base.locations : Collections.emptyMap();
            HashMap<Object, InputLocation> locations = new HashMap<Object, InputLocation>();
            locations.put("", newlocs.containsKey("") ? (InputLocation)newlocs.get("") : (InputLocation)oldlocs.get(""));
            locations.put("maven", newlocs.containsKey("maven") ? (InputLocation)newlocs.get("maven") : (InputLocation)oldlocs.get("maven"));
            return new Prerequisites(this.maven != null ? this.maven : (this.base != null ? this.base.maven : null), locations);
        }
    }
}

