/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.ImmutableCollections;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class MailingList
implements Serializable,
InputLocationTracker {
    final String name;
    final String subscribe;
    final String unsubscribe;
    final String post;
    final String archive;
    final List<String> otherArchives;
    final Map<Object, InputLocation> locations;

    MailingList(String name, String subscribe, String unsubscribe, String post, String archive, Collection<String> otherArchives, Map<Object, InputLocation> locations) {
        this.name = name;
        this.subscribe = subscribe;
        this.unsubscribe = unsubscribe;
        this.post = post;
        this.archive = archive;
        this.otherArchives = ImmutableCollections.copy(otherArchives);
        this.locations = ImmutableCollections.copy(locations);
    }

    public String getName() {
        return this.name;
    }

    public String getSubscribe() {
        return this.subscribe;
    }

    public String getUnsubscribe() {
        return this.unsubscribe;
    }

    public String getPost() {
        return this.post;
    }

    public String getArchive() {
        return this.archive;
    }

    @Nonnull
    public List<String> getOtherArchives() {
        return this.otherArchives;
    }

    @Override
    public InputLocation getLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    @Nonnull
    public Builder with() {
        return MailingList.newBuilder(this);
    }

    @Nonnull
    public MailingList withName(String name) {
        return MailingList.newBuilder(this, true).name(name).build();
    }

    @Nonnull
    public MailingList withSubscribe(String subscribe) {
        return MailingList.newBuilder(this, true).subscribe(subscribe).build();
    }

    @Nonnull
    public MailingList withUnsubscribe(String unsubscribe) {
        return MailingList.newBuilder(this, true).unsubscribe(unsubscribe).build();
    }

    @Nonnull
    public MailingList withPost(String post) {
        return MailingList.newBuilder(this, true).post(post).build();
    }

    @Nonnull
    public MailingList withArchive(String archive) {
        return MailingList.newBuilder(this, true).archive(archive).build();
    }

    @Nonnull
    public MailingList withOtherArchives(Collection<String> otherArchives) {
        return MailingList.newBuilder(this, true).otherArchives(otherArchives).build();
    }

    @Nonnull
    public static MailingList newInstance() {
        return MailingList.newInstance(true);
    }

    @Nonnull
    public static MailingList newInstance(boolean withDefaults) {
        return MailingList.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return MailingList.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(MailingList from) {
        return MailingList.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(MailingList from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    public String toString() {
        return "MailingList {name=" + this.getName() + ", archive=" + this.getArchive() + "}";
    }

    @NotThreadSafe
    public static class Builder {
        MailingList base;
        String name;
        String subscribe;
        String unsubscribe;
        String post;
        String archive;
        Collection<String> otherArchives;
        Map<Object, InputLocation> locations;

        Builder(boolean withDefaults) {
            if (withDefaults) {
                // empty if block
            }
        }

        Builder(MailingList base, boolean forceCopy) {
            if (forceCopy) {
                this.name = base.name;
                this.subscribe = base.subscribe;
                this.unsubscribe = base.unsubscribe;
                this.post = base.post;
                this.archive = base.archive;
                this.otherArchives = base.otherArchives;
                this.locations = base.locations;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Nonnull
        public Builder subscribe(String subscribe) {
            this.subscribe = subscribe;
            return this;
        }

        @Nonnull
        public Builder unsubscribe(String unsubscribe) {
            this.unsubscribe = unsubscribe;
            return this;
        }

        @Nonnull
        public Builder post(String post) {
            this.post = post;
            return this;
        }

        @Nonnull
        public Builder archive(String archive) {
            this.archive = archive;
            return this;
        }

        @Nonnull
        public Builder otherArchives(Collection<String> otherArchives) {
            this.otherArchives = otherArchives;
            return this;
        }

        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<Object, InputLocation>(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public MailingList build() {
            if (!(this.base == null || this.name != null && this.name != this.base.name || this.subscribe != null && this.subscribe != this.base.subscribe || this.unsubscribe != null && this.unsubscribe != this.base.unsubscribe || this.post != null && this.post != this.base.post || this.archive != null && this.archive != this.base.archive || this.otherArchives != null && this.otherArchives != this.base.otherArchives)) {
                return this.base;
            }
            Map<Object, Object> newlocs = this.locations != null ? this.locations : Collections.emptyMap();
            Map oldlocs = this.base != null && this.base.locations != null ? this.base.locations : Collections.emptyMap();
            HashMap<Object, InputLocation> locations = new HashMap<Object, InputLocation>();
            locations.put("", newlocs.containsKey("") ? (InputLocation)newlocs.get("") : (InputLocation)oldlocs.get(""));
            locations.put("name", newlocs.containsKey("name") ? (InputLocation)newlocs.get("name") : (InputLocation)oldlocs.get("name"));
            locations.put("subscribe", newlocs.containsKey("subscribe") ? (InputLocation)newlocs.get("subscribe") : (InputLocation)oldlocs.get("subscribe"));
            locations.put("unsubscribe", newlocs.containsKey("unsubscribe") ? (InputLocation)newlocs.get("unsubscribe") : (InputLocation)oldlocs.get("unsubscribe"));
            locations.put("post", newlocs.containsKey("post") ? (InputLocation)newlocs.get("post") : (InputLocation)oldlocs.get("post"));
            locations.put("archive", newlocs.containsKey("archive") ? (InputLocation)newlocs.get("archive") : (InputLocation)oldlocs.get("archive"));
            locations.put("otherArchives", newlocs.containsKey("otherArchives") ? (InputLocation)newlocs.get("otherArchives") : (InputLocation)oldlocs.get("otherArchives"));
            return new MailingList(this.name != null ? this.name : (this.base != null ? this.base.name : null), this.subscribe != null ? this.subscribe : (this.base != null ? this.base.subscribe : null), this.unsubscribe != null ? this.unsubscribe : (this.base != null ? this.base.unsubscribe : null), this.post != null ? this.post : (this.base != null ? this.base.post : null), this.archive != null ? this.archive : (this.base != null ? this.base.archive : null), this.otherArchives != null ? this.otherArchives : (this.base != null ? this.base.otherArchives : null), locations);
        }
    }
}

