/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.maven.internal.impl;

import java.nio.file.Path;

import org.apache.maven.api.DownloadedArtifact;
import org.apache.maven.api.annotations.Nonnull;

/**
 * A wrapper class around a maven resolver artifact.
 */
public class DefaultDownloadedArtifact extends DefaultArtifact implements DownloadedArtifact {

    public DefaultDownloadedArtifact(
            @Nonnull InternalSession session, @Nonnull org.eclipse.aether.artifact.Artifact artifact) {
        super(session, artifact);
    }

    @Override
    public Path getPath() {
        return artifact.getPath();
    }
}
