/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl.model;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.api.model.Model;
import org.apache.maven.api.services.BuilderProblem;
import org.apache.maven.api.services.ModelBuilderException;
import org.apache.maven.api.services.ModelBuilderRequest;
import org.apache.maven.api.services.ModelProblemCollector;
import org.apache.maven.api.services.ModelSource;
import org.apache.maven.api.services.ModelTransformerContext;
import org.apache.maven.api.services.ModelTransformerContextBuilder;
import org.apache.maven.internal.impl.model.DefaultModelBuilder;
import org.apache.maven.internal.impl.model.DefaultModelProblem;
import org.apache.maven.internal.impl.model.DefaultModelProblemCollector;
import org.apache.maven.internal.impl.model.DefaultModelTransformerContext;
import org.apache.maven.internal.impl.model.Graph;

class DefaultModelTransformerContextBuilder
implements ModelTransformerContextBuilder {
    private final Graph dag = new Graph();
    private final DefaultModelBuilder defaultModelBuilder;
    private final DefaultModelTransformerContext context;
    private final Map<String, Set<ModelSource>> mappedSources = new ConcurrentHashMap<String, Set<ModelSource>>(64);
    private volatile boolean fullReactorLoaded;

    DefaultModelTransformerContextBuilder(DefaultModelBuilder defaultModelBuilder) {
        this.defaultModelBuilder = defaultModelBuilder;
        this.context = new DefaultModelTransformerContext(defaultModelBuilder.getModelProcessor());
    }

    public ModelTransformerContext initialize(final ModelBuilderRequest request, ModelProblemCollector collector) {
        final DefaultModelProblemCollector problems = (DefaultModelProblemCollector)collector;
        return new ModelTransformerContext(){

            public Path locate(Path path) {
                return DefaultModelTransformerContextBuilder.this.context.locate(path);
            }

            public String getUserProperty(String key) {
                return DefaultModelTransformerContextBuilder.this.context.userProperties.computeIfAbsent(key, k -> (String)request.getUserProperties().get(key));
            }

            public Model getRawModel(Path from, String gId, String aId) {
                Model model = this.findRawModel(from, gId, aId);
                if (model != null) {
                    DefaultModelTransformerContextBuilder.this.context.modelByGA.put(new DefaultModelTransformerContext.GAKey(gId, aId), new DefaultModelTransformerContext.Holder(model));
                    DefaultModelTransformerContextBuilder.this.context.modelByPath.put(model.getPomFile(), new DefaultModelTransformerContext.Holder(model));
                }
                return model;
            }

            public Model getRawModel(Path from, Path path) {
                Model model = this.findRawModel(from, path);
                if (model != null) {
                    String groupId = DefaultModelBuilder.getGroupId(model);
                    DefaultModelTransformerContextBuilder.this.context.modelByGA.put(new DefaultModelTransformerContext.GAKey(groupId, model.getArtifactId()), new DefaultModelTransformerContext.Holder(model));
                    DefaultModelTransformerContextBuilder.this.context.modelByPath.put(path, new DefaultModelTransformerContext.Holder(model));
                }
                return model;
            }

            private Model findRawModel(Path from, String groupId, String artifactId) {
                ModelSource source = DefaultModelTransformerContextBuilder.this.getSource(groupId, artifactId);
                if (source == null) {
                    this.loadFullReactor();
                    source = DefaultModelTransformerContextBuilder.this.getSource(groupId, artifactId);
                }
                if (source != null) {
                    if (!DefaultModelTransformerContextBuilder.this.addEdge(from, source.getPath(), problems)) {
                        return null;
                    }
                    try {
                        ModelBuilderRequest gaBuildingRequest = ModelBuilderRequest.build((ModelBuilderRequest)request, (ModelSource)source);
                        return DefaultModelTransformerContextBuilder.this.defaultModelBuilder.readRawModel(gaBuildingRequest, problems);
                    }
                    catch (ModelBuilderException modelBuilderException) {
                        // empty catch block
                    }
                }
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void loadFullReactor() {
                if (!DefaultModelTransformerContextBuilder.this.fullReactorLoaded) {
                    DefaultModelTransformerContextBuilder defaultModelTransformerContextBuilder = DefaultModelTransformerContextBuilder.this;
                    synchronized (defaultModelTransformerContextBuilder) {
                        if (!DefaultModelTransformerContextBuilder.this.fullReactorLoaded) {
                            this.doLoadFullReactor();
                            DefaultModelTransformerContextBuilder.this.fullReactorLoaded = true;
                        }
                    }
                }
            }

            private void doLoadFullReactor() {
                Path rootDirectory;
                try {
                    rootDirectory = request.getSession().getRootDirectory();
                }
                catch (IllegalStateException e) {
                    return;
                }
                ArrayList<Path> toLoad = new ArrayList<Path>();
                Path root = DefaultModelTransformerContextBuilder.this.defaultModelBuilder.getModelProcessor().locateExistingPom(rootDirectory);
                toLoad.add(root);
                while (!toLoad.isEmpty()) {
                    Path pom = (Path)toLoad.remove(0);
                    try {
                        ModelBuilderRequest gaBuildingRequest = ModelBuilderRequest.build((ModelBuilderRequest)request, (ModelSource)ModelSource.fromPath((Path)pom));
                        Model rawModel = DefaultModelTransformerContextBuilder.this.defaultModelBuilder.readFileModel(gaBuildingRequest, problems);
                        for (String module : rawModel.getModules()) {
                            Path moduleFile = DefaultModelTransformerContextBuilder.this.defaultModelBuilder.getModelProcessor().locateExistingPom(pom.getParent().resolve(module));
                            if (moduleFile == null) continue;
                            toLoad.add(moduleFile);
                        }
                    }
                    catch (ModelBuilderException modelBuilderException) {
                    }
                }
            }

            private Model findRawModel(Path from, Path p) {
                if (!Files.isRegularFile(p, new LinkOption[0])) {
                    throw new IllegalArgumentException("Not a regular file: " + String.valueOf(p));
                }
                if (!DefaultModelTransformerContextBuilder.this.addEdge(from, p, problems)) {
                    return null;
                }
                ModelBuilderRequest req = ModelBuilderRequest.build((ModelBuilderRequest)request, (ModelSource)ModelSource.fromPath((Path)p));
                try {
                    return DefaultModelTransformerContextBuilder.this.defaultModelBuilder.readRawModel(req, problems);
                }
                catch (ModelBuilderException modelBuilderException) {
                    return null;
                }
            }
        };
    }

    private boolean addEdge(Path from, Path p, DefaultModelProblemCollector problems) {
        try {
            this.dag.addEdge(from.toString(), p.toString());
            return true;
        }
        catch (Graph.CycleDetectedException e) {
            problems.add(new DefaultModelProblem("Cycle detected between models at " + String.valueOf(from) + " and " + String.valueOf(p), BuilderProblem.Severity.FATAL, null, null, 0, 0, null, e));
            return false;
        }
    }

    public ModelTransformerContext build() {
        return this.context;
    }

    public ModelSource getSource(String groupId, String artifactId) {
        Set<ModelSource> sources = this.mappedSources.get(groupId + ":" + artifactId);
        if (sources == null) {
            return null;
        }
        return sources.stream().reduce((a, b) -> {
            throw new IllegalStateException(String.format("No unique Source for %s:%s: %s and %s", groupId, artifactId, a.getLocation(), b.getLocation()));
        }).orElse(null);
    }

    public void putSource(String groupId, String artifactId, ModelSource source) {
        this.mappedSources.computeIfAbsent(groupId + ":" + artifactId, k -> new HashSet()).add(source);
    }
}

