/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.module.ModuleDescriptor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import org.apache.maven.api.JavaPathType;
import org.apache.maven.api.annotations.Nonnull;

class PathModularization {
    public static final PathModularization NONE = new PathModularization();
    private static final String MODULE_INFO = "module-info.class";
    private static final Attributes.Name AUTO_MODULE_NAME = new Attributes.Name("Automatic-Module-Name");
    private final String filename;
    private final Map<Path, String> descriptors;
    private final boolean isModuleHierarchy;

    private PathModularization() {
        this.filename = "(none)";
        this.descriptors = Collections.emptyMap();
        this.isModuleHierarchy = false;
    }

    PathModularization(Path path, boolean resolve) throws IOException {
        this.filename = path.getFileName().toString();
        if (Files.isDirectory(path, new LinkOption[0])) {
            Path file = path.resolve(MODULE_INFO);
            if (Files.isRegularFile(file, new LinkOption[0])) {
                String name = null;
                if (resolve) {
                    try (InputStream in = Files.newInputStream(file, new OpenOption[0]);){
                        name = PathModularization.getModuleName(in);
                    }
                }
                this.descriptors = Collections.singletonMap(file, name);
                this.isModuleHierarchy = false;
                return;
            }
            if (Files.isDirectory(file, new LinkOption[0])) {
                HashMap names = new HashMap();
                try (Stream<Path> subdirs = Files.list(file);){
                    subdirs.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(subdir -> {
                        Path mf = subdir.resolve(MODULE_INFO);
                        if (Files.isRegularFile(mf, new LinkOption[0])) {
                            String name = null;
                            if (resolve) {
                                try (InputStream in = Files.newInputStream(mf, new OpenOption[0]);){
                                    name = PathModularization.getModuleName(in);
                                }
                                catch (IOException e) {
                                    throw new UncheckedIOException(e);
                                }
                            }
                            names.put(mf, name);
                        }
                    });
                }
                catch (UncheckedIOException e) {
                    throw e.getCause();
                }
                if (!names.isEmpty()) {
                    this.descriptors = Collections.unmodifiableMap(names);
                    this.isModuleHierarchy = true;
                    return;
                }
            }
        } else if (Files.isRegularFile(path, new LinkOption[0])) {
            try (JarFile jar = new JarFile(path.toFile());){
                Object name;
                ZipEntry entry = jar.getEntry(MODULE_INFO);
                if (entry != null) {
                    String name2 = null;
                    if (resolve) {
                        try (InputStream in = jar.getInputStream(entry);){
                            name2 = PathModularization.getModuleName(in);
                        }
                    }
                    this.descriptors = Collections.singletonMap(path, name2);
                    this.isModuleHierarchy = false;
                    return;
                }
                Manifest mf = jar.getManifest();
                if (mf != null && (name = mf.getMainAttributes().get(AUTO_MODULE_NAME)) instanceof String) {
                    this.descriptors = Collections.singletonMap(path, (String)name);
                    this.isModuleHierarchy = false;
                    return;
                }
            }
        }
        this.descriptors = Collections.emptyMap();
        this.isModuleHierarchy = false;
    }

    @Nonnull
    private static String getModuleName(InputStream in) throws IOException {
        return ModuleDescriptor.read(in).name();
    }

    public JavaPathType getPathType() {
        return this.descriptors.isEmpty() ? JavaPathType.CLASSES : JavaPathType.MODULES;
    }

    public void addIfFilenameBasedAutomodules(Collection<String> automodulesDetected) {
        if (this.descriptors.isEmpty()) {
            automodulesDetected.add(this.filename);
        }
    }

    public boolean isModuleHierarchy() {
        return this.isModuleHierarchy;
    }

    @Nonnull
    public Map<Path, String> getModuleNames() {
        return this.descriptors;
    }

    public boolean containsModule(String name) {
        return this.descriptors.containsValue(name);
    }

    public String toString() {
        return this.getClass().getCanonicalName() + "[" + this.filename + "]";
    }
}

