/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import com.google.common.primitives.Doubles;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.mahout.math.AbstractVector;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.OrderedIntDoubleMapping;
import org.apache.mahout.math.SparseMatrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.function.Functions;

public class SequentialAccessSparseVector
extends AbstractVector {
    private OrderedIntDoubleMapping values;

    public SequentialAccessSparseVector() {
        super(0);
    }

    public SequentialAccessSparseVector(int cardinality) {
        this(cardinality, Math.min(100, cardinality / 1000 < 10 ? 10 : cardinality / 1000));
    }

    public SequentialAccessSparseVector(int cardinality, int size) {
        super(cardinality);
        this.values = new OrderedIntDoubleMapping(size);
    }

    public SequentialAccessSparseVector(Vector other) {
        this(other.size(), other.getNumNondefaultElements());
        if (other.isSequentialAccess()) {
            for (Vector.Element e : other.nonZeroes()) {
                this.set(e.index(), e.get());
            }
        } else {
            this.copySortedRandomAccessSparseVector(other);
        }
    }

    private int copySortedRandomAccessSparseVector(Vector other) {
        int elementCount = other.getNumNondefaultElements();
        Object[] sortableElements = new OrderedElement[elementCount];
        int s = 0;
        for (Vector.Element e : other.nonZeroes()) {
            sortableElements[s++] = new OrderedElement(e.index(), e.get());
        }
        Arrays.sort(sortableElements);
        for (int i = 0; i < sortableElements.length; ++i) {
            this.values.setIndexAt(i, ((OrderedElement)sortableElements[i]).index);
            this.values.setValueAt(i, ((OrderedElement)sortableElements[i]).value);
        }
        this.values = new OrderedIntDoubleMapping(this.values.getIndices(), this.values.getValues(), elementCount);
        return elementCount;
    }

    public SequentialAccessSparseVector(SequentialAccessSparseVector other, boolean shallowCopy) {
        super(other.size());
        this.values = shallowCopy ? other.values : other.values.clone();
    }

    public SequentialAccessSparseVector(SequentialAccessSparseVector other) {
        this(other.size(), other.getNumNondefaultElements());
        this.values = other.values.clone();
    }

    private SequentialAccessSparseVector(int cardinality, OrderedIntDoubleMapping values) {
        super(cardinality);
        this.values = values;
    }

    @Override
    protected Matrix matrixLike(int rows, int columns) {
        return new SparseMatrix(rows, columns);
    }

    @Override
    public SequentialAccessSparseVector clone() {
        return new SequentialAccessSparseVector(this.size(), this.values.clone());
    }

    @Override
    public void mergeUpdates(OrderedIntDoubleMapping updates) {
        this.values.merge(updates);
    }

    @Override
    public String toString() {
        return this.sparseVectorToString();
    }

    @Override
    public boolean isDense() {
        return false;
    }

    @Override
    public boolean isSequentialAccess() {
        return true;
    }

    @Override
    public double getQuick(int index) {
        return this.values.get(index);
    }

    @Override
    public void setQuick(int index, double value) {
        this.invalidateCachedLength();
        this.values.set(index, value);
    }

    @Override
    public void incrementQuick(int index, double increment) {
        this.invalidateCachedLength();
        this.values.increment(index, increment);
    }

    @Override
    public SequentialAccessSparseVector like() {
        return new SequentialAccessSparseVector(this.size(), this.values.getNumMappings());
    }

    @Override
    public int getNumNondefaultElements() {
        return this.values.getNumMappings();
    }

    @Override
    public int getNumNonZeroElements() {
        double[] elementValues = this.values.getValues();
        int numMappedElements = this.values.getNumMappings();
        int numNonZeros = 0;
        for (int index = 0; index < numMappedElements; ++index) {
            if (elementValues[index] == 0.0) continue;
            ++numNonZeros;
        }
        return numNonZeros;
    }

    @Override
    public double getLookupCost() {
        return Math.max(1L, Math.round(Functions.LOG2.apply(this.getNumNondefaultElements())));
    }

    @Override
    public double getIteratorAdvanceCost() {
        return 1.0;
    }

    @Override
    public boolean isAddConstantTime() {
        return false;
    }

    @Override
    public Iterator<Vector.Element> iterateNonZero() {
        return new NonDefaultIterator();
    }

    @Override
    public Iterator<Vector.Element> iterator() {
        return new AllIterator();
    }

    private static final class OrderedElement
    implements Comparable<OrderedElement> {
        private final int index;
        private final double value;

        OrderedElement(int index, double value) {
            this.index = index;
            this.value = value;
        }

        @Override
        public int compareTo(OrderedElement that) {
            return this.index - that.index;
        }

        public int hashCode() {
            return this.index ^ Doubles.hashCode((double)this.value);
        }

        public boolean equals(Object o) {
            if (!(o instanceof OrderedElement)) {
                return false;
            }
            OrderedElement other = (OrderedElement)o;
            return this.index == other.index && this.value == other.value;
        }
    }

    private final class AllElement
    implements Vector.Element {
        private int index = -1;
        private int nextOffset;

        private AllElement() {
        }

        void advanceIndex() {
            ++this.index;
            if (this.nextOffset < SequentialAccessSparseVector.this.values.getNumMappings() && this.index > SequentialAccessSparseVector.this.values.getIndices()[this.nextOffset]) {
                ++this.nextOffset;
            }
        }

        int getNextIndex() {
            return this.index + 1;
        }

        @Override
        public double get() {
            if (this.nextOffset < SequentialAccessSparseVector.this.values.getNumMappings() && this.index == SequentialAccessSparseVector.this.values.getIndices()[this.nextOffset]) {
                return SequentialAccessSparseVector.this.values.getValues()[this.nextOffset];
            }
            return 0.0;
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public void set(double value) {
            SequentialAccessSparseVector.this.invalidateCachedLength();
            if (this.nextOffset < SequentialAccessSparseVector.this.values.getNumMappings() && this.index == SequentialAccessSparseVector.this.values.indexAt(this.nextOffset)) {
                SequentialAccessSparseVector.this.values.setValueAt(this.nextOffset, value);
            } else {
                SequentialAccessSparseVector.this.values.set(this.index, value);
            }
        }
    }

    private final class NonDefaultElement
    implements Vector.Element {
        private int offset = -1;

        private NonDefaultElement() {
        }

        void advanceOffset() {
            ++this.offset;
        }

        int getNextOffset() {
            return this.offset + 1;
        }

        @Override
        public double get() {
            return SequentialAccessSparseVector.this.values.getValues()[this.offset];
        }

        @Override
        public int index() {
            return SequentialAccessSparseVector.this.values.getIndices()[this.offset];
        }

        @Override
        public void set(double value) {
            SequentialAccessSparseVector.this.invalidateCachedLength();
            SequentialAccessSparseVector.this.values.setValueAt(this.offset, value);
        }
    }

    private final class AllIterator
    implements Iterator<Vector.Element> {
        private final AllElement element;

        private AllIterator() {
            this.element = new AllElement();
        }

        @Override
        public boolean hasNext() {
            return this.element.getNextIndex() < SequentialAccessSparseVector.this.size();
        }

        @Override
        public Vector.Element next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.element.advanceIndex();
            return this.element;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private final class NonDefaultIterator
    implements Iterator<Vector.Element> {
        private final NonDefaultElement element;

        private NonDefaultIterator() {
            this.element = new NonDefaultElement();
        }

        @Override
        public boolean hasNext() {
            return this.element.getNextOffset() < SequentialAccessSparseVector.this.values.getNumMappings();
        }

        @Override
        public Vector.Element next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.element.advanceOffset();
            return this.element;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

