/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.text;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.builder.ArgumentBuilder;
import org.apache.commons.cli2.builder.DefaultOptionBuilder;
import org.apache.commons.cli2.builder.GroupBuilder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.common.AbstractJob;
import org.apache.mahout.common.commandline.DefaultOptionCreator;
import org.apache.mahout.utils.email.MailOptions;
import org.apache.mahout.utils.email.MailProcessor;
import org.apache.mahout.utils.io.ChunkedWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SequenceFilesFromMailArchives
extends AbstractJob {
    private static final Logger log = LoggerFactory.getLogger(SequenceFilesFromMailArchives.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSequenceFiles(MailOptions options) throws IOException {
        ChunkedWriter writer = new ChunkedWriter(this.getConf(), options.getChunkSize(), new Path(options.getOutputDir()));
        MailProcessor processor = new MailProcessor(options, options.getPrefix(), writer);
        try {
            if (options.getInput().isDirectory()) {
                PrefixAdditionFilter filter = new PrefixAdditionFilter(processor, writer);
                options.getInput().listFiles(filter);
                log.info("Parsed {} messages from {}", (Object)filter.getMessageCount(), (Object)options.getInput().getAbsolutePath());
            } else {
                long start = System.currentTimeMillis();
                long cnt = processor.parseMboxLineByLine(options.getInput());
                long finish = System.currentTimeMillis();
                log.info("Parsed {} messages from {} in time: {}", new Object[]{cnt, options.getInput().getAbsolutePath(), finish - start});
            }
        }
        finally {
            Closeables.closeQuietly((Closeable)writer);
        }
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Configuration)new Configuration(), (Tool)new SequenceFilesFromMailArchives(), (String[])args);
    }

    public int run(String[] args) throws Exception {
        DefaultOptionBuilder obuilder = new DefaultOptionBuilder();
        ArgumentBuilder abuilder = new ArgumentBuilder();
        GroupBuilder gbuilder = new GroupBuilder();
        this.addInputOption();
        this.addOutputOption();
        this.addOption((Option)obuilder.withLongName("chunkSize").withArgument(abuilder.withName("chunkSize").withMinimum(1).withMaximum(1).create()).withDescription("The chunkSize in MegaBytes. Defaults to 64").withShortName("chunk").create());
        this.addOption((Option)obuilder.withLongName("keyPrefix").withArgument(abuilder.withName("keyPrefix").withMinimum(1).withMaximum(1).create()).withDescription("The prefix to be prepended to the key").withShortName("prefix").create());
        this.addOption((Option)obuilder.withLongName("charset").withRequired(true).withArgument(abuilder.withName("charset").withMinimum(1).withMaximum(1).create()).withDescription("The name of the character encoding of the input files").withShortName("c").create());
        this.addOption((Option)obuilder.withLongName("subject").withRequired(false).withDescription("Include the Mail subject as part of the text.  Default is false").withShortName("s").create());
        this.addOption((Option)obuilder.withLongName("to").withRequired(false).withDescription("Include the to field in the text.  Default is false").withShortName("to").create());
        this.addOption((Option)obuilder.withLongName("from").withRequired(false).withDescription("Include the from field in the text.  Default is false").withShortName("from").create());
        this.addOption((Option)obuilder.withLongName("references").withRequired(false).withDescription("Include the references field in the text.  Default is false").withShortName("refs").create());
        this.addOption((Option)obuilder.withLongName("body").withRequired(false).withDescription("Include the body in the output.  Default is false").withShortName("b").create());
        this.addOption((Option)obuilder.withLongName("stripQuoted").withRequired(false).withDescription("Strip (remove) quoted email text in the body.  Default is false").withShortName("q").create());
        this.addOption((Option)obuilder.withLongName("quotedRegex").withRequired(false).withArgument(abuilder.withName("regex").withMinimum(1).withMaximum(1).create()).withDescription("Specify the regex that identifies quoted text.  Default is to look for > or | at the beginning of the line.").withShortName("q").create());
        this.addOption((Option)obuilder.withLongName("separator").withRequired(false).withArgument(abuilder.withName("separator").withMinimum(1).withMaximum(1).create()).withDescription("The separator to use between metadata items (to, from, etc.).  Default is \\n").withShortName("sep").create());
        this.addOption((Option)obuilder.withLongName("bodySeparator").withRequired(false).withArgument(abuilder.withName("bodySeparator").withMinimum(1).withMaximum(1).create()).withDescription("The separator to use between lines in the body.  Default is \\n.  Useful to change if you wish to have the message be on one line").withShortName("bodySep").create());
        this.addOption(DefaultOptionCreator.helpOption());
        Map parsedArgs = this.parseArguments(args);
        if (parsedArgs == null) {
            return -1;
        }
        File input = this.getInputFile();
        String outputDir = this.getOutputPath().toString();
        int chunkSize = 64;
        if (this.hasOption("chunkSize")) {
            chunkSize = Integer.parseInt(this.getOption("chunkSize"));
        }
        String prefix = "";
        if (this.hasOption("keyPrefix")) {
            prefix = this.getOption("keyPrefix");
        }
        Charset charset = Charset.forName(this.getOption("charset"));
        MailOptions options = new MailOptions();
        options.setInput(input);
        options.setOutputDir(outputDir);
        options.setPrefix(prefix);
        options.setChunkSize(chunkSize);
        options.setCharset(charset);
        ArrayList<Pattern> patterns = new ArrayList<Pattern>(5);
        HashMap<String, Integer> patternOrder = new HashMap<String, Integer>();
        int order = 0;
        if (this.hasOption("from")) {
            patterns.add(MailProcessor.FROM_PREFIX);
            patternOrder.put("FROM", order++);
        }
        if (this.hasOption("to")) {
            patterns.add(MailProcessor.TO_PREFIX);
            patternOrder.put("TO", order++);
        }
        if (this.hasOption("references")) {
            patterns.add(MailProcessor.REFS_PREFIX);
            patternOrder.put("REFS", order++);
        }
        if (this.hasOption("subject")) {
            patterns.add(MailProcessor.SUBJECT_PREFIX);
            patternOrder.put("SUBJECT", order++);
        }
        options.setStripQuotedText(this.hasOption("stripQuoted"));
        options.setPatternsToMatch(patterns.toArray(new Pattern[patterns.size()]));
        options.setPatternOrder(patternOrder);
        options.setIncludeBody(this.hasOption("body"));
        options.setSeparator("\n");
        if (this.hasOption("separator")) {
            options.setSeparator(this.getOption("separator"));
        }
        if (this.hasOption("bodySeparator")) {
            options.setBodySeparator(this.getOption("bodySeparator"));
        }
        if (this.hasOption("quotedRegex")) {
            options.setQuotedTextPattern(Pattern.compile(this.getOption("quotedRegex")));
        }
        long start = System.currentTimeMillis();
        this.createSequenceFiles(options);
        long finish = System.currentTimeMillis();
        log.info("Conversion took {}ms", (Object)(finish - start));
        return 0;
    }

    public class PrefixAdditionFilter
    implements FileFilter {
        private final MailProcessor processor;
        private final ChunkedWriter writer;
        private long messageCount;

        public PrefixAdditionFilter(MailProcessor processor, ChunkedWriter writer) {
            this.processor = processor;
            this.writer = writer;
            this.messageCount = 0L;
        }

        public long getMessageCount() {
            return this.messageCount;
        }

        @Override
        public boolean accept(File current) {
            if (current.isDirectory()) {
                log.info("At {}", (Object)current.getAbsolutePath());
                PrefixAdditionFilter nested = new PrefixAdditionFilter(new MailProcessor(this.processor.getOptions(), this.processor.getPrefix() + File.separator + current.getName(), this.writer), this.writer);
                current.listFiles(nested);
                long dirCount = nested.getMessageCount();
                log.info("Parsed {} messages from directory {}", (Object)dirCount, (Object)current.getAbsolutePath());
                this.messageCount += dirCount;
            } else {
                try {
                    this.messageCount += this.processor.parseMboxLineByLine(current);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Error processing " + current, e);
                }
            }
            return false;
        }
    }
}

