/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.recommender.slopeone.jdbc;

import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.Callable;
import javax.sql.DataSource;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.apache.mahout.cf.taste.impl.common.FixedRunningAverage;
import org.apache.mahout.cf.taste.impl.common.FixedRunningAverageAndStdDev;
import org.apache.mahout.cf.taste.impl.common.RefreshHelper;
import org.apache.mahout.cf.taste.impl.common.RunningAverage;
import org.apache.mahout.cf.taste.impl.common.jdbc.AbstractJDBCComponent;
import org.apache.mahout.cf.taste.model.JDBCDataModel;
import org.apache.mahout.cf.taste.model.PreferenceArray;
import org.apache.mahout.cf.taste.recommender.slopeone.DiffStorage;
import org.apache.mahout.common.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJDBCDiffStorage
extends AbstractJDBCComponent
implements DiffStorage {
    private static final Logger log = LoggerFactory.getLogger(AbstractJDBCDiffStorage.class);
    public static final String DEFAULT_DIFF_TABLE = "taste_slopeone_diffs";
    public static final String DEFAULT_ITEM_A_COLUMN = "item_id_a";
    public static final String DEFAULT_ITEM_B_COLUMN = "item_id_b";
    public static final String DEFAULT_COUNT_COLUMN = "count";
    public static final String DEFAULT_AVERAGE_DIFF_COLUMN = "average_diff";
    public static final String DEFAULT_STDEV_COLUMN = "standard_deviation";
    private final JDBCDataModel dataModel;
    private final DataSource dataSource;
    private final String getDiffSQL;
    private final String getDiffsSQL;
    private final String getAverageItemPrefSQL;
    private final String getDiffsAffectedByUserSQL;
    private final String[] updateDiffSQLs;
    private final String updateOneDiffSQL;
    private final String addDiffSQL;
    private final String removeDiffSQL;
    private final String getRecommendableItemsSQL;
    private final String deleteDiffsSQL;
    private final String createDiffsSQL;
    private final String diffsExistSQL;
    private final int minDiffCount;
    private final RefreshHelper refreshHelper;

    protected AbstractJDBCDiffStorage(JDBCDataModel dataModel, String getDiffSQL, String getDiffsSQL, String getAverageItemPrefSQL, String getDiffsAffectedByUserSQL, String[] updateDiffSQLs, String updateOneDiffSQL, String addDiffSQL, String removeDiffSQL, String getRecommendableItemsSQL, String deleteDiffsSQL, String createDiffsSQL, String diffsExistSQL, int minDiffCount) throws TasteException {
        AbstractJDBCComponent.checkNotNullAndLog((String)"dataModel", (Object)dataModel);
        AbstractJDBCComponent.checkNotNullAndLog((String)"getDiffSQL", (Object)getDiffSQL);
        AbstractJDBCComponent.checkNotNullAndLog((String)"getDiffsSQL", (Object)getDiffsSQL);
        AbstractJDBCComponent.checkNotNullAndLog((String)"getAverageItemPrefSQL", (Object)getAverageItemPrefSQL);
        AbstractJDBCComponent.checkNotNullAndLog((String)"getDiffsAffectedByUserSQL", (Object)getDiffsAffectedByUserSQL);
        AbstractJDBCComponent.checkNotNullAndLog((String)"updateDiffSQLs", (Object[])updateDiffSQLs);
        AbstractJDBCComponent.checkNotNullAndLog((String)"updateOneDiffSQL", (Object)updateOneDiffSQL);
        AbstractJDBCComponent.checkNotNullAndLog((String)"addDiffSQL", (Object)addDiffSQL);
        AbstractJDBCComponent.checkNotNullAndLog((String)"removeDiffSQL", (Object)removeDiffSQL);
        AbstractJDBCComponent.checkNotNullAndLog((String)"getRecommendableItemsSQL", (Object)getRecommendableItemsSQL);
        AbstractJDBCComponent.checkNotNullAndLog((String)"deleteDiffsSQL", (Object)deleteDiffsSQL);
        AbstractJDBCComponent.checkNotNullAndLog((String)"createDiffsSQL", (Object)createDiffsSQL);
        AbstractJDBCComponent.checkNotNullAndLog((String)"diffsExistSQL", (Object)diffsExistSQL);
        Preconditions.checkArgument((minDiffCount >= 0 ? 1 : 0) != 0, (Object)"minDiffCount is not positive");
        this.dataModel = dataModel;
        this.dataSource = dataModel.getDataSource();
        this.getDiffSQL = getDiffSQL;
        this.getDiffsSQL = getDiffsSQL;
        this.getAverageItemPrefSQL = getAverageItemPrefSQL;
        this.getDiffsAffectedByUserSQL = getDiffsAffectedByUserSQL;
        this.updateDiffSQLs = updateDiffSQLs;
        this.updateOneDiffSQL = updateOneDiffSQL;
        this.addDiffSQL = addDiffSQL;
        this.removeDiffSQL = removeDiffSQL;
        this.getRecommendableItemsSQL = getRecommendableItemsSQL;
        this.deleteDiffsSQL = deleteDiffsSQL;
        this.createDiffsSQL = createDiffsSQL;
        this.diffsExistSQL = diffsExistSQL;
        this.minDiffCount = minDiffCount;
        this.refreshHelper = new RefreshHelper((Callable)new Callable<Object>(){

            @Override
            public Object call() throws TasteException {
                AbstractJDBCDiffStorage.this.buildAverageDiffs();
                return null;
            }
        });
        this.refreshHelper.addDependency((Refreshable)dataModel);
        if (this.isDiffsExist()) {
            log.info("Diffs already exist in database; using them instead of recomputing");
        } else {
            log.info("No diffs exist in database; recomputing...");
            this.buildAverageDiffs();
        }
    }

    public RunningAverage getDiff(long itemID1, long itemID2) throws TasteException {
        RunningAverage average2;
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block7: {
            boolean flipped;
            boolean bl = flipped = itemID1 > itemID2;
            if (flipped) {
                long temp = itemID1;
                itemID1 = itemID2;
                itemID2 = temp;
            }
            conn = null;
            stmt = null;
            rs = null;
            conn = this.dataSource.getConnection();
            stmt = conn.prepareStatement(this.getDiffSQL, 1003, 1007);
            stmt.setFetchDirection(1000);
            stmt.setFetchSize(this.getFetchSize());
            stmt.setLong(1, itemID1);
            stmt.setLong(2, itemID2);
            log.debug("Executing SQL query: {}", (Object)this.getDiffSQL);
            rs = stmt.executeQuery();
            if (!rs.next()) break block7;
            double average2 = rs.getDouble(2);
            if (flipped) {
                average2 = -average2;
            }
            FixedRunningAverageAndStdDev fixedRunningAverageAndStdDev = new FixedRunningAverageAndStdDev(average2, rs.getDouble(3), rs.getInt(1));
            IOUtils.quietClose((ResultSet)rs, (Statement)stmt, (Connection)conn);
            return fixedRunningAverageAndStdDev;
        }
        try {
            average2 = null;
        }
        catch (SQLException sqle) {
            try {
                log.warn("Exception while retrieving diff", (Throwable)sqle);
                throw new TasteException((Throwable)sqle);
            }
            catch (Throwable throwable) {
                IOUtils.quietClose(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        IOUtils.quietClose((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return average2;
    }

    public RunningAverage[] getDiffs(long userID, long itemID, PreferenceArray prefs) throws TasteException {
        int size = prefs.length();
        RunningAverage[] result = new RunningAverage[size];
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.dataSource.getConnection();
            stmt = conn.prepareStatement(this.getDiffsSQL, 1003, 1007);
            stmt.setFetchDirection(1000);
            stmt.setFetchSize(this.getFetchSize());
            stmt.setLong(1, itemID);
            stmt.setLong(2, userID);
            stmt.setLong(3, itemID);
            stmt.setLong(4, userID);
            log.debug("Executing SQL query: {}", (Object)this.getDiffsSQL);
            rs = stmt.executeQuery();
            int i = 0;
            while (rs.next()) {
                long nextResultItemID = rs.getLong(4);
                while (i < size && prefs.getItemID(i) != nextResultItemID) {
                    ++i;
                }
                if (i == size) break;
                result[i] = new FixedRunningAverageAndStdDev(rs.getDouble(2), rs.getDouble(3), rs.getInt(1));
                ++i;
            }
        }
        catch (SQLException sqle) {
            try {
                log.warn("Exception while retrieving diff", (Throwable)sqle);
                throw new TasteException((Throwable)sqle);
            }
            catch (Throwable throwable) {
                IOUtils.quietClose(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        IOUtils.quietClose((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return result;
    }

    public RunningAverage getAverageItemPref(long itemID) throws TasteException {
        RunningAverage count2;
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block5: {
            int count2;
            conn = null;
            stmt = null;
            rs = null;
            conn = this.dataSource.getConnection();
            stmt = conn.prepareStatement(this.getAverageItemPrefSQL, 1003, 1007);
            stmt.setFetchDirection(1000);
            stmt.setFetchSize(this.getFetchSize());
            stmt.setLong(1, itemID);
            log.debug("Executing SQL query: {}", (Object)this.getAverageItemPrefSQL);
            rs = stmt.executeQuery();
            if (!rs.next() || (count2 = rs.getInt(1)) <= 0) break block5;
            FixedRunningAverage fixedRunningAverage = new FixedRunningAverage(rs.getDouble(2), count2);
            IOUtils.quietClose((ResultSet)rs, (Statement)stmt, (Connection)conn);
            return fixedRunningAverage;
        }
        try {
            count2 = null;
        }
        catch (SQLException sqle) {
            try {
                log.warn("Exception while retrieving average item pref", (Throwable)sqle);
                throw new TasteException((Throwable)sqle);
            }
            catch (Throwable throwable) {
                IOUtils.quietClose(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        IOUtils.quietClose((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return count2;
    }

    public void addItemPref(long userID, long itemID, float prefValue) throws TasteException {
        PreferenceArray prefs = this.dataModel.getPreferencesFromUser(userID);
        FastIDSet unupdatedItemIDs = new FastIDSet();
        for (long anItemID : prefs.getIDs()) {
            unupdatedItemIDs.add(anItemID);
        }
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.dataSource.getConnection();
            stmt = conn.prepareStatement(this.getDiffsAffectedByUserSQL, 1003, 1007);
            stmt.setFetchDirection(1000);
            stmt.setFetchSize(this.getFetchSize());
            stmt.setLong(1, userID);
            log.debug("Executing SQL query: {}", (Object)this.getDiffsAffectedByUserSQL);
            rs = stmt.executeQuery();
            while (rs.next()) {
                long otherItemID;
                float prefDelta;
                int count = rs.getInt(1);
                float average = rs.getFloat(2);
                long itemIDA = rs.getLong(3);
                long itemIDB = rs.getLong(4);
                float currentOtherPrefValue = rs.getFloat(5);
                if (itemID == itemIDA) {
                    prefDelta = currentOtherPrefValue - prefValue;
                    otherItemID = itemIDB;
                } else {
                    prefDelta = prefValue - currentOtherPrefValue;
                    otherItemID = itemIDA;
                }
                float newAverage = (average * (float)count + prefDelta) / (float)(count + 1);
                this.updateOneDiff(conn, count + 1, newAverage, itemIDA, itemIDB);
                unupdatedItemIDs.remove(otherItemID);
            }
        }
        catch (SQLException sqle) {
            try {
                log.warn("Exception while adding item diff", (Throwable)sqle);
                throw new TasteException((Throwable)sqle);
            }
            catch (Throwable throwable) {
                IOUtils.quietClose(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        IOUtils.quietClose((ResultSet)rs, (Statement)stmt, (Connection)conn);
        try {
            conn = this.dataSource.getConnection();
            stmt = conn.prepareStatement(this.addDiffSQL);
            Iterator i$ = unupdatedItemIDs.iterator();
            while (i$.hasNext()) {
                long unupdatedItemID = (Long)i$.next();
                if (unupdatedItemID < itemID) {
                    stmt.setLong(1, unupdatedItemID);
                    stmt.setLong(2, itemID);
                    stmt.setFloat(3, prefValue);
                } else {
                    stmt.setLong(1, itemID);
                    stmt.setLong(2, unupdatedItemID);
                    stmt.setFloat(3, -prefValue);
                }
                log.debug("Executing SQL query: {}", (Object)this.getDiffsAffectedByUserSQL);
                stmt.executeUpdate();
            }
        }
        catch (SQLException sqle) {
            log.warn("Exception while adding item diff", (Throwable)sqle);
            throw new TasteException((Throwable)sqle);
        }
        finally {
            IOUtils.quietClose(null, (Statement)stmt, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOneDiff(Connection conn, int newCount, float newAverage, long itemIDA, long itemIDB) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(this.updateOneDiffSQL);
        try {
            stmt.setInt(1, newCount);
            stmt.setFloat(2, newAverage);
            stmt.setLong(3, itemIDA);
            stmt.setLong(4, itemIDB);
            log.debug("Executing SQL update: {}", (Object)this.updateOneDiffSQL);
            stmt.executeUpdate();
        }
        finally {
            IOUtils.quietClose((Statement)stmt);
        }
    }

    public void updateItemPref(long itemID, float prefDelta) throws TasteException {
        Connection conn = null;
        try {
            conn = this.dataSource.getConnection();
            AbstractJDBCDiffStorage.doPartialUpdate(this.updateDiffSQLs[0], itemID, prefDelta, conn);
            AbstractJDBCDiffStorage.doPartialUpdate(this.updateDiffSQLs[1], itemID, prefDelta, conn);
        }
        catch (SQLException sqle) {
            log.warn("Exception while updating item diff", (Throwable)sqle);
            throw new TasteException((Throwable)sqle);
        }
        finally {
            IOUtils.quietClose((Connection)conn);
        }
    }

    public void removeItemPref(long userID, long itemID, float prefValue) throws TasteException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.dataSource.getConnection();
            stmt = conn.prepareStatement(this.getDiffsAffectedByUserSQL, 1003, 1007);
            stmt.setFetchDirection(1000);
            stmt.setFetchSize(this.getFetchSize());
            stmt.setLong(1, userID);
            log.debug("Executing SQL query: {}", (Object)this.getDiffsAffectedByUserSQL);
            rs = stmt.executeQuery();
            while (rs.next()) {
                int count = rs.getInt(1);
                long itemIDA = rs.getLong(3);
                long itemIDB = rs.getLong(4);
                if (count == this.minDiffCount) {
                    this.removeOneDiff(conn, itemIDA, itemIDB);
                    continue;
                }
                float average = rs.getFloat(2);
                float currentOtherPrefValue = rs.getFloat(5);
                float prefDelta = itemID == itemIDA ? currentOtherPrefValue - prefValue : prefValue - currentOtherPrefValue;
                float newAverage = (average * (float)count - prefDelta) / (float)(count - 1);
                this.updateOneDiff(conn, count - 1, newAverage, itemIDA, itemIDB);
            }
        }
        catch (SQLException sqle) {
            try {
                log.warn("Exception while removing item diff", (Throwable)sqle);
                throw new TasteException((Throwable)sqle);
            }
            catch (Throwable throwable) {
                IOUtils.quietClose(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        IOUtils.quietClose((ResultSet)rs, (Statement)stmt, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeOneDiff(Connection conn, long itemIDA, long itemIDB) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(this.removeDiffSQL);
        try {
            stmt.setLong(1, itemIDA);
            stmt.setLong(2, itemIDB);
            log.debug("Executing SQL update: {}", (Object)this.removeDiffSQL);
            stmt.executeUpdate();
        }
        finally {
            IOUtils.quietClose((Statement)stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doPartialUpdate(String sql, long itemID, double prefDelta, Connection conn) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(sql);
        try {
            stmt.setDouble(1, prefDelta);
            stmt.setLong(2, itemID);
            log.debug("Executing SQL update: {}", (Object)sql);
            stmt.executeUpdate();
        }
        finally {
            IOUtils.quietClose((Statement)stmt);
        }
    }

    public FastIDSet getRecommendableItemIDs(long userID) throws TasteException {
        FastIDSet fastIDSet;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.dataSource.getConnection();
            stmt = conn.prepareStatement(this.getRecommendableItemsSQL, 1003, 1007);
            stmt.setFetchDirection(1000);
            stmt.setFetchSize(this.getFetchSize());
            stmt.setLong(1, userID);
            stmt.setLong(2, userID);
            stmt.setLong(3, userID);
            log.debug("Executing SQL query: {}", (Object)this.getRecommendableItemsSQL);
            rs = stmt.executeQuery();
            FastIDSet itemIDs = new FastIDSet();
            while (rs.next()) {
                itemIDs.add(rs.getLong(1));
            }
            fastIDSet = itemIDs;
        }
        catch (SQLException sqle) {
            try {
                log.warn("Exception while retrieving recommendable items", (Throwable)sqle);
                throw new TasteException((Throwable)sqle);
            }
            catch (Throwable throwable) {
                IOUtils.quietClose(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        IOUtils.quietClose((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return fastIDSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildAverageDiffs() throws TasteException {
        Connection conn = null;
        try {
            conn = this.dataSource.getConnection();
            PreparedStatement stmt = null;
            try {
                stmt = conn.prepareStatement(this.deleteDiffsSQL);
                log.debug("Executing SQL update: {}", (Object)this.deleteDiffsSQL);
                stmt.executeUpdate();
            }
            catch (Throwable throwable) {
                IOUtils.quietClose(stmt);
                throw throwable;
            }
            IOUtils.quietClose((Statement)stmt);
            try {
                stmt = conn.prepareStatement(this.createDiffsSQL);
                stmt.setInt(1, this.minDiffCount);
                log.debug("Executing SQL update: {}", (Object)this.createDiffsSQL);
                stmt.executeUpdate();
            }
            finally {
                IOUtils.quietClose((Statement)stmt);
            }
        }
        catch (SQLException sqle) {
            log.warn("Exception while updating/deleting diffs", (Throwable)sqle);
            throw new TasteException((Throwable)sqle);
        }
        finally {
            IOUtils.quietClose((Connection)conn);
        }
    }

    private boolean isDiffsExist() throws TasteException {
        boolean bl;
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.dataSource.getConnection();
            stmt = conn.createStatement(1003, 1007);
            stmt.setFetchDirection(1000);
            stmt.setFetchSize(this.getFetchSize());
            log.debug("Executing SQL query: {}", (Object)this.diffsExistSQL);
            rs = stmt.executeQuery(this.diffsExistSQL);
            rs.next();
            bl = rs.getInt(1) > 0;
        }
        catch (SQLException sqle) {
            try {
                log.warn("Exception while deleting diffs", (Throwable)sqle);
                throw new TasteException((Throwable)sqle);
            }
            catch (Throwable throwable) {
                IOUtils.quietClose(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        IOUtils.quietClose((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return bl;
    }

    public void refresh(Collection<Refreshable> alreadyRefreshed) {
        this.refreshHelper.refresh(alreadyRefreshed);
    }
}

