/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.evaluation;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli2.Option;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.clustering.AbstractCluster;
import org.apache.mahout.clustering.Cluster;
import org.apache.mahout.clustering.classify.WeightedVectorWritable;
import org.apache.mahout.clustering.evaluation.RepresentativePointsMapper;
import org.apache.mahout.clustering.evaluation.RepresentativePointsReducer;
import org.apache.mahout.clustering.iterator.ClusterWritable;
import org.apache.mahout.common.AbstractJob;
import org.apache.mahout.common.ClassUtils;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.commandline.DefaultOptionCreator;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.common.iterator.sequencefile.PathFilters;
import org.apache.mahout.common.iterator.sequencefile.PathType;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileDirIterable;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileValueIterable;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RepresentativePointsDriver
extends AbstractJob {
    public static final String STATE_IN_KEY = "org.apache.mahout.clustering.stateIn";
    public static final String DISTANCE_MEASURE_KEY = "org.apache.mahout.clustering.measure";
    private static final Logger log = LoggerFactory.getLogger(RepresentativePointsDriver.class);

    private RepresentativePointsDriver() {
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Configuration)new Configuration(), (Tool)new RepresentativePointsDriver(), (String[])args);
    }

    public int run(String[] args) throws ClassNotFoundException, IOException, InterruptedException {
        this.addInputOption();
        this.addOutputOption();
        this.addOption("clusteredPoints", "cp", "The path to the clustered points", true);
        this.addOption((Option)DefaultOptionCreator.distanceMeasureOption().create());
        this.addOption((Option)DefaultOptionCreator.maxIterationsOption().create());
        this.addOption((Option)DefaultOptionCreator.methodOption().create());
        if (this.parseArguments(args) == null) {
            return -1;
        }
        Path input = this.getInputPath();
        Path output = this.getOutputPath();
        String distanceMeasureClass = this.getOption("distanceMeasure");
        int maxIterations = Integer.parseInt(this.getOption("maxIter"));
        boolean runSequential = this.getOption("method").equalsIgnoreCase("sequential");
        DistanceMeasure measure = (DistanceMeasure)ClassUtils.instantiateAs((String)distanceMeasureClass, DistanceMeasure.class);
        Path clusteredPoints = new Path(this.getOption("clusteredPoints"));
        RepresentativePointsDriver.run(this.getConf(), input, clusteredPoints, output, measure, maxIterations, runSequential);
        return 0;
    }

    public static void printRepresentativePoints(Path output, int numIterations) {
        for (int i = 0; i <= numIterations; ++i) {
            Path out = new Path(output, "representativePoints-" + i);
            System.out.println("Representative Points for iteration " + i);
            Configuration conf = new Configuration();
            for (Pair record : new SequenceFileDirIterable(out, PathType.LIST, PathFilters.logsCRCFilter(), null, true, conf)) {
                System.out.println("\tC-" + ((IntWritable)record.getFirst()).get() + ": " + AbstractCluster.formatVector((Vector)((VectorWritable)record.getSecond()).get(), null));
            }
        }
    }

    public static void run(Configuration conf, Path clustersIn, Path clusteredPointsIn, Path output, DistanceMeasure measure, int numIterations, boolean runSequential) throws IOException, InterruptedException, ClassNotFoundException {
        Path stateIn = new Path(output, "representativePoints-0");
        RepresentativePointsDriver.writeInitialState(stateIn, clustersIn);
        for (int iteration = 0; iteration < numIterations; ++iteration) {
            log.info("Representative Points Iteration {}", (Object)iteration);
            Path stateOut = new Path(output, "representativePoints-" + (iteration + 1));
            RepresentativePointsDriver.runIteration(conf, clusteredPointsIn, stateIn, stateOut, measure, runSequential);
            stateIn = stateOut;
        }
        conf.set(STATE_IN_KEY, stateIn.toString());
        conf.set(DISTANCE_MEASURE_KEY, measure.getClass().getName());
    }

    private static void writeInitialState(Path output, Path clustersIn) throws IOException {
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((URI)output.toUri(), (Configuration)conf);
        for (FileStatus dir : fs.globStatus(clustersIn)) {
            Path inPath = dir.getPath();
            for (FileStatus part : fs.listStatus(inPath, PathFilters.logsCRCFilter())) {
                Path inPart = part.getPath();
                Path path = new Path(output, inPart.getName());
                try (SequenceFile.Writer writer = new SequenceFile.Writer(fs, conf, path, IntWritable.class, VectorWritable.class);){
                    for (ClusterWritable clusterWritable : new SequenceFileValueIterable(inPart, true, conf)) {
                        Cluster cluster = clusterWritable.getValue();
                        if (log.isDebugEnabled()) {
                            log.debug("C-{}: {}", (Object)cluster.getId(), (Object)AbstractCluster.formatVector((Vector)cluster.getCenter(), null));
                        }
                        writer.append((Writable)new IntWritable(cluster.getId()), (Writable)new VectorWritable(cluster.getCenter()));
                    }
                }
            }
        }
    }

    private static void runIteration(Configuration conf, Path clusteredPointsIn, Path stateIn, Path stateOut, DistanceMeasure measure, boolean runSequential) throws IOException, InterruptedException, ClassNotFoundException {
        if (runSequential) {
            RepresentativePointsDriver.runIterationSeq(conf, clusteredPointsIn, stateIn, stateOut, measure);
        } else {
            RepresentativePointsDriver.runIterationMR(conf, clusteredPointsIn, stateIn, stateOut, measure);
        }
    }

    private static void runIterationSeq(Configuration conf, Path clusteredPointsIn, Path stateIn, Path stateOut, DistanceMeasure measure) throws IOException {
        Map<Integer, List<VectorWritable>> repPoints = RepresentativePointsMapper.getRepresentativePoints(conf, stateIn);
        HashMap<Integer, WeightedVectorWritable> mostDistantPoints = new HashMap<Integer, WeightedVectorWritable>();
        FileSystem fs = FileSystem.get((URI)clusteredPointsIn.toUri(), (Configuration)conf);
        for (Pair record : new SequenceFileDirIterable(clusteredPointsIn, PathType.LIST, PathFilters.logsCRCFilter(), null, true, conf)) {
            RepresentativePointsMapper.mapPoint((IntWritable)record.getFirst(), (WeightedVectorWritable)record.getSecond(), measure, repPoints, mostDistantPoints);
        }
        int part = 0;
        try (SequenceFile.Writer writer = new SequenceFile.Writer(fs, conf, new Path(stateOut, "part-m-" + part++), IntWritable.class, VectorWritable.class);){
            for (Map.Entry<Integer, List<VectorWritable>> entry : repPoints.entrySet()) {
                for (VectorWritable vw : entry.getValue()) {
                    writer.append((Writable)new IntWritable(entry.getKey().intValue()), (Writable)vw);
                }
            }
        }
        writer = new SequenceFile.Writer(fs, conf, new Path(stateOut, "part-m-" + part++), IntWritable.class, VectorWritable.class);
        var10_11 = null;
        try {
            for (Map.Entry<Integer, List<Object>> entry : mostDistantPoints.entrySet()) {
                writer.append((Writable)new IntWritable(entry.getKey().intValue()), (Writable)new VectorWritable(((WeightedVectorWritable)entry.getValue()).getVector()));
            }
        }
        catch (Throwable throwable) {
            var10_11 = throwable;
            throw throwable;
        }
        finally {
            if (writer != null) {
                if (var10_11 != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable) {
                        var10_11.addSuppressed(throwable);
                    }
                } else {
                    writer.close();
                }
            }
        }
    }

    private static void runIterationMR(Configuration conf, Path input, Path stateIn, Path stateOut, DistanceMeasure measure) throws IOException, InterruptedException, ClassNotFoundException {
        conf.set(STATE_IN_KEY, stateIn.toString());
        conf.set(DISTANCE_MEASURE_KEY, measure.getClass().getName());
        Job job = new Job(conf, "Representative Points Driver running over input: " + input);
        job.setJarByClass(RepresentativePointsDriver.class);
        job.setOutputKeyClass(IntWritable.class);
        job.setOutputValueClass(VectorWritable.class);
        job.setMapOutputKeyClass(IntWritable.class);
        job.setMapOutputValueClass(WeightedVectorWritable.class);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{input});
        FileOutputFormat.setOutputPath((Job)job, (Path)stateOut);
        job.setMapperClass(RepresentativePointsMapper.class);
        job.setReducerClass(RepresentativePointsReducer.class);
        job.setInputFormatClass(SequenceFileInputFormat.class);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
        boolean succeeded = job.waitForCompletion(true);
        if (!succeeded) {
            throw new IllegalStateException("Job failed!");
        }
    }
}

