/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.similarity.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.locks.ReentrantLock;
import javax.sql.DataSource;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.jdbc.AbstractJDBCComponent;
import org.apache.mahout.cf.taste.impl.common.jdbc.ResultSetIterator;
import org.apache.mahout.cf.taste.impl.model.jdbc.ConnectionPoolDataSource;
import org.apache.mahout.cf.taste.impl.similarity.GenericItemSimilarity;
import org.apache.mahout.cf.taste.similarity.ItemSimilarity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractJDBCInMemoryItemSimilarity
extends AbstractJDBCComponent
implements ItemSimilarity {
    private ItemSimilarity delegate;
    private final DataSource dataSource;
    private final String getAllItemSimilaritiesSQL;
    private final ReentrantLock reloadLock;
    private static final Logger log = LoggerFactory.getLogger(AbstractJDBCInMemoryItemSimilarity.class);

    AbstractJDBCInMemoryItemSimilarity(DataSource dataSource, String getAllItemSimilaritiesSQL) {
        AbstractJDBCComponent.checkNotNullAndLog((String)"getAllItemSimilaritiesSQL", (Object)getAllItemSimilaritiesSQL);
        if (!(dataSource instanceof ConnectionPoolDataSource)) {
            log.warn("You are not using ConnectionPoolDataSource. Make sure your DataSource pools connections to the database itself, or database performance will be severely reduced.");
        }
        this.dataSource = dataSource;
        this.getAllItemSimilaritiesSQL = getAllItemSimilaritiesSQL;
        this.reloadLock = new ReentrantLock();
        this.reload();
    }

    public double itemSimilarity(long itemID1, long itemID2) throws TasteException {
        return this.delegate.itemSimilarity(itemID1, itemID2);
    }

    public double[] itemSimilarities(long itemID1, long[] itemID2s) throws TasteException {
        return this.delegate.itemSimilarities(itemID1, itemID2s);
    }

    public long[] allSimilarItemIDs(long itemID) throws TasteException {
        return this.delegate.allSimilarItemIDs(itemID);
    }

    public void refresh(Collection<Refreshable> alreadyRefreshed) {
        log.debug("Reloading...");
        this.reload();
    }

    protected void reload() {
        if (this.reloadLock.tryLock()) {
            try {
                this.delegate = new GenericItemSimilarity((Iterable)new JDBCSimilaritiesIterable(this.dataSource, this.getAllItemSimilaritiesSQL));
            }
            finally {
                this.reloadLock.unlock();
            }
        }
    }

    private static final class JDBCSimilaritiesIterator
    extends ResultSetIterator<GenericItemSimilarity.ItemItemSimilarity> {
        private JDBCSimilaritiesIterator(DataSource dataSource, String getAllItemSimilaritiesSQL) throws SQLException {
            super(dataSource, getAllItemSimilaritiesSQL);
        }

        protected GenericItemSimilarity.ItemItemSimilarity parseElement(ResultSet resultSet) throws SQLException {
            return new GenericItemSimilarity.ItemItemSimilarity(resultSet.getLong(1), resultSet.getLong(2), resultSet.getDouble(3));
        }
    }

    private static final class JDBCSimilaritiesIterable
    implements Iterable<GenericItemSimilarity.ItemItemSimilarity> {
        private final DataSource dataSource;
        private final String getAllItemSimilaritiesSQL;

        private JDBCSimilaritiesIterable(DataSource dataSource, String getAllItemSimilaritiesSQL) {
            this.dataSource = dataSource;
            this.getAllItemSimilaritiesSQL = getAllItemSimilaritiesSQL;
        }

        @Override
        public Iterator<GenericItemSimilarity.ItemItemSimilarity> iterator() {
            try {
                return new JDBCSimilaritiesIterator(this.dataSource, this.getAllItemSimilaritiesSQL);
            }
            catch (SQLException sqle) {
                throw new IllegalStateException(sqle);
            }
        }
    }
}

