/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.index;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.IntConsumer;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.codecs.simpletext.SimpleTextCodec;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StoredValue;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.EmptyDocValuesProducer;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.SerialMergeScheduler;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TieredMergePolicy;
import org.apache.lucene.internal.tests.IndexWriterAccess;
import org.apache.lucene.internal.tests.TestSecrets;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.FilterIndexInput;
import org.apache.lucene.store.FlushInfo;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.tests.analysis.MockAnalyzer;
import org.apache.lucene.tests.index.MergingDirectoryReaderWrapper;
import org.apache.lucene.tests.store.BaseDirectoryWrapper;
import org.apache.lucene.tests.store.MockDirectoryWrapper;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.apache.lucene.tests.util.RamUsageTester;
import org.apache.lucene.tests.util.Rethrow;
import org.apache.lucene.tests.util.TestUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CloseableThreadLocal;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.Version;

abstract class BaseIndexFileFormatTestCase
extends LuceneTestCase {
    private static final IndexWriterAccess INDEX_WRITER_ACCESS = TestSecrets.getIndexWriterAccess();
    private static final Set<Class<?>> EXCLUDED_CLASSES = Collections.newSetFromMap(new IdentityHashMap());
    private Codec savedCodec;

    BaseIndexFileFormatTestCase() {
    }

    protected abstract Codec getCodec();

    protected int getCreatedVersionMajor() {
        return Version.LATEST.major;
    }

    protected final <D extends Directory> D applyCreatedVersionMajor(D d) throws IOException {
        if (SegmentInfos.getLastCommitGeneration(d) != -1L) {
            throw new IllegalArgumentException("Cannot set the created version on a Directory that already has segments");
        }
        if (this.getCreatedVersionMajor() != Version.LATEST.major || BaseIndexFileFormatTestCase.random().nextBoolean()) {
            new SegmentInfos(this.getCreatedVersionMajor()).commit(d);
        }
        return d;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.savedCodec = Codec.getDefault();
        Codec.setDefault((Codec)this.getCodec());
    }

    @Override
    public void tearDown() throws Exception {
        Codec.setDefault((Codec)this.savedCodec);
        super.tearDown();
    }

    protected abstract void addRandomFields(Document var1);

    private Map<String, Long> bytesUsedByExtension(Directory d) throws IOException {
        HashMap<String, Long> bytesUsedByExtension = new HashMap<String, Long>();
        for (String file : d.listAll()) {
            if (!IndexFileNames.CODEC_FILE_PATTERN.matcher(file).matches()) continue;
            String ext = IndexFileNames.getExtension((String)file);
            long previousLength = bytesUsedByExtension.containsKey(ext) ? (Long)bytesUsedByExtension.get(ext) : 0L;
            bytesUsedByExtension.put(ext, previousLength + d.fileLength(file));
        }
        bytesUsedByExtension.keySet().removeAll(this.excludedExtensionsFromByteCounts());
        return bytesUsedByExtension;
    }

    protected Collection<String> excludedExtensionsFromByteCounts() {
        return new HashSet<String>(Arrays.asList("si", "lock"));
    }

    public void testMergeStability() throws Exception {
        BaseIndexFileFormatTestCase.assumeTrue("merge is not stable", this.mergeIsStable());
        BaseDirectoryWrapper dir = this.applyCreatedVersionMajor(BaseIndexFileFormatTestCase.newDirectory());
        TieredMergePolicy mp = BaseIndexFileFormatTestCase.newTieredMergePolicy();
        mp.setNoCFSRatio(0.0);
        IndexWriterConfig cfg = new IndexWriterConfig((Analyzer)new MockAnalyzer(BaseIndexFileFormatTestCase.random())).setUseCompoundFile(false).setMergePolicy((MergePolicy)mp);
        IndexWriter w = new IndexWriter((Directory)dir, cfg);
        int numDocs = BaseIndexFileFormatTestCase.atLeast(500);
        for (int i = 0; i < numDocs; ++i) {
            Document d = new Document();
            this.addRandomFields(d);
            w.addDocument((Iterable)d);
        }
        w.forceMerge(1);
        w.commit();
        w.close();
        DirectoryReader reader = DirectoryReader.open((Directory)dir);
        BaseDirectoryWrapper dir2 = this.applyCreatedVersionMajor(BaseIndexFileFormatTestCase.newDirectory());
        mp = BaseIndexFileFormatTestCase.newTieredMergePolicy();
        mp.setNoCFSRatio(0.0);
        cfg = new IndexWriterConfig((Analyzer)new MockAnalyzer(BaseIndexFileFormatTestCase.random())).setUseCompoundFile(false).setMergePolicy((MergePolicy)mp);
        w = new IndexWriter((Directory)dir2, cfg);
        TestUtil.addIndexesSlowly(w, reader);
        w.commit();
        w.close();
        BaseIndexFileFormatTestCase.assertEquals(this.bytesUsedByExtension((Directory)dir), this.bytesUsedByExtension((Directory)dir2));
        reader.close();
        dir.close();
        dir2.close();
    }

    protected boolean mergeIsStable() {
        return true;
    }

    public void testMultiClose() throws IOException {
        BaseDirectoryWrapper oneDocIndex = this.applyCreatedVersionMajor(BaseIndexFileFormatTestCase.newDirectory());
        IndexWriter iw = new IndexWriter((Directory)oneDocIndex, new IndexWriterConfig((Analyzer)new MockAnalyzer(BaseIndexFileFormatTestCase.random())));
        Document oneDoc = new Document();
        FieldType customType = new FieldType((IndexableFieldType)TextField.TYPE_STORED);
        customType.setStoreTermVectors(true);
        org.apache.lucene.document.Field customField = new org.apache.lucene.document.Field("field", (CharSequence)"contents", (IndexableFieldType)customType);
        oneDoc.add((IndexableField)customField);
        oneDoc.add((IndexableField)new NumericDocValuesField("field", 5L));
        iw.addDocument((Iterable)oneDoc);
        final LeafReader oneDocReader = BaseIndexFileFormatTestCase.getOnlyLeafReader((IndexReader)DirectoryReader.open((IndexWriter)iw));
        iw.close();
        BaseDirectoryWrapper dir = BaseIndexFileFormatTestCase.newFSDirectory(BaseIndexFileFormatTestCase.createTempDir("justSoYouGetSomeChannelErrors"));
        Codec codec = this.getCodec();
        SegmentInfo segmentInfo = new SegmentInfo((Directory)dir, Version.LATEST, Version.LATEST, "_0", 1, false, codec, Collections.emptyMap(), StringHelper.randomId(), Collections.emptyMap(), null);
        FieldInfo proto = oneDocReader.getFieldInfos().fieldInfo("field");
        FieldInfo field = new FieldInfo(proto.name, proto.number, proto.hasVectors(), proto.omitsNorms(), proto.hasPayloads(), proto.getIndexOptions(), proto.getDocValuesType(), proto.getDocValuesGen(), new HashMap(), proto.getPointDimensionCount(), proto.getPointIndexDimensionCount(), proto.getPointNumBytes(), proto.getVectorDimension(), proto.getVectorEncoding(), proto.getVectorSimilarityFunction(), proto.isSoftDeletesField());
        FieldInfos fieldInfos = new FieldInfos(new FieldInfo[]{field});
        SegmentWriteState writeState = new SegmentWriteState(null, (Directory)dir, segmentInfo, fieldInfos, null, new IOContext(new FlushInfo(1, 20L)));
        SegmentReadState readState = new SegmentReadState((Directory)dir, segmentInfo, fieldInfos, IOContext.READ);
        NormsProducer fakeNorms = new NormsProducer(){

            public void close() throws IOException {
            }

            public NumericDocValues getNorms(FieldInfo field) throws IOException {
                if (!field.hasNorms()) {
                    return null;
                }
                return oneDocReader.getNormValues(field.name);
            }

            public void checkIntegrity() throws IOException {
            }
        };
        try (FieldsConsumer consumer = codec.postingsFormat().fieldsConsumer(writeState);){
            Fields fields = new Fields(){
                TreeSet<String> indexedFields;
                {
                    this.indexedFields = new TreeSet(FieldInfos.getIndexedFields((IndexReader)oneDocReader));
                }

                public Iterator<String> iterator() {
                    return this.indexedFields.iterator();
                }

                public Terms terms(String field) throws IOException {
                    return oneDocReader.terms(field);
                }

                public int size() {
                    return this.indexedFields.size();
                }
            };
            consumer.write(fields, fakeNorms);
            IOUtils.close((Closeable[])new Closeable[]{consumer});
            IOUtils.close((Closeable[])new Closeable[]{consumer});
        }
        try (FieldsProducer producer = codec.postingsFormat().fieldsProducer(readState);){
            IOUtils.close((Closeable[])new Closeable[]{producer});
            IOUtils.close((Closeable[])new Closeable[]{producer});
        }
        consumer = codec.docValuesFormat().fieldsConsumer(writeState);
        try {
            consumer.addNumericField(field, (DocValuesProducer)new EmptyDocValuesProducer(){

                public NumericDocValues getNumeric(FieldInfo field) {
                    return new NumericDocValues(){
                        int docID = -1;

                        public int docID() {
                            return this.docID;
                        }

                        public int nextDoc() {
                            ++this.docID;
                            if (this.docID == 1) {
                                this.docID = Integer.MAX_VALUE;
                            }
                            return this.docID;
                        }

                        public int advance(int target) {
                            this.docID = this.docID <= 0 && target == 0 ? 0 : Integer.MAX_VALUE;
                            return this.docID;
                        }

                        public boolean advanceExact(int target) throws IOException {
                            this.docID = target;
                            return target == 0;
                        }

                        public long cost() {
                            return 1L;
                        }

                        public long longValue() {
                            return 5L;
                        }
                    };
                }
            });
            IOUtils.close((Closeable[])new Closeable[]{consumer});
            IOUtils.close((Closeable[])new Closeable[]{consumer});
        }
        finally {
            if (consumer != null) {
                consumer.close();
            }
        }
        producer = codec.docValuesFormat().fieldsProducer(readState);
        try {
            IOUtils.close((Closeable[])new Closeable[]{producer});
            IOUtils.close((Closeable[])new Closeable[]{producer});
        }
        finally {
            if (producer != null) {
                producer.close();
            }
        }
        consumer = codec.normsFormat().normsConsumer(writeState);
        try {
            consumer.addNormsField(field, new NormsProducer(){

                public NumericDocValues getNorms(FieldInfo field) {
                    return new NumericDocValues(){
                        int docID = -1;

                        public int docID() {
                            return this.docID;
                        }

                        public int nextDoc() {
                            ++this.docID;
                            if (this.docID == 1) {
                                this.docID = Integer.MAX_VALUE;
                            }
                            return this.docID;
                        }

                        public int advance(int target) {
                            this.docID = this.docID <= 0 && target == 0 ? 0 : Integer.MAX_VALUE;
                            return this.docID;
                        }

                        public boolean advanceExact(int target) throws IOException {
                            this.docID = target;
                            return target == 0;
                        }

                        public long cost() {
                            return 1L;
                        }

                        public long longValue() {
                            return 5L;
                        }
                    };
                }

                public void checkIntegrity() {
                }

                public void close() {
                }
            });
            IOUtils.close((Closeable[])new Closeable[]{consumer});
            IOUtils.close((Closeable[])new Closeable[]{consumer});
        }
        finally {
            if (consumer != null) {
                consumer.close();
            }
        }
        producer = codec.normsFormat().normsProducer(readState);
        try {
            IOUtils.close((Closeable[])new Closeable[]{producer});
            IOUtils.close((Closeable[])new Closeable[]{producer});
        }
        finally {
            if (producer != null) {
                producer.close();
            }
        }
        consumer = codec.termVectorsFormat().vectorsWriter((Directory)dir, segmentInfo, writeState.context);
        try {
            consumer.startDocument(1);
            consumer.startField(field, 1, false, false, false);
            consumer.startTerm(new BytesRef((CharSequence)"testing"), 2);
            consumer.finishTerm();
            consumer.finishField();
            consumer.finishDocument();
            consumer.finish(1);
            IOUtils.close((Closeable[])new Closeable[]{consumer});
            IOUtils.close((Closeable[])new Closeable[]{consumer});
        }
        finally {
            if (consumer != null) {
                consumer.close();
            }
        }
        producer = codec.termVectorsFormat().vectorsReader((Directory)dir, segmentInfo, fieldInfos, readState.context);
        try {
            IOUtils.close((Closeable[])new Closeable[]{producer});
            IOUtils.close((Closeable[])new Closeable[]{producer});
        }
        finally {
            if (producer != null) {
                producer.close();
            }
        }
        consumer = codec.storedFieldsFormat().fieldsWriter((Directory)dir, segmentInfo, writeState.context);
        try {
            consumer.startDocument();
            StoredValue value = customField.storedValue();
            switch (value.getType()) {
                case INTEGER: {
                    consumer.writeField(field, value.getIntValue());
                    break;
                }
                case LONG: {
                    consumer.writeField(field, value.getLongValue());
                    break;
                }
                case FLOAT: {
                    consumer.writeField(field, value.getFloatValue());
                    break;
                }
                case DOUBLE: {
                    consumer.writeField(field, value.getDoubleValue());
                    break;
                }
                case BINARY: {
                    consumer.writeField(field, value.getBinaryValue());
                    break;
                }
                case STRING: {
                    consumer.writeField(field, value.getStringValue());
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            consumer.finishDocument();
            consumer.finish(1);
            IOUtils.close((Closeable[])new Closeable[]{consumer});
            IOUtils.close((Closeable[])new Closeable[]{consumer});
        }
        finally {
            if (consumer != null) {
                consumer.close();
            }
        }
        producer = codec.storedFieldsFormat().fieldsReader((Directory)dir, segmentInfo, fieldInfos, readState.context);
        try {
            IOUtils.close((Closeable[])new Closeable[]{producer});
            IOUtils.close((Closeable[])new Closeable[]{producer});
        }
        finally {
            if (producer != null) {
                producer.close();
            }
        }
        IOUtils.close((Closeable[])new Closeable[]{oneDocReader, oneDocIndex, dir});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRandomExceptions() throws Exception {
        MockDirectoryWrapper dir = this.applyCreatedVersionMajor(BaseIndexFileFormatTestCase.newMockDirectory());
        dir.setThrottling(MockDirectoryWrapper.Throttling.NEVER);
        dir.setUseSlowOpenClosers(false);
        dir.setRandomIOExceptionRate(0.001);
        ByteArrayOutputStream exceptionLog = new ByteArrayOutputStream();
        PrintStream exceptionStream = new PrintStream((OutputStream)exceptionLog, true, "UTF-8");
        MockAnalyzer analyzer = new MockAnalyzer(BaseIndexFileFormatTestCase.random());
        IndexWriterConfig conf = BaseIndexFileFormatTestCase.newIndexWriterConfig(analyzer);
        conf.setMergeScheduler((MergeScheduler)new SerialMergeScheduler());
        conf.setCodec(this.getCodec());
        int numDocs = BaseIndexFileFormatTestCase.atLeast(500);
        IndexWriter iw = new IndexWriter((Directory)dir, conf);
        try {
            boolean allowAlreadyClosed = false;
            for (int i = 0; i < numDocs; ++i) {
                dir.setRandomIOExceptionRateOnOpen(0.02);
                Document doc = new Document();
                doc.add((IndexableField)BaseIndexFileFormatTestCase.newStringField("id", Integer.toString(i), Field.Store.NO));
                this.addRandomFields(doc);
                try {
                    iw.addDocument((Iterable)doc);
                    iw.deleteDocuments(new Term[]{new Term("id", Integer.toString(i))});
                }
                catch (AlreadyClosedException ace) {
                    dir.setRandomIOExceptionRateOnOpen(0.0);
                    BaseIndexFileFormatTestCase.assertTrue((boolean)INDEX_WRITER_ACCESS.isDeleterClosed(iw));
                    BaseIndexFileFormatTestCase.assertTrue((boolean)allowAlreadyClosed);
                    allowAlreadyClosed = false;
                    conf = BaseIndexFileFormatTestCase.newIndexWriterConfig(analyzer);
                    conf.setMergeScheduler((MergeScheduler)new SerialMergeScheduler());
                    conf.setCodec(this.getCodec());
                    iw = new IndexWriter((Directory)dir, conf);
                }
                catch (IOException e) {
                    this.handleFakeIOException(e, exceptionStream);
                    allowAlreadyClosed = true;
                }
                if (BaseIndexFileFormatTestCase.random().nextInt(10) != 0) continue;
                try {
                    block17: {
                        block16: {
                            if (!BaseIndexFileFormatTestCase.random().nextBoolean()) break block16;
                            DirectoryReader ir = null;
                            try {
                                ir = DirectoryReader.open((IndexWriter)iw, (boolean)BaseIndexFileFormatTestCase.random().nextBoolean(), (boolean)false);
                                dir.setRandomIOExceptionRateOnOpen(0.0);
                                TestUtil.checkReader((IndexReader)ir);
                            }
                            catch (Throwable throwable) {
                                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{ir});
                                throw throwable;
                            }
                            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{ir});
                            break block17;
                        }
                        dir.setRandomIOExceptionRateOnOpen(0.0);
                        iw.commit();
                    }
                    if (!DirectoryReader.indexExists((Directory)dir)) continue;
                    TestUtil.checkIndex((Directory)dir);
                    continue;
                }
                catch (AlreadyClosedException ace) {
                    dir.setRandomIOExceptionRateOnOpen(0.0);
                    BaseIndexFileFormatTestCase.assertTrue((boolean)INDEX_WRITER_ACCESS.isDeleterClosed(iw));
                    BaseIndexFileFormatTestCase.assertTrue((boolean)allowAlreadyClosed);
                    allowAlreadyClosed = false;
                    conf = BaseIndexFileFormatTestCase.newIndexWriterConfig(analyzer);
                    conf.setMergeScheduler((MergeScheduler)new SerialMergeScheduler());
                    conf.setCodec(this.getCodec());
                    iw = new IndexWriter((Directory)dir, conf);
                    continue;
                }
                catch (IOException e) {
                    this.handleFakeIOException(e, exceptionStream);
                    allowAlreadyClosed = true;
                }
            }
            try {
                dir.setRandomIOExceptionRateOnOpen(0.0);
                iw.close();
            }
            catch (IOException e) {
                this.handleFakeIOException(e, exceptionStream);
                try {
                    iw.rollback();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            dir.close();
        }
        catch (Throwable t) {
            System.out.println("Unexpected exception: dumping fake-exception-log:...");
            exceptionStream.flush();
            System.out.println(exceptionLog.toString("UTF-8"));
            System.out.flush();
            Rethrow.rethrow(t);
        }
        if (VERBOSE) {
            System.out.println("TEST PASSED: dumping fake-exception-log:...");
            System.out.println(exceptionLog.toString("UTF-8"));
        }
    }

    private void handleFakeIOException(IOException e, PrintStream exceptionStream) {
        for (Throwable ex = e; ex != null; ex = ex.getCause()) {
            if (ex.getMessage() == null || !ex.getMessage().startsWith("a random IOException")) continue;
            exceptionStream.println("\nTEST: got expected fake exc:" + ex.getMessage());
            ex.printStackTrace(exceptionStream);
            return;
        }
        Rethrow.rethrow(e);
    }

    protected boolean shouldTestMergeInstance() {
        return false;
    }

    protected final DirectoryReader maybeWrapWithMergingReader(DirectoryReader r) throws IOException {
        if (this.shouldTestMergeInstance()) {
            r = new MergingDirectoryReaderWrapper((DirectoryReader)r);
        }
        return r;
    }

    public void testCheckIntegrityReadsAllBytes() throws Exception {
        BaseIndexFileFormatTestCase.assumeFalse("SimpleText doesn't store checksums of its files", this.getCodec() instanceof SimpleTextCodec);
        FileTrackingDirectoryWrapper dir = new FileTrackingDirectoryWrapper((Directory)BaseIndexFileFormatTestCase.newDirectory());
        this.applyCreatedVersionMajor(dir);
        IndexWriterConfig cfg = new IndexWriterConfig((Analyzer)new MockAnalyzer(BaseIndexFileFormatTestCase.random()));
        IndexWriter w = new IndexWriter((Directory)dir, cfg);
        int numDocs = BaseIndexFileFormatTestCase.atLeast(100);
        for (int i = 0; i < numDocs; ++i) {
            Document d = new Document();
            this.addRandomFields(d);
            w.addDocument((Iterable)d);
        }
        w.forceMerge(1);
        w.commit();
        w.close();
        ReadBytesDirectoryWrapper readBytesWrapperDir = new ReadBytesDirectoryWrapper((Directory)dir);
        DirectoryReader reader = DirectoryReader.open((Directory)readBytesWrapperDir);
        LeafReader leafReader = BaseIndexFileFormatTestCase.getOnlyLeafReader((IndexReader)reader);
        leafReader.checkIntegrity();
        Map<String, FixedBitSet> readBytesMap = readBytesWrapperDir.getReadBytes();
        HashSet<String> unreadFiles = new HashSet<String>(dir.getFiles());
        System.out.println(Arrays.toString(dir.listAll()));
        unreadFiles.removeAll(readBytesMap.keySet());
        unreadFiles.remove("write.lock");
        BaseIndexFileFormatTestCase.assertTrue((String)("Some files have not been open: " + unreadFiles), (boolean)unreadFiles.isEmpty());
        ArrayList<CallSite> messages = new ArrayList<CallSite>();
        for (Map.Entry<String, FixedBitSet> entry : readBytesMap.entrySet()) {
            String name = entry.getKey();
            FixedBitSet unreadBytes = entry.getValue().clone();
            unreadBytes.flip(0, unreadBytes.length());
            int unread = unreadBytes.nextSetBit(0);
            if (unread == Integer.MAX_VALUE) continue;
            messages.add((CallSite)((Object)("Offset " + unread + " of file " + name + "(" + unreadBytes.length() + "bytes) was not read.")));
        }
        BaseIndexFileFormatTestCase.assertTrue((String)String.join((CharSequence)"\n", messages), (boolean)messages.isEmpty());
        reader.close();
        dir.close();
    }

    static {
        EXCLUDED_CLASSES.add(Directory.class);
        EXCLUDED_CLASSES.add(IndexInput.class);
        EXCLUDED_CLASSES.add(CloseableThreadLocal.class);
        EXCLUDED_CLASSES.add(ThreadLocal.class);
        EXCLUDED_CLASSES.add(IndexReader.class);
        EXCLUDED_CLASSES.add(IndexReaderContext.class);
        EXCLUDED_CLASSES.add(FieldInfos.class);
        EXCLUDED_CLASSES.add(SegmentInfo.class);
        EXCLUDED_CLASSES.add(SegmentCommitInfo.class);
        EXCLUDED_CLASSES.add(FieldInfo.class);
        EXCLUDED_CLASSES.add(String.class);
    }

    protected static class ReadBytesDirectoryWrapper
    extends FilterDirectory {
        private final Map<String, FixedBitSet> readBytes = new ConcurrentHashMap<String, FixedBitSet>();

        public ReadBytesDirectoryWrapper(Directory in) {
            super(in);
        }

        public Map<String, FixedBitSet> getReadBytes() {
            return Map.copyOf(this.readBytes);
        }

        public IndexInput openInput(String name, IOContext context) throws IOException {
            IndexInput in = super.openInput(name, context);
            FixedBitSet set = this.readBytes.computeIfAbsent(name, n -> new FixedBitSet(Math.toIntExact(in.length())));
            if ((long)set.length() != in.length()) {
                throw new IllegalStateException();
            }
            return new ReadBytesIndexInputWrapper(in, arg_0 -> ((FixedBitSet)set).set(arg_0));
        }

        public ChecksumIndexInput openChecksumInput(String name, IOContext context) throws IOException {
            final ChecksumIndexInput in = super.openChecksumInput(name, context);
            final FixedBitSet set = this.readBytes.computeIfAbsent(name, n -> new FixedBitSet(Math.toIntExact(in.length())));
            if ((long)set.length() != in.length()) {
                throw new IllegalStateException();
            }
            return new ChecksumIndexInput(in.toString()){

                public void readBytes(byte[] b, int offset, int len) throws IOException {
                    int fp = Math.toIntExact(this.getFilePointer());
                    set.set(fp, Math.addExact(fp, len));
                    in.readBytes(b, offset, len);
                }

                public byte readByte() throws IOException {
                    set.set(Math.toIntExact(this.getFilePointer()));
                    return in.readByte();
                }

                public IndexInput slice(String sliceDescription, long offset, long length) throws IOException {
                    throw new UnsupportedOperationException();
                }

                public long length() {
                    return in.length();
                }

                public long getFilePointer() {
                    return in.getFilePointer();
                }

                public void close() throws IOException {
                    in.close();
                }

                public long getChecksum() throws IOException {
                    return in.getChecksum();
                }
            };
        }

        public IndexOutput createOutput(String name, IOContext context) throws IOException {
            throw new UnsupportedOperationException();
        }

        public IndexOutput createTempOutput(String prefix, String suffix, IOContext context) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    private static class ReadBytesIndexInputWrapper
    extends FilterIndexInput {
        private final IntConsumer readByte;

        ReadBytesIndexInputWrapper(IndexInput in, IntConsumer readByte) {
            super(in.toString(), in);
            this.readByte = readByte;
        }

        public IndexInput clone() {
            return new ReadBytesIndexInputWrapper(this.in.clone(), this.readByte);
        }

        public IndexInput slice(String sliceDescription, long offset, long length) throws IOException {
            IndexInput slice = this.in.slice(sliceDescription, offset, length);
            return new ReadBytesIndexInputWrapper(slice, o -> this.readByte.accept(Math.toIntExact(offset + (long)o)));
        }

        public byte readByte() throws IOException {
            this.readByte.accept(Math.toIntExact(this.getFilePointer()));
            return this.in.readByte();
        }

        public void readBytes(byte[] b, int offset, int len) throws IOException {
            int fp = Math.toIntExact(this.getFilePointer());
            for (int i = 0; i < len; ++i) {
                this.readByte.accept(Math.addExact(fp, i));
            }
            this.in.readBytes(b, offset, len);
        }
    }

    protected static class FileTrackingDirectoryWrapper
    extends FilterDirectory {
        private final Set<String> files = Collections.newSetFromMap(new ConcurrentHashMap());

        FileTrackingDirectoryWrapper(Directory in) {
            super(in);
        }

        public Set<String> getFiles() {
            return Set.copyOf(this.files);
        }

        public IndexOutput createOutput(String name, IOContext context) throws IOException {
            this.files.add(name);
            return super.createOutput(name, context);
        }

        public void rename(String source, String dest) throws IOException {
            this.files.remove(source);
            this.files.add(dest);
            super.rename(source, dest);
        }

        public void deleteFile(String name) throws IOException {
            this.files.remove(name);
            super.deleteFile(name);
        }
    }

    static class Accumulator
    extends RamUsageTester.Accumulator {
        private final Object root;

        Accumulator(Object root) {
            this.root = root;
        }

        @Override
        public long accumulateObject(Object o, long shallowSize, Map<Field, Object> fieldValues, Collection<Object> queue) {
            long v;
            for (Class<?> clazz = o.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                if (!EXCLUDED_CLASSES.contains(clazz) || o == this.root) continue;
                return 0L;
            }
            if (o instanceof Collection) {
                Collection coll = (Collection)o;
                queue.addAll((Collection)o);
                v = (long)coll.size() * (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF;
            } else if (o instanceof Map) {
                Map map = (Map)o;
                queue.addAll(map.keySet());
                queue.addAll(map.values());
                v = 2L * (long)map.size() * (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF;
            } else {
                ArrayList<Object> references = new ArrayList<Object>();
                v = super.accumulateObject(o, shallowSize, fieldValues, references);
                for (Object e : references) {
                    if (e instanceof Thread) continue;
                    queue.add(e);
                }
            }
            return v;
        }

        @Override
        public long accumulateArray(Object array, long shallowSize, List<Object> values, Collection<Object> queue) {
            long v = super.accumulateArray(array, shallowSize, values, queue);
            return v;
        }
    }
}

