/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.mockfile;

import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.lucene.tests.mockfile.FilterFileSystem;
import org.apache.lucene.tests.mockfile.FilterPath;

class WindowsPath
extends FilterPath {
    static HashSet<Character> RESERVED_CHARACTERS = new HashSet<Character>(Arrays.asList(Character.valueOf('<'), Character.valueOf('>'), Character.valueOf(':'), Character.valueOf('\"'), Character.valueOf('\\'), Character.valueOf('|'), Character.valueOf('?'), Character.valueOf('*')));
    static HashSet<String> RESERVED_NAMES = new HashSet<String>(Arrays.asList("CON", "PRN", "AUX", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9"));

    WindowsPath(Path path, FilterFileSystem fileSystem) {
        super(path, fileSystem);
    }

    @Override
    public Path resolve(Path other) {
        this.checkInvalidPath(other);
        return this.wrap(this.delegate.resolve(this.toDelegate(other)));
    }

    private void checkInvalidPath(Path other) {
        String fileName = other.getFileName().toString();
        if (RESERVED_NAMES.contains(fileName)) {
            throw new InvalidPathException(fileName, "File name: " + fileName + " is one of the reserved file names");
        }
        for (int i = 0; i < fileName.length(); ++i) {
            if (!RESERVED_CHARACTERS.contains(Character.valueOf(fileName.charAt(i)))) continue;
            throw new InvalidPathException(fileName, "File name: " + fileName + " contains a reserved character: " + fileName.charAt(i));
        }
    }
}

