/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.util;

import com.carrotsearch.randomizedtesting.RandomizedContext;
import com.carrotsearch.randomizedtesting.generators.RandomPicks;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Random;
import java.util.TimeZone;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.lucene99.Lucene99Codec;
import org.apache.lucene.codecs.simpletext.SimpleTextCodec;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.tests.codecs.asserting.AssertingCodec;
import org.apache.lucene.tests.codecs.asserting.AssertingDocValuesFormat;
import org.apache.lucene.tests.codecs.asserting.AssertingPostingsFormat;
import org.apache.lucene.tests.codecs.cheapbastard.CheapBastardCodec;
import org.apache.lucene.tests.codecs.compressing.CompressingCodec;
import org.apache.lucene.tests.codecs.mockrandom.MockRandomPostingsFormat;
import org.apache.lucene.tests.index.RandomCodec;
import org.apache.lucene.tests.search.similarities.AssertingSimilarity;
import org.apache.lucene.tests.search.similarities.RandomSimilarity;
import org.apache.lucene.tests.util.AbstractBeforeAfterRule;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.apache.lucene.tests.util.NullInfoStream;
import org.apache.lucene.util.InfoStream;
import org.apache.lucene.util.PrintStreamInfoStream;
import org.junit.internal.AssumptionViolatedException;

final class TestRuleSetupAndRestoreClassEnv
extends AbstractBeforeAfterRule {
    private Codec savedCodec;
    private Locale savedLocale;
    private TimeZone savedTimeZone;
    private InfoStream savedInfoStream;
    Locale locale;
    TimeZone timeZone;
    Similarity similarity;
    Codec codec;
    private boolean initialized;
    HashSet<String> avoidCodecs;

    TestRuleSetupAndRestoreClassEnv() {
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    protected void before() throws Exception {
        LuceneTestCase.LiveIWCFlushMode flushMode;
        if (LuceneTestCase.VERBOSE) {
            System.out.println("Loaded codecs: " + Codec.availableCodecs());
            System.out.println("Loaded postingsFormats: " + PostingsFormat.availablePostingsFormats());
        }
        this.savedInfoStream = InfoStream.getDefault();
        Random random = RandomizedContext.current().getRandom();
        boolean v = random.nextBoolean();
        if (LuceneTestCase.INFOSTREAM) {
            InfoStream.setDefault((InfoStream)new ThreadNameFixingPrintStreamInfoStream(System.out));
        } else if (v) {
            InfoStream.setDefault((InfoStream)new NullInfoStream());
        }
        Class targetClass = RandomizedContext.current().getTargetClass();
        this.avoidCodecs = new HashSet();
        if (targetClass.isAnnotationPresent(LuceneTestCase.SuppressCodecs.class)) {
            LuceneTestCase.SuppressCodecs a = targetClass.getAnnotation(LuceneTestCase.SuppressCodecs.class);
            this.avoidCodecs.addAll(Arrays.asList(a.value()));
        }
        this.savedCodec = Codec.getDefault();
        int randomVal = random.nextInt(11);
        if ("default".equals(LuceneTestCase.TEST_CODEC)) {
            this.codec = this.savedCodec;
        } else if (!"random".equals(LuceneTestCase.TEST_POSTINGSFORMAT) || !"random".equals(LuceneTestCase.TEST_DOCVALUESFORMAT)) {
            final PostingsFormat format = "random".equals(LuceneTestCase.TEST_POSTINGSFORMAT) ? new AssertingPostingsFormat() : ("MockRandom".equals(LuceneTestCase.TEST_POSTINGSFORMAT) ? new MockRandomPostingsFormat(new Random(random.nextLong())) : PostingsFormat.forName((String)LuceneTestCase.TEST_POSTINGSFORMAT));
            final DocValuesFormat dvFormat = "random".equals(LuceneTestCase.TEST_DOCVALUESFORMAT) ? new AssertingDocValuesFormat() : DocValuesFormat.forName((String)LuceneTestCase.TEST_DOCVALUESFORMAT);
            this.codec = new AssertingCodec(){

                @Override
                public PostingsFormat getPostingsFormatForField(String field) {
                    return format;
                }

                @Override
                public DocValuesFormat getDocValuesFormatForField(String field) {
                    return dvFormat;
                }

                @Override
                public String toString() {
                    return super.toString() + ": " + format.toString() + ", " + dvFormat.toString();
                }
            };
        } else if ("SimpleText".equals(LuceneTestCase.TEST_CODEC) || "random".equals(LuceneTestCase.TEST_CODEC) && randomVal == 9 && LuceneTestCase.rarely(random) && !this.shouldAvoidCodec("SimpleText")) {
            this.codec = new SimpleTextCodec();
        } else if ("CheapBastard".equals(LuceneTestCase.TEST_CODEC) || "random".equals(LuceneTestCase.TEST_CODEC) && randomVal == 8 && !this.shouldAvoidCodec("CheapBastard") && !this.shouldAvoidCodec("Lucene41")) {
            this.codec = new CheapBastardCodec();
        } else if ("Asserting".equals(LuceneTestCase.TEST_CODEC) || "random".equals(LuceneTestCase.TEST_CODEC) && randomVal == 7 && !this.shouldAvoidCodec("Asserting")) {
            this.codec = new AssertingCodec();
        } else if ("Compressing".equals(LuceneTestCase.TEST_CODEC) || "random".equals(LuceneTestCase.TEST_CODEC) && randomVal == 6 && !this.shouldAvoidCodec("Compressing")) {
            this.codec = CompressingCodec.randomInstance(random);
        } else if ("Lucene99".equals(LuceneTestCase.TEST_CODEC) || "random".equals(LuceneTestCase.TEST_CODEC) && randomVal == 5 && !this.shouldAvoidCodec("Lucene99")) {
            this.codec = new Lucene99Codec((Lucene99Codec.Mode)RandomPicks.randomFrom((Random)random, (Object[])Lucene99Codec.Mode.values()));
        } else if (!"random".equals(LuceneTestCase.TEST_CODEC)) {
            this.codec = Codec.forName((String)LuceneTestCase.TEST_CODEC);
        } else if ("random".equals(LuceneTestCase.TEST_POSTINGSFORMAT)) {
            this.codec = new RandomCodec(random, this.avoidCodecs);
        } else assert (false);
        Codec.setDefault((Codec)this.codec);
        String testLocale = System.getProperty("tests.locale", "random");
        String testTimeZone = System.getProperty("tests.timezone", "random");
        this.savedLocale = Locale.getDefault();
        Locale randomLocale = LuceneTestCase.randomLocale(random);
        this.locale = testLocale.equals("random") ? randomLocale : LuceneTestCase.localeForLanguageTag(testLocale);
        Locale.setDefault(this.locale);
        this.savedTimeZone = TimeZone.getDefault();
        TimeZone randomTimeZone = LuceneTestCase.randomTimeZone(LuceneTestCase.random());
        this.timeZone = testTimeZone.equals("random") ? randomTimeZone : TimeZone.getTimeZone(testTimeZone);
        TimeZone.setDefault(this.timeZone);
        this.similarity = new AssertingSimilarity((Similarity)new RandomSimilarity(LuceneTestCase.random()));
        try {
            this.checkCodecRestrictions(this.codec);
        }
        catch (AssumptionViolatedException e) {
            System.err.println("NOTE: " + e.getMessage() + " Suppressed codecs: " + Arrays.toString(this.avoidCodecs.toArray()));
            throw e;
        }
        switch (LuceneTestCase.random().nextInt(3)) {
            case 0: {
                flushMode = LuceneTestCase.LiveIWCFlushMode.BY_RAM;
                break;
            }
            case 1: {
                flushMode = LuceneTestCase.LiveIWCFlushMode.BY_DOCS;
                break;
            }
            case 2: {
                flushMode = LuceneTestCase.LiveIWCFlushMode.EITHER;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        LuceneTestCase.setLiveIWCFlushMode(flushMode);
        this.initialized = true;
    }

    private void checkCodecRestrictions(Codec codec) {
        LuceneTestCase.assumeFalse("Class not allowed to use codec: " + codec.getName() + ".", this.shouldAvoidCodec(codec.getName()));
        if (codec instanceof RandomCodec && !this.avoidCodecs.isEmpty()) {
            for (String name : ((RandomCodec)codec).formatNames) {
                LuceneTestCase.assumeFalse("Class not allowed to use postings format: " + name + ".", this.shouldAvoidCodec(name));
            }
        }
        PostingsFormat pf = codec.postingsFormat();
        LuceneTestCase.assumeFalse("Class not allowed to use postings format: " + pf.getName() + ".", this.shouldAvoidCodec(pf.getName()));
        LuceneTestCase.assumeFalse("Class not allowed to use postings format: " + LuceneTestCase.TEST_POSTINGSFORMAT + ".", this.shouldAvoidCodec(LuceneTestCase.TEST_POSTINGSFORMAT));
    }

    @Override
    protected void after() throws Exception {
        Codec.setDefault((Codec)this.savedCodec);
        InfoStream.setDefault((InfoStream)this.savedInfoStream);
        if (this.savedLocale != null) {
            Locale.setDefault(this.savedLocale);
        }
        if (this.savedTimeZone != null) {
            TimeZone.setDefault(this.savedTimeZone);
        }
    }

    private boolean shouldAvoidCodec(String codec) {
        return !this.avoidCodecs.isEmpty() && this.avoidCodecs.contains(codec);
    }

    static class ThreadNameFixingPrintStreamInfoStream
    extends PrintStreamInfoStream {
        public ThreadNameFixingPrintStreamInfoStream(PrintStream out) {
            super(out);
        }

        public void message(String component, String message) {
            if ("TP".equals(component)) {
                return;
            }
            String name = Thread.currentThread().getName().startsWith("TEST-") ? "main" : Thread.currentThread().getName();
            this.stream.println(component + " " + this.messageID + " [" + this.getTimestamp() + "; " + name + "]: " + message);
        }
    }
}

