/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.FilterCodecReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.util.CloseableThreadLocal;

public class MergingCodecReader
extends FilterCodecReader {
    private final CloseableThreadLocal<StoredFieldsReader> fieldsReader = new CloseableThreadLocal<StoredFieldsReader>(){

        protected StoredFieldsReader initialValue() {
            return MergingCodecReader.this.in.getFieldsReader().getMergeInstance();
        }
    };
    private final CloseableThreadLocal<NormsProducer> normsReader = new CloseableThreadLocal<NormsProducer>(){

        protected NormsProducer initialValue() {
            NormsProducer norms = MergingCodecReader.this.in.getNormsReader();
            if (norms == null) {
                return null;
            }
            return norms.getMergeInstance();
        }
    };
    private final CloseableThreadLocal<DocValuesProducer> docValuesReader = new CloseableThreadLocal<DocValuesProducer>(){

        protected DocValuesProducer initialValue() {
            DocValuesProducer docValues = MergingCodecReader.this.in.getDocValuesReader();
            if (docValues == null) {
                return null;
            }
            return docValues.getMergeInstance();
        }
    };

    public MergingCodecReader(CodecReader in) {
        super(in);
    }

    public StoredFieldsReader getFieldsReader() {
        return (StoredFieldsReader)this.fieldsReader.get();
    }

    public NormsProducer getNormsReader() {
        return (NormsProducer)this.normsReader.get();
    }

    public DocValuesProducer getDocValuesReader() {
        return (DocValuesProducer)this.docValuesReader.get();
    }

    public IndexReader.CacheHelper getCoreCacheHelper() {
        return this.in.getCoreCacheHelper();
    }

    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.in.getReaderCacheHelper();
    }
}

