/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import com.carrotsearch.randomizedtesting.generators.RandomPicks;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.index.BaseDocValuesFormatTestCase;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.store.ByteBuffersDirectory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.TestUtil;
import org.apache.lucene.util.packed.PackedInts;

public abstract class BaseCompressingDocValuesFormatTestCase
extends BaseDocValuesFormatTestCase {
    static long dirSize(Directory d) throws IOException {
        long size = 0L;
        for (String file : d.listAll()) {
            size += d.fileLength(file);
        }
        return size;
    }

    public void testUniqueValuesCompression() throws IOException {
        try (ByteBuffersDirectory dir = new ByteBuffersDirectory();){
            IndexWriterConfig iwc = new IndexWriterConfig((Analyzer)new MockAnalyzer(BaseCompressingDocValuesFormatTestCase.random()));
            IndexWriter iwriter = new IndexWriter((Directory)dir, iwc);
            int uniqueValueCount = TestUtil.nextInt(BaseCompressingDocValuesFormatTestCase.random(), 1, 256);
            ArrayList<Long> values = new ArrayList<Long>();
            Document doc = new Document();
            NumericDocValuesField dvf = new NumericDocValuesField("dv", 0L);
            doc.add((IndexableField)dvf);
            for (int i = 0; i < 300; ++i) {
                long value;
                if (values.size() < uniqueValueCount) {
                    value = BaseCompressingDocValuesFormatTestCase.random().nextLong();
                    values.add(value);
                } else {
                    value = (Long)RandomPicks.randomFrom((Random)BaseCompressingDocValuesFormatTestCase.random(), values);
                }
                dvf.setLongValue(value);
                iwriter.addDocument((Iterable)doc);
            }
            iwriter.forceMerge(1);
            long size1 = BaseCompressingDocValuesFormatTestCase.dirSize((Directory)dir);
            for (int i = 0; i < 20; ++i) {
                dvf.setLongValue(((Long)RandomPicks.randomFrom((Random)BaseCompressingDocValuesFormatTestCase.random(), values)).longValue());
                iwriter.addDocument((Iterable)doc);
            }
            iwriter.forceMerge(1);
            long size2 = BaseCompressingDocValuesFormatTestCase.dirSize((Directory)dir);
            BaseCompressingDocValuesFormatTestCase.assertTrue((size2 < size1 + 160L ? 1 : 0) != 0);
        }
    }

    public void testDateCompression() throws IOException {
        try (ByteBuffersDirectory dir = new ByteBuffersDirectory();){
            IndexWriterConfig iwc = new IndexWriterConfig((Analyzer)new MockAnalyzer(BaseCompressingDocValuesFormatTestCase.random()));
            IndexWriter iwriter = new IndexWriter((Directory)dir, iwc);
            long base = 13L;
            long day = 86400000L;
            Document doc = new Document();
            NumericDocValuesField dvf = new NumericDocValuesField("dv", 0L);
            doc.add((IndexableField)dvf);
            for (int i = 0; i < 300; ++i) {
                dvf.setLongValue(13L + (long)BaseCompressingDocValuesFormatTestCase.random().nextInt(1000) * 86400000L);
                iwriter.addDocument((Iterable)doc);
            }
            iwriter.forceMerge(1);
            long size1 = BaseCompressingDocValuesFormatTestCase.dirSize((Directory)dir);
            for (int i = 0; i < 50; ++i) {
                dvf.setLongValue(13L + (long)BaseCompressingDocValuesFormatTestCase.random().nextInt(1000) * 86400000L);
                iwriter.addDocument((Iterable)doc);
            }
            iwriter.forceMerge(1);
            long size2 = BaseCompressingDocValuesFormatTestCase.dirSize((Directory)dir);
            BaseCompressingDocValuesFormatTestCase.assertTrue((size2 < size1 + (long)(PackedInts.bitsRequired((long)86400000L) * 50 / 8) ? 1 : 0) != 0);
        }
    }

    public void testSingleBigValueCompression() throws IOException {
        try (ByteBuffersDirectory dir = new ByteBuffersDirectory();){
            IndexWriterConfig iwc = new IndexWriterConfig((Analyzer)new MockAnalyzer(BaseCompressingDocValuesFormatTestCase.random()));
            IndexWriter iwriter = new IndexWriter((Directory)dir, iwc);
            Document doc = new Document();
            NumericDocValuesField dvf = new NumericDocValuesField("dv", 0L);
            doc.add((IndexableField)dvf);
            for (int i = 0; i < 20000; ++i) {
                dvf.setLongValue((long)(i & 0x3FF));
                iwriter.addDocument((Iterable)doc);
            }
            iwriter.forceMerge(1);
            long size1 = BaseCompressingDocValuesFormatTestCase.dirSize((Directory)dir);
            dvf.setLongValue(Long.MAX_VALUE);
            iwriter.addDocument((Iterable)doc);
            iwriter.forceMerge(1);
            long size2 = BaseCompressingDocValuesFormatTestCase.dirSize((Directory)dir);
            BaseCompressingDocValuesFormatTestCase.assertTrue((size2 < size1 + 132500L ? 1 : 0) != 0);
        }
    }
}

