/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.asserting;

import java.io.IOException;
import org.apache.lucene.codecs.NormsConsumer;
import org.apache.lucene.codecs.NormsFormat;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.codecs.asserting.AssertingCodec;
import org.apache.lucene.index.AssertingLeafReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.util.TestUtil;

public class AssertingNormsFormat
extends NormsFormat {
    private final NormsFormat in = TestUtil.getDefaultCodec().normsFormat();

    public NormsConsumer normsConsumer(SegmentWriteState state) throws IOException {
        NormsConsumer consumer = this.in.normsConsumer(state);
        assert (consumer != null);
        return new AssertingNormsConsumer(consumer, state.segmentInfo.maxDoc());
    }

    public NormsProducer normsProducer(SegmentReadState state) throws IOException {
        assert (state.fieldInfos.hasNorms());
        NormsProducer producer = this.in.normsProducer(state);
        assert (producer != null);
        return new AssertingNormsProducer(producer, state.segmentInfo.maxDoc(), false);
    }

    static class AssertingNormsProducer
    extends NormsProducer {
        private final NormsProducer in;
        private final int maxDoc;
        private final boolean merging;
        private final Thread creationThread;

        AssertingNormsProducer(NormsProducer in, int maxDoc, boolean merging) {
            this.in = in;
            this.maxDoc = maxDoc;
            this.merging = merging;
            this.creationThread = Thread.currentThread();
            assert (this.toString() != null);
        }

        public NumericDocValues getNorms(FieldInfo field) throws IOException {
            if (this.merging) {
                AssertingCodec.assertThread("NormsProducer", this.creationThread);
            }
            assert (field.hasNorms());
            NumericDocValues values = this.in.getNorms(field);
            assert (values != null);
            return new AssertingLeafReader.AssertingNumericDocValues(values, this.maxDoc);
        }

        public void close() throws IOException {
            this.in.close();
            this.in.close();
        }

        public void checkIntegrity() throws IOException {
            this.in.checkIntegrity();
        }

        public NormsProducer getMergeInstance() {
            return new AssertingNormsProducer(this.in.getMergeInstance(), this.maxDoc, true);
        }

        public String toString() {
            return ((Object)((Object)this)).getClass().getSimpleName() + "(" + this.in.toString() + ")";
        }
    }

    static class AssertingNormsConsumer
    extends NormsConsumer {
        private final NormsConsumer in;
        private final int maxDoc;

        AssertingNormsConsumer(NormsConsumer in, int maxDoc) {
            this.in = in;
            this.maxDoc = maxDoc;
        }

        public void addNormsField(FieldInfo field, NormsProducer valuesProducer) throws IOException {
            int docID;
            NumericDocValues values = valuesProducer.getNorms(field);
            int lastDocID = -1;
            while ((docID = values.nextDoc()) != Integer.MAX_VALUE) {
                assert (docID >= 0 && docID < this.maxDoc);
                assert (docID > lastDocID);
                lastDocID = docID;
                values.longValue();
            }
            this.in.addNormsField(field, valuesProducer);
        }

        public void close() throws IOException {
            this.in.close();
            this.in.close();
        }
    }
}

