/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.mockfile;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.lucene.mockfile.FilterFileSystemProvider;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.InfoStream;

public class VerboseFS
extends FilterFileSystemProvider {
    final InfoStream infoStream;
    final Path root;

    public VerboseFS(FileSystem delegate, InfoStream infoStream) {
        super("verbose://", delegate);
        this.infoStream = infoStream;
        this.root = this.getFileSystem(null).getPath(".", new String[0]).toAbsolutePath().normalize();
    }

    private void sop(String text, Throwable exception) throws IOException {
        if (exception == null) {
            if (this.infoStream.isEnabled("FS")) {
                this.infoStream.message("FS", text);
            }
        } else {
            if (this.infoStream.isEnabled("FS")) {
                this.infoStream.message("FS", text + " (FAILED: " + exception + ")");
            }
            IOUtils.reThrow((Throwable)exception);
        }
    }

    private String path(Path path) {
        path = this.root.relativize(path.toAbsolutePath().normalize());
        return path.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        Throwable exception = null;
        try {
            super.createDirectory(dir, attrs);
        }
        catch (Throwable t) {
            exception = t;
        }
        finally {
            this.sop("createDirectory: " + this.path(dir), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(Path path) throws IOException {
        Throwable exception = null;
        try {
            super.delete(path);
        }
        catch (Throwable t) {
            exception = t;
        }
        finally {
            this.sop("delete: " + this.path(path), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copy(Path source, Path target, CopyOption ... options) throws IOException {
        Throwable exception = null;
        try {
            super.copy(source, target, options);
        }
        catch (Throwable t) {
            exception = t;
        }
        finally {
            this.sop("copy" + Arrays.toString(options) + ": " + this.path(source) + " -> " + this.path(target), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void move(Path source, Path target, CopyOption ... options) throws IOException {
        Throwable exception = null;
        try {
            super.move(source, target, options);
        }
        catch (Throwable t) {
            exception = t;
        }
        finally {
            this.sop("move" + Arrays.toString(options) + ": " + this.path(source) + " -> " + this.path(target), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
        Throwable exception = null;
        try {
            super.setAttribute(path, attribute, value, options);
        }
        catch (Throwable t) {
            exception = t;
        }
        finally {
            this.sop("setAttribute[" + attribute + "=" + value + "]: " + this.path(path), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream newOutputStream(Path path, OpenOption ... options) throws IOException {
        Throwable exception = null;
        try {
            OutputStream outputStream = super.newOutputStream(path, options);
            return outputStream;
        }
        catch (Throwable t) {
            exception = t;
        }
        finally {
            this.sop("newOutputStream" + Arrays.toString(options) + ": " + this.path(path), exception);
        }
        throw new AssertionError();
    }

    private boolean containsDestructive(Set<? extends OpenOption> options) {
        return options.contains(StandardOpenOption.APPEND) || options.contains(StandardOpenOption.WRITE) || options.contains(StandardOpenOption.DELETE_ON_CLOSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileChannel newFileChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        Throwable exception = null;
        try {
            FileChannel fileChannel = super.newFileChannel(path, options, attrs);
            return fileChannel;
        }
        catch (Throwable t) {
            exception = t;
        }
        finally {
            if (this.containsDestructive(options)) {
                this.sop("newFileChannel" + options + ": " + this.path(path), exception);
            } else {
                IOUtils.reThrow((Throwable)exception);
            }
        }
        throw new AssertionError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsynchronousFileChannel newAsynchronousFileChannel(Path path, Set<? extends OpenOption> options, ExecutorService executor, FileAttribute<?> ... attrs) throws IOException {
        Throwable exception = null;
        try {
            AsynchronousFileChannel asynchronousFileChannel = super.newAsynchronousFileChannel(path, options, executor, attrs);
            return asynchronousFileChannel;
        }
        catch (Throwable t) {
            exception = t;
        }
        finally {
            if (this.containsDestructive(options)) {
                this.sop("newAsynchronousFileChannel" + options + ": " + this.path(path), exception);
            } else {
                IOUtils.reThrow((Throwable)exception);
            }
        }
        throw new AssertionError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        Throwable exception = null;
        try {
            SeekableByteChannel seekableByteChannel = super.newByteChannel(path, options, attrs);
            return seekableByteChannel;
        }
        catch (Throwable t) {
            exception = t;
        }
        finally {
            if (this.containsDestructive(options)) {
                this.sop("newByteChannel" + options + ": " + this.path(path), exception);
            } else {
                IOUtils.reThrow((Throwable)exception);
            }
        }
        throw new AssertionError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createSymbolicLink(Path link, Path target, FileAttribute<?> ... attrs) throws IOException {
        Throwable exception = null;
        try {
            super.createSymbolicLink(link, target, attrs);
        }
        catch (Throwable t) {
            exception = t;
        }
        finally {
            this.sop("createSymbolicLink: " + this.path(link) + " -> " + this.path(target), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createLink(Path link, Path existing) throws IOException {
        Throwable exception = null;
        try {
            super.createLink(link, existing);
        }
        catch (Throwable t) {
            exception = t;
        }
        finally {
            this.sop("createLink: " + this.path(link) + " -> " + this.path(existing), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteIfExists(Path path) throws IOException {
        Throwable exception = null;
        try {
            boolean bl = super.deleteIfExists(path);
            return bl;
        }
        catch (Throwable t) {
            exception = t;
        }
        finally {
            this.sop("deleteIfExists: " + this.path(path), exception);
        }
        throw new AssertionError();
    }
}

