/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SlowCompositeReaderWrapper;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanWeight;
import org.apache.lucene.search.spans.Spans;

public class MultiSpansWrapper {
    public static Spans wrap(IndexReader reader, SpanQuery spanQuery) throws IOException {
        return MultiSpansWrapper.wrap(reader, spanQuery, SpanWeight.Postings.POSITIONS);
    }

    public static Spans wrap(IndexReader reader, SpanQuery spanQuery, SpanWeight.Postings requiredPostings) throws IOException {
        LeafReader lr = SlowCompositeReaderWrapper.wrap((IndexReader)reader);
        LeafReaderContext lrContext = lr.getContext();
        IndexSearcher searcher = new IndexSearcher((IndexReader)lr);
        searcher.setQueryCache(null);
        SpanWeight w = spanQuery.createWeight(searcher, false);
        return w.getSpans(lrContext, requiredPostings);
    }
}

