/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Random;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.AssertingBulkScorer;
import org.apache.lucene.search.AssertingScorer;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

class AssertingWeight
extends Weight {
    final Random random;
    final Weight in;
    final boolean needsScores;

    AssertingWeight(Random random, Weight in, boolean needsScores) {
        super(in.getQuery());
        this.random = random;
        this.in = in;
        this.needsScores = needsScores;
    }

    public void extractTerms(Set<Term> terms) {
        this.in.extractTerms(terms);
    }

    public Explanation explain(LeafReaderContext context, int doc) throws IOException {
        return this.in.explain(context, doc);
    }

    public float getValueForNormalization() throws IOException {
        return this.in.getValueForNormalization();
    }

    public void normalize(float norm, float boost) {
        this.in.normalize(norm, boost);
    }

    public Scorer scorer(LeafReaderContext context) throws IOException {
        Scorer inScorer = this.in.scorer(context);
        assert (inScorer == null || inScorer.docID() == -1);
        return AssertingScorer.wrap(new Random(this.random.nextLong()), inScorer, this.needsScores);
    }

    public BulkScorer bulkScorer(LeafReaderContext context) throws IOException {
        BulkScorer inScorer = this.in.bulkScorer(context);
        if (inScorer == null) {
            return null;
        }
        return AssertingBulkScorer.wrap(new Random(this.random.nextLong()), inScorer, context.reader().maxDoc());
    }
}

