/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.cranky;

import java.io.IOException;
import java.util.Random;
import org.apache.lucene.codecs.TermVectorsFormat;
import org.apache.lucene.codecs.TermVectorsReader;
import org.apache.lucene.codecs.TermVectorsWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.BytesRef;

class CrankyTermVectorsFormat
extends TermVectorsFormat {
    final TermVectorsFormat delegate;
    final Random random;

    CrankyTermVectorsFormat(TermVectorsFormat delegate, Random random) {
        this.delegate = delegate;
        this.random = random;
    }

    public TermVectorsReader vectorsReader(Directory directory, SegmentInfo segmentInfo, FieldInfos fieldInfos, IOContext context) throws IOException {
        return this.delegate.vectorsReader(directory, segmentInfo, fieldInfos, context);
    }

    public TermVectorsWriter vectorsWriter(Directory directory, SegmentInfo segmentInfo, IOContext context) throws IOException {
        if (this.random.nextInt(100) == 0) {
            throw new IOException("Fake IOException from TermVectorsFormat.vectorsWriter()");
        }
        return new CrankyTermVectorsWriter(this.delegate.vectorsWriter(directory, segmentInfo, context), this.random);
    }

    static class CrankyTermVectorsWriter
    extends TermVectorsWriter {
        final TermVectorsWriter delegate;
        final Random random;

        CrankyTermVectorsWriter(TermVectorsWriter delegate, Random random) {
            this.delegate = delegate;
            this.random = random;
        }

        public int merge(MergeState mergeState) throws IOException {
            if (this.random.nextInt(100) == 0) {
                throw new IOException("Fake IOException from TermVectorsWriter.merge()");
            }
            return super.merge(mergeState);
        }

        public void finish(FieldInfos fis, int numDocs) throws IOException {
            if (this.random.nextInt(100) == 0) {
                throw new IOException("Fake IOException from TermVectorsWriter.finish()");
            }
            this.delegate.finish(fis, numDocs);
        }

        public void close() throws IOException {
            this.delegate.close();
            if (this.random.nextInt(100) == 0) {
                throw new IOException("Fake IOException from TermVectorsWriter.close()");
            }
        }

        public void startDocument(int numVectorFields) throws IOException {
            if (this.random.nextInt(10000) == 0) {
                throw new IOException("Fake IOException from TermVectorsWriter.startDocument()");
            }
            this.delegate.startDocument(numVectorFields);
        }

        public void finishDocument() throws IOException {
            if (this.random.nextInt(10000) == 0) {
                throw new IOException("Fake IOException from TermVectorsWriter.finishDocument()");
            }
            this.delegate.finishDocument();
        }

        public void startField(FieldInfo info, int numTerms, boolean positions, boolean offsets, boolean payloads) throws IOException {
            if (this.random.nextInt(10000) == 0) {
                throw new IOException("Fake IOException from TermVectorsWriter.startField()");
            }
            this.delegate.startField(info, numTerms, positions, offsets, payloads);
        }

        public void finishField() throws IOException {
            if (this.random.nextInt(10000) == 0) {
                throw new IOException("Fake IOException from TermVectorsWriter.finishField()");
            }
            this.delegate.finishField();
        }

        public void startTerm(BytesRef term, int freq) throws IOException {
            if (this.random.nextInt(10000) == 0) {
                throw new IOException("Fake IOException from TermVectorsWriter.startTerm()");
            }
            this.delegate.startTerm(term, freq);
        }

        public void finishTerm() throws IOException {
            if (this.random.nextInt(10000) == 0) {
                throw new IOException("Fake IOException from TermVectorsWriter.finishTerm()");
            }
            this.delegate.finishTerm();
        }

        public void addPosition(int position, int startOffset, int endOffset, BytesRef payload) throws IOException {
            if (this.random.nextInt(10000) == 0) {
                throw new IOException("Fake IOException from TermVectorsWriter.addPosition()");
            }
            this.delegate.addPosition(position, startOffset, endOffset, payload);
        }

        public void addProx(int numProx, DataInput positions, DataInput offsets) throws IOException {
            if (this.random.nextInt(10000) == 0) {
                throw new IOException("Fake IOException from TermVectorsWriter.addProx()");
            }
            super.addProx(numProx, positions, offsets);
        }
    }
}

