/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.asserting;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.index.AssertingLeafReader;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.RandomAccessOrds;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.LongBitSet;
import org.apache.lucene.util.TestUtil;

public class AssertingDocValuesFormat
extends DocValuesFormat {
    private final DocValuesFormat in = TestUtil.getDefaultDocValuesFormat();

    public AssertingDocValuesFormat() {
        super("Asserting");
    }

    public DocValuesConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        DocValuesConsumer consumer = this.in.fieldsConsumer(state);
        assert (consumer != null);
        return new AssertingDocValuesConsumer(consumer, state.segmentInfo.maxDoc());
    }

    public DocValuesProducer fieldsProducer(SegmentReadState state) throws IOException {
        assert (state.fieldInfos.hasDocValues());
        DocValuesProducer producer = this.in.fieldsProducer(state);
        assert (producer != null);
        return new AssertingDocValuesProducer(producer, state.segmentInfo.maxDoc());
    }

    static class AssertingDocValuesProducer
    extends DocValuesProducer {
        private final DocValuesProducer in;
        private final int maxDoc;

        AssertingDocValuesProducer(DocValuesProducer in, int maxDoc) {
            this.in = in;
            this.maxDoc = maxDoc;
            assert (this.toString() != null);
            assert (this.ramBytesUsed() >= 0L);
            assert (this.getChildResources() != null);
        }

        public NumericDocValues getNumeric(FieldInfo field) throws IOException {
            assert (field.getDocValuesType() == DocValuesType.NUMERIC);
            NumericDocValues values = this.in.getNumeric(field);
            assert (values != null);
            return new AssertingLeafReader.AssertingNumericDocValues(values, this.maxDoc);
        }

        public BinaryDocValues getBinary(FieldInfo field) throws IOException {
            assert (field.getDocValuesType() == DocValuesType.BINARY);
            BinaryDocValues values = this.in.getBinary(field);
            assert (values != null);
            return new AssertingLeafReader.AssertingBinaryDocValues(values, this.maxDoc);
        }

        public SortedDocValues getSorted(FieldInfo field) throws IOException {
            assert (field.getDocValuesType() == DocValuesType.SORTED);
            SortedDocValues values = this.in.getSorted(field);
            assert (values != null);
            return new AssertingLeafReader.AssertingSortedDocValues(values, this.maxDoc);
        }

        public SortedNumericDocValues getSortedNumeric(FieldInfo field) throws IOException {
            assert (field.getDocValuesType() == DocValuesType.SORTED_NUMERIC);
            SortedNumericDocValues values = this.in.getSortedNumeric(field);
            assert (values != null);
            return new AssertingLeafReader.AssertingSortedNumericDocValues(values, this.maxDoc);
        }

        public SortedSetDocValues getSortedSet(FieldInfo field) throws IOException {
            assert (field.getDocValuesType() == DocValuesType.SORTED_SET);
            SortedSetDocValues values = this.in.getSortedSet(field);
            assert (values != null);
            if (values instanceof RandomAccessOrds) {
                return new AssertingLeafReader.AssertingRandomAccessOrds((RandomAccessOrds)values, this.maxDoc);
            }
            return new AssertingLeafReader.AssertingSortedSetDocValues(values, this.maxDoc);
        }

        public Bits getDocsWithField(FieldInfo field) throws IOException {
            assert (field.getDocValuesType() != DocValuesType.NONE);
            Bits bits = this.in.getDocsWithField(field);
            assert (bits != null);
            assert (bits.length() == this.maxDoc);
            return new AssertingLeafReader.AssertingBits(bits);
        }

        public void close() throws IOException {
            this.in.close();
            this.in.close();
        }

        public long ramBytesUsed() {
            long v = this.in.ramBytesUsed();
            assert (v >= 0L);
            return v;
        }

        public Collection<Accountable> getChildResources() {
            Collection res = this.in.getChildResources();
            TestUtil.checkReadOnly(res);
            return res;
        }

        public void checkIntegrity() throws IOException {
            this.in.checkIntegrity();
        }

        public DocValuesProducer getMergeInstance() throws IOException {
            return new AssertingDocValuesProducer(this.in.getMergeInstance(), this.maxDoc);
        }

        public String toString() {
            return ((Object)((Object)this)).getClass().getSimpleName() + "(" + this.in.toString() + ")";
        }
    }

    static class AssertingDocValuesConsumer
    extends DocValuesConsumer {
        private final DocValuesConsumer in;
        private final int maxDoc;

        AssertingDocValuesConsumer(DocValuesConsumer in, int maxDoc) {
            this.in = in;
            this.maxDoc = maxDoc;
        }

        public void addNumericField(FieldInfo field, Iterable<Number> values) throws IOException {
            int count = 0;
            for (Number v : values) {
                ++count;
            }
            assert (count == this.maxDoc);
            TestUtil.checkIterator(values.iterator(), this.maxDoc, true);
            this.in.addNumericField(field, values);
        }

        public void addBinaryField(FieldInfo field, Iterable<BytesRef> values) throws IOException {
            int count = 0;
            for (BytesRef b : values) {
                assert (b == null || b.isValid());
                ++count;
            }
            assert (count == this.maxDoc);
            TestUtil.checkIterator(values.iterator(), this.maxDoc, true);
            this.in.addBinaryField(field, values);
        }

        public void addSortedField(FieldInfo field, Iterable<BytesRef> values, Iterable<Number> docToOrd) throws IOException {
            int valueCount = 0;
            BytesRef lastValue = null;
            for (BytesRef b : values) {
                assert (b != null);
                assert (b.isValid());
                if (valueCount > 0) assert (b.compareTo(lastValue) > 0);
                lastValue = BytesRef.deepCopyOf((BytesRef)b);
                ++valueCount;
            }
            assert (valueCount <= this.maxDoc);
            FixedBitSet seenOrds = new FixedBitSet(valueCount);
            int count = 0;
            for (Number v : docToOrd) {
                assert (v != null);
                int ord = v.intValue();
                assert (ord >= -1 && ord < valueCount);
                if (ord >= 0) {
                    seenOrds.set(ord);
                }
                ++count;
            }
            assert (count == this.maxDoc);
            assert (seenOrds.cardinality() == valueCount);
            TestUtil.checkIterator(values.iterator(), valueCount, false);
            TestUtil.checkIterator(docToOrd.iterator(), this.maxDoc, false);
            this.in.addSortedField(field, values, docToOrd);
        }

        public void addSortedNumericField(FieldInfo field, Iterable<Number> docToValueCount, Iterable<Number> values) throws IOException {
            long valueCount = 0L;
            Iterator<Number> valueIterator = values.iterator();
            for (Number count : docToValueCount) {
                assert (count != null);
                assert (count.intValue() >= 0);
                valueCount += (long)count.intValue();
                long previous = Long.MIN_VALUE;
                for (int i = 0; i < count.intValue(); ++i) {
                    assert (valueIterator.hasNext());
                    Number next = valueIterator.next();
                    assert (next != null);
                    long nextValue = next.longValue();
                    assert (nextValue >= previous);
                    previous = nextValue;
                }
            }
            assert (!valueIterator.hasNext());
            TestUtil.checkIterator(docToValueCount.iterator(), this.maxDoc, false);
            TestUtil.checkIterator(values.iterator(), valueCount, false);
            this.in.addSortedNumericField(field, docToValueCount, values);
        }

        public void addSortedSetField(FieldInfo field, Iterable<BytesRef> values, Iterable<Number> docToOrdCount, Iterable<Number> ords) throws IOException {
            long valueCount = 0L;
            BytesRef lastValue = null;
            for (BytesRef b : values) {
                assert (b != null);
                assert (b.isValid());
                if (valueCount > 0L) assert (b.compareTo(lastValue) > 0);
                lastValue = BytesRef.deepCopyOf((BytesRef)b);
                ++valueCount;
            }
            int docCount = 0;
            long ordCount = 0L;
            LongBitSet seenOrds = new LongBitSet(valueCount);
            Iterator<Number> ordIterator = ords.iterator();
            for (Number v : docToOrdCount) {
                assert (v != null);
                int count = v.intValue();
                assert (count >= 0);
                ++docCount;
                ordCount += (long)count;
                long lastOrd = -1L;
                for (int i = 0; i < count; ++i) {
                    Number o = ordIterator.next();
                    assert (o != null);
                    long ord = o.longValue();
                    assert (ord >= 0L && ord < valueCount);
                    assert (ord > lastOrd) : "ord=" + ord + ",lastOrd=" + lastOrd;
                    seenOrds.set(ord);
                    lastOrd = ord;
                }
            }
            assert (!ordIterator.hasNext());
            assert (docCount == this.maxDoc);
            assert (seenOrds.cardinality() == valueCount);
            TestUtil.checkIterator(values.iterator(), valueCount, false);
            TestUtil.checkIterator(docToOrdCount.iterator(), this.maxDoc, false);
            TestUtil.checkIterator(ords.iterator(), ordCount, false);
            this.in.addSortedSetField(field, values, docToOrdCount, ords);
        }

        public void close() throws IOException {
            this.in.close();
            this.in.close();
        }
    }
}

