/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Random;
import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.BaseIndexFileFormatTestCase;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.RandomIndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.store.BaseDirectoryWrapper;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.TestUtil;

public abstract class BaseNormsFormatTestCase
extends BaseIndexFileFormatTestCase {
    public void testByteRange() throws Exception {
        int iterations = BaseNormsFormatTestCase.atLeast(1);
        final Random r = BaseNormsFormatTestCase.random();
        for (int i = 0; i < iterations; ++i) {
            this.doTestNormsVersusStoredFields(new LongProducer(){

                @Override
                long next() {
                    return TestUtil.nextLong(r, -128L, 127L);
                }
            });
        }
    }

    public void testShortRange() throws Exception {
        int iterations = BaseNormsFormatTestCase.atLeast(1);
        final Random r = BaseNormsFormatTestCase.random();
        for (int i = 0; i < iterations; ++i) {
            this.doTestNormsVersusStoredFields(new LongProducer(){

                @Override
                long next() {
                    return TestUtil.nextLong(r, -32768L, 32767L);
                }
            });
        }
    }

    public void testLongRange() throws Exception {
        int iterations = BaseNormsFormatTestCase.atLeast(1);
        final Random r = BaseNormsFormatTestCase.random();
        for (int i = 0; i < iterations; ++i) {
            this.doTestNormsVersusStoredFields(new LongProducer(){

                @Override
                long next() {
                    return TestUtil.nextLong(r, Long.MIN_VALUE, Long.MAX_VALUE);
                }
            });
        }
    }

    public void testFullLongRange() throws Exception {
        int iterations = BaseNormsFormatTestCase.atLeast(1);
        final Random r = BaseNormsFormatTestCase.random();
        for (int i = 0; i < iterations; ++i) {
            this.doTestNormsVersusStoredFields(new LongProducer(){

                @Override
                long next() {
                    int thingToDo = r.nextInt(3);
                    switch (thingToDo) {
                        case 0: {
                            return Long.MIN_VALUE;
                        }
                        case 1: {
                            return Long.MAX_VALUE;
                        }
                    }
                    return TestUtil.nextLong(r, Long.MIN_VALUE, Long.MAX_VALUE);
                }
            });
        }
    }

    public void testFewValues() throws Exception {
        int iterations = BaseNormsFormatTestCase.atLeast(1);
        final Random r = BaseNormsFormatTestCase.random();
        for (int i = 0; i < iterations; ++i) {
            this.doTestNormsVersusStoredFields(new LongProducer(){

                @Override
                long next() {
                    return r.nextBoolean() ? 20L : 3L;
                }
            });
        }
    }

    public void testFewLargeValues() throws Exception {
        int iterations = BaseNormsFormatTestCase.atLeast(1);
        final Random r = BaseNormsFormatTestCase.random();
        for (int i = 0; i < iterations; ++i) {
            this.doTestNormsVersusStoredFields(new LongProducer(){

                @Override
                long next() {
                    return r.nextBoolean() ? 1000000L : -5000L;
                }
            });
        }
    }

    public void testAllZeros() throws Exception {
        int iterations = BaseNormsFormatTestCase.atLeast(1);
        Random r = BaseNormsFormatTestCase.random();
        for (int i = 0; i < iterations; ++i) {
            this.doTestNormsVersusStoredFields(new LongProducer(){

                @Override
                long next() {
                    return 0L;
                }
            });
        }
    }

    private void doTestNormsVersusStoredFields(LongProducer longs) throws Exception {
        long storedValue;
        int i;
        NumericDocValues docValues;
        AtomicReader r;
        int numDocs = BaseNormsFormatTestCase.atLeast(500);
        long[] norms = new long[numDocs];
        for (int i2 = 0; i2 < numDocs; ++i2) {
            norms[i2] = longs.next();
        }
        BaseDirectoryWrapper dir = BaseNormsFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BaseNormsFormatTestCase.random(), MockTokenizer.KEYWORD, false);
        IndexWriterConfig conf = BaseNormsFormatTestCase.newIndexWriterConfig(TEST_VERSION_CURRENT, analyzer);
        conf.setSimilarity((Similarity)new CannedNormSimilarity(norms));
        RandomIndexWriter writer = new RandomIndexWriter(BaseNormsFormatTestCase.random(), (Directory)dir, conf);
        Document doc = new Document();
        StringField idField = new StringField("id", "", Field.Store.NO);
        Field storedField = BaseNormsFormatTestCase.newTextField("stored", "", Field.Store.YES);
        doc.add((IndexableField)idField);
        doc.add((IndexableField)storedField);
        for (int i3 = 0; i3 < numDocs; ++i3) {
            idField.setStringValue(Integer.toString(i3));
            long value = norms[i3];
            storedField.setStringValue(Long.toString(value));
            writer.addDocument(doc);
            if (BaseNormsFormatTestCase.random().nextInt(31) != 0) continue;
            writer.commit();
        }
        int numDeletions = BaseNormsFormatTestCase.random().nextInt(numDocs / 10);
        for (int i4 = 0; i4 < numDeletions; ++i4) {
            int id = BaseNormsFormatTestCase.random().nextInt(numDocs);
            writer.deleteDocuments(new Term("id", Integer.toString(id)));
        }
        writer.commit();
        DirectoryReader ir = DirectoryReader.open((Directory)dir);
        for (AtomicReaderContext context : ir.leaves()) {
            r = context.reader();
            docValues = r.getNormValues("stored");
            for (i = 0; i < r.maxDoc(); ++i) {
                storedValue = Long.parseLong(r.document(i).get("stored"));
                BaseNormsFormatTestCase.assertEquals((long)storedValue, (long)docValues.get(i));
            }
        }
        ir.close();
        writer.forceMerge(1);
        ir = DirectoryReader.open((Directory)dir);
        for (AtomicReaderContext context : ir.leaves()) {
            r = context.reader();
            docValues = r.getNormValues("stored");
            for (i = 0; i < r.maxDoc(); ++i) {
                storedValue = Long.parseLong(r.document(i).get("stored"));
                BaseNormsFormatTestCase.assertEquals((long)storedValue, (long)docValues.get(i));
            }
        }
        writer.close();
        ir.close();
        dir.close();
    }

    @Override
    protected void addRandomFields(Document doc) {
        doc.add((IndexableField)new TextField("foobar", TestUtil.randomSimpleString(BaseNormsFormatTestCase.random()), Field.Store.NO));
    }

    @Override
    public void testMergeStability() throws Exception {
        BaseNormsFormatTestCase.assumeTrue("The MockRandom PF randomizes content on the fly, so we can't check it", false);
    }

    static class CannedNormSimilarity
    extends Similarity {
        final long[] norms;
        int index = 0;

        CannedNormSimilarity(long[] norms) {
            this.norms = norms;
        }

        public long computeNorm(FieldInvertState state) {
            return this.norms[this.index++];
        }

        public Similarity.SimWeight computeWeight(float queryBoost, CollectionStatistics collectionStats, TermStatistics ... termStats) {
            throw new UnsupportedOperationException();
        }

        public Similarity.SimScorer simScorer(Similarity.SimWeight weight, AtomicReaderContext context) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    static abstract class LongProducer {
        LongProducer() {
        }

        abstract long next();
    }
}

