/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.apache.lucene.util.TestRuleMarkFailure;
import org.apache.lucene.util.TestUtil;

final class RemoveUponClose
implements Closeable {
    private final File file;
    private final TestRuleMarkFailure failureMarker;
    private final String creationStack;

    public RemoveUponClose(File file, TestRuleMarkFailure failureMarker) {
        this.file = file;
        this.failureMarker = failureMarker;
        StringBuilder b = new StringBuilder();
        for (StackTraceElement e : Thread.currentThread().getStackTrace()) {
            b.append('\t').append(e.toString()).append('\n');
        }
        this.creationStack = b.toString();
    }

    @Override
    public void close() throws IOException {
        if (this.failureMarker.wasSuccessful() && this.file.exists()) {
            try {
                TestUtil.rm(this.file);
            }
            catch (IOException e) {
                throw new IOException("Could not remove temporary location '" + this.file.getAbsolutePath() + "', created at stack trace:\n" + this.creationStack, e);
            }
        }
    }
}

