/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.asserting;

import java.io.IOException;
import org.apache.lucene.codecs.StoredFieldsFormat;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.codecs.StoredFieldsWriter;
import org.apache.lucene.codecs.lucene41.Lucene41StoredFieldsFormat;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;

public class AssertingStoredFieldsFormat
extends StoredFieldsFormat {
    private final StoredFieldsFormat in = new Lucene41StoredFieldsFormat();

    public StoredFieldsReader fieldsReader(Directory directory, SegmentInfo si, FieldInfos fn, IOContext context) throws IOException {
        return new AssertingStoredFieldsReader(this.in.fieldsReader(directory, si, fn, context), si.getDocCount());
    }

    public StoredFieldsWriter fieldsWriter(Directory directory, SegmentInfo si, IOContext context) throws IOException {
        return new AssertingStoredFieldsWriter(this.in.fieldsWriter(directory, si, context));
    }

    static class AssertingStoredFieldsWriter
    extends StoredFieldsWriter {
        private final StoredFieldsWriter in;
        private int numWritten;
        private Status docStatus;

        AssertingStoredFieldsWriter(StoredFieldsWriter in) {
            this.in = in;
            this.docStatus = Status.UNDEFINED;
        }

        public void startDocument() throws IOException {
            assert (this.docStatus != Status.STARTED);
            this.in.startDocument();
            ++this.numWritten;
            this.docStatus = Status.STARTED;
        }

        public void finishDocument() throws IOException {
            assert (this.docStatus == Status.STARTED);
            this.in.finishDocument();
            this.docStatus = Status.FINISHED;
        }

        public void writeField(FieldInfo info, IndexableField field) throws IOException {
            assert (this.docStatus == Status.STARTED);
            this.in.writeField(info, field);
        }

        public void abort() {
            this.in.abort();
        }

        public void finish(FieldInfos fis, int numDocs) throws IOException {
            assert (this.docStatus == (numDocs > 0 ? Status.FINISHED : Status.UNDEFINED));
            this.in.finish(fis, numDocs);
            assert (numDocs == this.numWritten);
        }

        public void close() throws IOException {
            this.in.close();
        }
    }

    static enum Status {
        UNDEFINED,
        STARTED,
        FINISHED;

    }

    static class AssertingStoredFieldsReader
    extends StoredFieldsReader {
        private final StoredFieldsReader in;
        private final int maxDoc;

        AssertingStoredFieldsReader(StoredFieldsReader in, int maxDoc) {
            this.in = in;
            this.maxDoc = maxDoc;
        }

        public void close() throws IOException {
            this.in.close();
        }

        public void visitDocument(int n, StoredFieldVisitor visitor) throws IOException {
            assert (n >= 0 && n < this.maxDoc);
            this.in.visitDocument(n, visitor);
        }

        public StoredFieldsReader clone() {
            return new AssertingStoredFieldsReader(this.in.clone(), this.maxDoc);
        }

        public long ramBytesUsed() {
            return this.in.ramBytesUsed();
        }

        public void checkIntegrity() throws IOException {
            this.in.checkIntegrity();
        }
    }
}

