/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.zip.ZipFile;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.junit.Assert;

public class VocabularyAssert {
    public static void assertVocabulary(Analyzer a, InputStream voc, InputStream out) throws IOException {
        BufferedReader vocReader = new BufferedReader(new InputStreamReader(voc, StandardCharsets.UTF_8));
        BufferedReader outputReader = new BufferedReader(new InputStreamReader(out, StandardCharsets.UTF_8));
        String inputWord = null;
        while ((inputWord = vocReader.readLine()) != null) {
            String expectedWord = outputReader.readLine();
            Assert.assertNotNull((Object)expectedWord);
            BaseTokenStreamTestCase.checkOneTerm(a, inputWord, expectedWord);
        }
    }

    public static void assertVocabulary(Analyzer a, InputStream vocOut) throws IOException {
        BufferedReader vocReader = new BufferedReader(new InputStreamReader(vocOut, StandardCharsets.UTF_8));
        String inputLine = null;
        while ((inputLine = vocReader.readLine()) != null) {
            if (inputLine.startsWith("#") || inputLine.trim().length() == 0) continue;
            String[] words = inputLine.split("\t");
            BaseTokenStreamTestCase.checkOneTerm(a, words[0], words[1]);
        }
    }

    public static void assertVocabulary(Analyzer a, File zipFile, String voc, String out) throws IOException {
        ZipFile zip = new ZipFile(zipFile);
        InputStream v = zip.getInputStream(zip.getEntry(voc));
        InputStream o = zip.getInputStream(zip.getEntry(out));
        VocabularyAssert.assertVocabulary(a, v, o);
        v.close();
        o.close();
        zip.close();
    }

    public static void assertVocabulary(Analyzer a, File zipFile, String vocOut) throws IOException {
        ZipFile zip = new ZipFile(zipFile);
        InputStream vo = zip.getInputStream(zip.getEntry(vocOut));
        VocabularyAssert.assertVocabulary(a, vo);
        vo.close();
        zip.close();
    }
}

