/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.AssertingAtomicReader;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexWriter;

public class AssertingDirectoryReader
extends DirectoryReader {
    protected DirectoryReader in;

    public AssertingDirectoryReader(DirectoryReader in) {
        super(in.directory(), AssertingDirectoryReader.wrap(in.getSequentialSubReaders()));
        this.in = in;
    }

    private static AtomicReader[] wrap(List<? extends AtomicReader> readers) {
        AtomicReader[] wrapped = new AtomicReader[readers.size()];
        for (int i = 0; i < readers.size(); ++i) {
            wrapped[i] = new AssertingAtomicReader(readers.get(i));
        }
        return wrapped;
    }

    protected DirectoryReader doOpenIfChanged() throws IOException {
        DirectoryReader d = this.in.doOpenIfChanged();
        return d == null ? null : new AssertingDirectoryReader(d);
    }

    protected DirectoryReader doOpenIfChanged(IndexCommit commit) throws IOException {
        DirectoryReader d = this.in.doOpenIfChanged(commit);
        return d == null ? null : new AssertingDirectoryReader(d);
    }

    protected DirectoryReader doOpenIfChanged(IndexWriter writer, boolean applyAllDeletes) throws IOException {
        DirectoryReader d = this.in.doOpenIfChanged(writer, applyAllDeletes);
        return d == null ? null : new AssertingDirectoryReader(d);
    }

    public long getVersion() {
        return this.in.getVersion();
    }

    public boolean isCurrent() throws IOException {
        return this.in.isCurrent();
    }

    public IndexCommit getIndexCommit() throws IOException {
        return this.in.getIndexCommit();
    }

    protected void doClose() throws IOException {
        this.in.doClose();
    }

    public Object getCoreCacheKey() {
        return this.in.getCoreCacheKey();
    }

    public Object getCombinedCoreAndDeletesKey() {
        return this.in.getCombinedCoreAndDeletesKey();
    }
}

