/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial3d;

import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.search.Query;
import org.apache.lucene.spatial3d.Geo3DUtil;
import org.apache.lucene.spatial3d.PointInGeo3DShapeQuery;
import org.apache.lucene.spatial3d.geom.GeoPoint;
import org.apache.lucene.spatial3d.geom.GeoShape;
import org.apache.lucene.spatial3d.geom.PlanetModel;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;

public final class Geo3DPoint
extends Field {
    public static final FieldType TYPE = new FieldType();

    public Geo3DPoint(String name, double lat, double lon) {
        super(name, TYPE);
        GeoPoint point = new GeoPoint(PlanetModel.WGS84, lat, lon);
        this.fillFieldsData(point.x, point.y, point.z);
    }

    public Geo3DPoint(String name, double x, double y, double z) {
        super(name, TYPE);
        this.fillFieldsData(x, y, z);
    }

    private void fillFieldsData(double x, double y, double z) {
        byte[] bytes = new byte[12];
        Geo3DPoint.encodeDimension(x, bytes, 0);
        Geo3DPoint.encodeDimension(y, bytes, 4);
        Geo3DPoint.encodeDimension(z, bytes, 8);
        this.fieldsData = new BytesRef(bytes);
    }

    public static void encodeDimension(double value, byte[] bytes, int offset) {
        NumericUtils.intToSortableBytes((int)Geo3DUtil.encodeValue(PlanetModel.WGS84.getMaximumMagnitude(), value), (byte[])bytes, (int)offset);
    }

    public static double decodeDimension(byte[] value, int offset) {
        return Geo3DUtil.decodeValueCenter(PlanetModel.WGS84.getMaximumMagnitude(), NumericUtils.sortableBytesToInt((byte[])value, (int)offset));
    }

    public static Query newShapeQuery(String field, GeoShape shape) {
        return new PointInGeo3DShapeQuery(field, shape);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(((Object)((Object)this)).getClass().getSimpleName());
        result.append(" <");
        result.append(this.name);
        result.append(':');
        BytesRef bytes = (BytesRef)this.fieldsData;
        result.append(" x=" + Geo3DPoint.decodeDimension(bytes.bytes, bytes.offset));
        result.append(" y=" + Geo3DPoint.decodeDimension(bytes.bytes, bytes.offset + 4));
        result.append(" z=" + Geo3DPoint.decodeDimension(bytes.bytes, bytes.offset + 8));
        result.append('>');
        return result.toString();
    }

    static {
        TYPE.setDimensions(3, 4);
        TYPE.freeze();
    }
}

