/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.geopoint.search;

import java.util.Arrays;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Query;
import org.apache.lucene.spatial.geopoint.document.GeoPointField;
import org.apache.lucene.spatial.geopoint.search.GeoPointInBBoxQuery;
import org.apache.lucene.spatial.geopoint.search.GeoPointInPolygonQueryImpl;
import org.apache.lucene.spatial.util.GeoRect;
import org.apache.lucene.spatial.util.GeoUtils;

public final class GeoPointInPolygonQuery
extends GeoPointInBBoxQuery {
    protected final double[] polyLats;
    protected final double[] polyLons;

    public GeoPointInPolygonQuery(String field, double[] polyLats, double[] polyLons) {
        this(field, GeoPointField.TermEncoding.PREFIX, GeoUtils.polyToBBox(polyLats, polyLons), polyLats, polyLons);
    }

    public GeoPointInPolygonQuery(String field, GeoPointField.TermEncoding termEncoding, double[] polyLats, double[] polyLons) {
        this(field, termEncoding, GeoUtils.polyToBBox(polyLats, polyLons), polyLats, polyLons);
    }

    private GeoPointInPolygonQuery(String field, GeoPointField.TermEncoding termEncoding, GeoRect bbox, double[] polyLats, double[] polyLons) {
        super(field, termEncoding, bbox.minLat, bbox.maxLat, bbox.minLon, bbox.maxLon);
        if (polyLats.length != polyLons.length) {
            throw new IllegalArgumentException("polyLats and polyLons must be equal length");
        }
        if (polyLats.length < 4) {
            throw new IllegalArgumentException("at least 4 polygon points required");
        }
        if (polyLats[0] != polyLats[polyLats.length - 1]) {
            throw new IllegalArgumentException("first and last points of the polygon must be the same (it must close itself): polyLats[0]=" + polyLats[0] + " polyLats[" + (polyLats.length - 1) + "]=" + polyLats[polyLats.length - 1]);
        }
        if (polyLons[0] != polyLons[polyLons.length - 1]) {
            throw new IllegalArgumentException("first and last points of the polygon must be the same (it must close itself): polyLons[0]=" + polyLons[0] + " polyLons[" + (polyLons.length - 1) + "]=" + polyLons[polyLons.length - 1]);
        }
        this.polyLons = polyLons;
        this.polyLats = polyLats;
    }

    @Override
    public Query rewrite(IndexReader reader) {
        return new GeoPointInPolygonQueryImpl(this.field, this.termEncoding, this, this.minLat, this.maxLat, this.minLon, this.maxLon);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GeoPointInPolygonQuery that = (GeoPointInPolygonQuery)((Object)o);
        if (!Arrays.equals(this.polyLats, that.polyLats)) {
            return false;
        }
        return Arrays.equals(this.polyLons, that.polyLons);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.polyLats != null ? Arrays.hashCode(this.polyLats) : 0);
        result = 31 * result + (this.polyLons != null ? Arrays.hashCode(this.polyLons) : 0);
        return result;
    }

    @Override
    public String toString(String field) {
        assert (this.polyLats.length == this.polyLons.length);
        StringBuilder sb = new StringBuilder();
        sb.append(((Object)((Object)this)).getClass().getSimpleName());
        sb.append(':');
        if (!this.getField().equals(field)) {
            sb.append(" field=");
            sb.append(this.getField());
            sb.append(':');
        }
        sb.append(" Points: ");
        for (int i = 0; i < this.polyLats.length; ++i) {
            sb.append("[").append(this.polyLats[i]).append(", ").append(this.polyLons[i]).append("] ");
        }
        return sb.toString();
    }

    public double[] getLons() {
        return this.polyLons;
    }

    public double[] getLats() {
        return this.polyLats;
    }
}

