/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.prefix;

import com.spatial4j.core.shape.Shape;
import org.apache.lucene.search.Filter;
import org.apache.lucene.spatial.prefix.PrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.RecursivePrefixTreeFilter;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.lucene.spatial.query.SpatialOperation;
import org.apache.lucene.spatial.query.UnsupportedSpatialOperation;

public class RecursivePrefixTreeStrategy
extends PrefixTreeStrategy {
    private int prefixGridScanLevel;

    public RecursivePrefixTreeStrategy(SpatialPrefixTree grid, String fieldName) {
        super(grid, fieldName);
        this.prefixGridScanLevel = grid.getMaxLevels() - 4;
    }

    public void setPrefixGridScanLevel(int prefixGridScanLevel) {
        this.prefixGridScanLevel = prefixGridScanLevel;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(prefixGridScanLevel:" + this.prefixGridScanLevel + ",SPG:(" + this.grid + "))";
    }

    @Override
    public Filter makeFilter(SpatialArgs args) {
        SpatialOperation op = args.getOperation();
        if (op != SpatialOperation.Intersects) {
            throw new UnsupportedSpatialOperation(op);
        }
        Shape shape = args.getShape();
        int detailLevel = this.grid.getLevelForDistance(args.resolveDistErr(this.ctx, this.distErrPct));
        return new RecursivePrefixTreeFilter(this.getFieldName(), this.grid, shape, this.prefixGridScanLevel, detailLevel);
    }
}

