/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.util;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

public class TruncateFilter
extends TokenFilter {
    private final int maxTokenLength;
    private final CharTermAttribute termAttr = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);

    public TruncateFilter(TokenStream in, int maxTokenLength) {
        super(in);
        this.maxTokenLength = maxTokenLength;
    }

    public final boolean incrementToken() throws IOException {
        if (!this.input.incrementToken()) {
            return false;
        }
        if (this.termAttr.length() > this.maxTokenLength) {
            this.termAttr.setLength(this.maxTokenLength);
        }
        return true;
    }
}

