/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.util;

import com.spatial4j.core.distance.DistanceCalculator;
import com.spatial4j.core.shape.Point;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.spatial.util.ShapeFieldCache;
import org.apache.lucene.spatial.util.ShapeFieldCacheProvider;

public class CachedDistanceValueSource
extends ValueSource {
    private final ShapeFieldCacheProvider<Point> provider;
    private final DistanceCalculator calculator;
    private final Point from;

    public CachedDistanceValueSource(Point from, DistanceCalculator calc, ShapeFieldCacheProvider<Point> provider) {
        this.from = from;
        this.provider = provider;
        this.calculator = calc;
    }

    public String description() {
        return "DistanceValueSource(" + this.calculator + ")";
    }

    public FunctionValues getValues(Map context, AtomicReaderContext readerContext) throws IOException {
        final ShapeFieldCache<Point> cache = this.provider.getCache(readerContext.reader());
        return new FunctionValues(){

            public float floatVal(int doc) {
                return (float)this.doubleVal(doc);
            }

            public double doubleVal(int doc) {
                List vals = cache.getShapes(doc);
                if (vals != null) {
                    double v = CachedDistanceValueSource.this.calculator.distance(CachedDistanceValueSource.this.from, (Point)vals.get(0));
                    for (int i = 1; i < vals.size(); ++i) {
                        v = Math.min(v, CachedDistanceValueSource.this.calculator.distance(CachedDistanceValueSource.this.from, (Point)vals.get(i)));
                    }
                    return v;
                }
                return Double.NaN;
            }

            public String toString(int doc) {
                return CachedDistanceValueSource.this.description() + "=" + this.floatVal(doc);
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        CachedDistanceValueSource that = (CachedDistanceValueSource)((Object)o);
        if (this.calculator != null ? !this.calculator.equals(that.calculator) : that.calculator != null) {
            return false;
        }
        return !(this.from != null ? !this.from.equals(that.from) : that.from != null);
    }

    public int hashCode() {
        int result = this.calculator != null ? this.calculator.hashCode() : 0;
        result = 31 * result + (this.from != null ? this.from.hashCode() : 0);
        return result;
    }
}

