/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.prefix;

import com.spatial4j.core.distance.DistanceCalculator;
import com.spatial4j.core.query.SpatialArgs;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Shape;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.spatial.SimpleSpatialFieldInfo;
import org.apache.lucene.spatial.SpatialStrategy;
import org.apache.lucene.spatial.prefix.PointPrefixTreeFieldCacheProvider;
import org.apache.lucene.spatial.prefix.tree.Node;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.lucene.spatial.util.CachedDistanceValueSource;

public abstract class PrefixTreeStrategy
extends SpatialStrategy<SimpleSpatialFieldInfo> {
    protected final SpatialPrefixTree grid;
    private final Map<String, PointPrefixTreeFieldCacheProvider> provider = new ConcurrentHashMap<String, PointPrefixTreeFieldCacheProvider>();
    protected int defaultFieldValuesArrayLen = 2;
    protected double distErrPct = 0.025;
    public static final FieldType TYPE_NOT_STORED = new FieldType();
    public static final FieldType TYPE_STORED = new FieldType();

    public PrefixTreeStrategy(SpatialPrefixTree grid) {
        super(grid.getSpatialContext());
        this.grid = grid;
    }

    public void setDefaultFieldValuesArrayLen(int defaultFieldValuesArrayLen) {
        this.defaultFieldValuesArrayLen = defaultFieldValuesArrayLen;
    }

    public void setDistErrPct(double distErrPct) {
        this.distErrPct = distErrPct;
    }

    @Override
    public IndexableField createField(SimpleSpatialFieldInfo fieldInfo, Shape shape, boolean index, boolean store) {
        int detailLevel = this.grid.getMaxLevelForPrecision(shape, this.distErrPct);
        List<Node> cells = this.grid.getNodes(shape, detailLevel, true);
        if (!(shape instanceof Point)) {
            Point ctr = shape.getCenter();
            cells.add(this.grid.getNodes((Shape)ctr, this.grid.getMaxLevels(), false).get(0));
        }
        String fname = fieldInfo.getFieldName();
        if (store) {
            String wkt = this.grid.getSpatialContext().toString(shape);
            if (index) {
                Field f = new Field(fname, wkt, TYPE_STORED);
                f.setTokenStream((TokenStream)new CellTokenStream(cells.iterator()));
                return f;
            }
            return new StoredField(fname, wkt);
        }
        if (index) {
            return new Field(fname, (TokenStream)new CellTokenStream(cells.iterator()), TYPE_NOT_STORED);
        }
        throw new UnsupportedOperationException("Fields need to be indexed or store [" + fname + "]");
    }

    @Override
    public ValueSource makeValueSource(SpatialArgs args, SimpleSpatialFieldInfo fieldInfo) {
        DistanceCalculator calc = this.grid.getSpatialContext().getDistCalc();
        return this.makeValueSource(args, fieldInfo, calc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueSource makeValueSource(SpatialArgs args, SimpleSpatialFieldInfo fieldInfo, DistanceCalculator calc) {
        PointPrefixTreeFieldCacheProvider p = this.provider.get(fieldInfo.getFieldName());
        if (p == null) {
            PrefixTreeStrategy prefixTreeStrategy = this;
            synchronized (prefixTreeStrategy) {
                p = this.provider.get(fieldInfo.getFieldName());
                if (p == null) {
                    p = new PointPrefixTreeFieldCacheProvider(this.grid, fieldInfo.getFieldName(), this.defaultFieldValuesArrayLen);
                    this.provider.put(fieldInfo.getFieldName(), p);
                }
            }
        }
        Point point = args.getShape().getCenter();
        return new CachedDistanceValueSource(point, calc, p);
    }

    public SpatialPrefixTree getGrid() {
        return this.grid;
    }

    static {
        TYPE_NOT_STORED.setIndexed(true);
        TYPE_NOT_STORED.setTokenized(true);
        TYPE_NOT_STORED.setOmitNorms(true);
        TYPE_NOT_STORED.freeze();
        TYPE_STORED.setStored(true);
        TYPE_STORED.setIndexed(true);
        TYPE_STORED.setTokenized(true);
        TYPE_STORED.setOmitNorms(true);
        TYPE_STORED.freeze();
    }

    static final class CellTokenStream
    extends TokenStream {
        private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
        private Iterator<Node> iter = null;
        CharSequence nextTokenStringNeedingLeaf = null;

        public CellTokenStream(Iterator<Node> tokens) {
            this.iter = tokens;
        }

        public boolean incrementToken() throws IOException {
            this.clearAttributes();
            if (this.nextTokenStringNeedingLeaf != null) {
                this.termAtt.append(this.nextTokenStringNeedingLeaf);
                this.termAtt.append('+');
                this.nextTokenStringNeedingLeaf = null;
                return true;
            }
            if (this.iter.hasNext()) {
                Node cell = this.iter.next();
                String token = cell.getTokenString();
                this.termAtt.append((CharSequence)token);
                if (cell.isLeaf()) {
                    this.nextTokenStringNeedingLeaf = token;
                }
                return true;
            }
            return false;
        }
    }
}

