/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.Filter;

public class TermsFilter
extends Filter {
    ArrayList termsList = new ArrayList();

    public void addTerm(Term term) {
        this.termsList.add(term);
    }

    public BitSet bits(IndexReader reader) throws IOException {
        BitSet result = new BitSet(reader.maxDoc());
        Iterator iter = this.termsList.iterator();
        while (iter.hasNext()) {
            Term term = (Term)iter.next();
            TermDocs td = reader.termDocs(term);
            while (td.next()) {
                result.set(td.doc());
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        TermsFilter test = (TermsFilter)((Object)obj);
        return this.termsList == test.termsList || this.termsList != null && this.termsList.equals(test.termsList);
    }

    public int hashCode() {
        int hash = 9;
        Iterator iter = this.termsList.iterator();
        while (iter.hasNext()) {
            Term term = (Term)iter.next();
            hash = 31 * hash + term.hashCode();
        }
        return hash;
    }
}

