/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ja;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ja.tokenattributes.ReadingAttribute;
import org.apache.lucene.analysis.ja.util.ToStringUtil;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

public final class JapaneseReadingFormFilter
extends TokenFilter {
    private final CharTermAttribute termAttr = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final ReadingAttribute readingAttr = (ReadingAttribute)this.addAttribute(ReadingAttribute.class);
    private boolean useRomaji;

    public JapaneseReadingFormFilter(TokenStream input, boolean useRomaji) {
        super(input);
        this.useRomaji = useRomaji;
    }

    public JapaneseReadingFormFilter(TokenStream input) {
        this(input, false);
    }

    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            String reading = this.readingAttr.getReading();
            if (reading != null) {
                if (this.useRomaji) {
                    ToStringUtil.getRomanization((Appendable)this.termAttr.setEmpty(), reading);
                } else {
                    this.termAttr.setEmpty().append(reading);
                }
            }
            return true;
        }
        return false;
    }
}

