/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.blockterms;

import java.io.Closeable;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.blockterms.TermsIndexReaderBase;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.PagedBytes;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.PackedInts;

public class FixedGapTermsIndexReader
extends TermsIndexReaderBase {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(FixedGapTermsIndexReader.class);
    private long totalIndexInterval;
    private int indexDivisor;
    private final int indexInterval;
    private IndexInput in;
    private volatile boolean indexLoaded;
    private final Comparator<BytesRef> termComp;
    private static final int PAGED_BYTES_BITS = 15;
    private final PagedBytes.Reader termBytesReader;
    final HashMap<FieldInfo, FieldIndexData> fields;
    private long dirOffset;
    private final int version;
    private static final long FIELD_INDEX_DATA_BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(FieldIndexData.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FixedGapTermsIndexReader(Directory dir, FieldInfos fieldInfos, String segment, int indexDivisor, Comparator<BytesRef> termComp, String segmentSuffix, IOContext context) throws IOException {
        boolean success;
        PagedBytes termBytes;
        block17: {
            this.fields = new HashMap();
            this.termComp = termComp;
            assert (indexDivisor == -1 || indexDivisor > 0);
            this.in = dir.openInput(IndexFileNames.segmentFileName((String)segment, (String)segmentSuffix, (String)"tii"), context);
            termBytes = new PagedBytes(15);
            success = false;
            try {
                this.version = this.readHeader(this.in);
                if (this.version >= 1000) {
                    CodecUtil.checksumEntireFile((IndexInput)this.in);
                }
                this.indexInterval = this.in.readInt();
                if (this.indexInterval < 1) {
                    throw new CorruptIndexException("invalid indexInterval: " + this.indexInterval + " (resource=" + this.in + ")");
                }
                this.indexDivisor = indexDivisor;
                this.totalIndexInterval = indexDivisor < 0 ? (long)this.indexInterval : (long)(this.indexInterval * indexDivisor);
                assert (this.totalIndexInterval > 0L);
                this.seekDir(this.in, this.dirOffset);
                int numFields = this.in.readVInt();
                if (numFields < 0) {
                    throw new CorruptIndexException("invalid numFields: " + numFields + " (resource=" + this.in + ")");
                }
                for (int i = 0; i < numFields; ++i) {
                    int field = this.in.readVInt();
                    int numIndexTerms = this.in.readVInt();
                    if (numIndexTerms < 0) {
                        throw new CorruptIndexException("invalid numIndexTerms: " + numIndexTerms + " (resource=" + this.in + ")");
                    }
                    long termsStart = this.in.readVLong();
                    long indexStart = this.in.readVLong();
                    long packedIndexStart = this.in.readVLong();
                    long packedOffsetsStart = this.in.readVLong();
                    if (packedIndexStart < indexStart) {
                        throw new CorruptIndexException("invalid packedIndexStart: " + packedIndexStart + " indexStart: " + indexStart + "numIndexTerms: " + numIndexTerms + " (resource=" + this.in + ")");
                    }
                    FieldInfo fieldInfo = fieldInfos.fieldInfo(field);
                    FieldIndexData previous = this.fields.put(fieldInfo, new FieldIndexData(fieldInfo, termBytes, numIndexTerms, indexStart, termsStart, packedIndexStart, packedOffsetsStart));
                    if (previous == null) continue;
                    throw new CorruptIndexException("duplicate field: " + fieldInfo.name + " (resource=" + this.in + ")");
                }
                success = true;
                if (success) break block17;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.in});
                }
                if (indexDivisor > 0) {
                    this.in.close();
                    this.in = null;
                    if (success) {
                        this.indexLoaded = true;
                    }
                    this.termBytesReader = termBytes.freeze(true);
                } else {
                    this.termBytesReader = null;
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.in});
        }
        if (indexDivisor > 0) {
            this.in.close();
            this.in = null;
            if (success) {
                this.indexLoaded = true;
            }
            this.termBytesReader = termBytes.freeze(true);
        } else {
            this.termBytesReader = null;
        }
    }

    @Override
    public int getDivisor() {
        return this.indexDivisor;
    }

    private int readHeader(IndexInput input) throws IOException {
        int version = CodecUtil.checkHeader((DataInput)input, (String)"SIMPLE_STANDARD_TERMS_INDEX", (int)0, (int)1000);
        if (version < 1) {
            this.dirOffset = input.readLong();
        }
        return version;
    }

    @Override
    public boolean supportsOrd() {
        return true;
    }

    @Override
    public TermsIndexReaderBase.FieldIndexEnum getFieldEnum(FieldInfo fieldInfo) {
        FieldIndexData fieldData = this.fields.get(fieldInfo);
        if (fieldData.coreIndex == null) {
            return null;
        }
        return new IndexEnum(fieldData.coreIndex);
    }

    @Override
    public void close() throws IOException {
        if (this.in != null && !this.indexLoaded) {
            this.in.close();
        }
    }

    private void seekDir(IndexInput input, long dirOffset) throws IOException {
        if (this.version >= 1000) {
            input.seek(input.length() - (long)CodecUtil.footerLength() - 8L);
            dirOffset = input.readLong();
        } else if (this.version >= 1) {
            input.seek(input.length() - 8L);
            dirOffset = input.readLong();
        }
        input.seek(dirOffset);
    }

    public long ramBytesUsed() {
        long sizeInBytes = BASE_RAM_BYTES_USED + (long)this.fields.size() * 2L * (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF + (this.termBytesReader != null ? this.termBytesReader.ramBytesUsed() : 0L);
        for (FieldIndexData entry : this.fields.values()) {
            sizeInBytes += entry.ramBytesUsed();
        }
        return sizeInBytes;
    }

    private final class FieldIndexData
    implements Accountable {
        volatile CoreFieldIndex coreIndex;
        private final long indexStart;
        private final long termsStart;
        private final long packedIndexStart;
        private final long packedOffsetsStart;
        private final int numIndexTerms;

        public FieldIndexData(FieldInfo fieldInfo, PagedBytes termBytes, int numIndexTerms, long indexStart, long termsStart, long packedIndexStart, long packedOffsetsStart) throws IOException {
            this.termsStart = termsStart;
            this.indexStart = indexStart;
            this.packedIndexStart = packedIndexStart;
            this.packedOffsetsStart = packedOffsetsStart;
            this.numIndexTerms = numIndexTerms;
            if (FixedGapTermsIndexReader.this.indexDivisor > 0) {
                this.loadTermsIndex(termBytes);
            }
        }

        public long ramBytesUsed() {
            return FIELD_INDEX_DATA_BASE_RAM_BYTES_USED + this.coreIndex.ramBytesUsed();
        }

        private void loadTermsIndex(PagedBytes termBytes) throws IOException {
            if (this.coreIndex == null) {
                this.coreIndex = new CoreFieldIndex(termBytes, this.indexStart, this.termsStart, this.packedIndexStart, this.packedOffsetsStart, this.numIndexTerms);
            }
        }

        private final class CoreFieldIndex
        implements Accountable {
            final long termBytesStart;
            final PackedInts.Reader termOffsets;
            final PackedInts.Reader termsDictOffsets;
            final int numIndexTerms;
            final long termsStart;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public CoreFieldIndex(PagedBytes termBytes, long indexStart, long termsStart, long packedIndexStart, long packedOffsetsStart, int numIndexTerms) throws IOException {
                block15: {
                    this.termsStart = termsStart;
                    this.termBytesStart = termBytes.getPointer();
                    IndexInput clone = FixedGapTermsIndexReader.this.in.clone();
                    clone.seek(indexStart);
                    assert (FixedGapTermsIndexReader.this.indexDivisor > 0);
                    this.numIndexTerms = 1 + (numIndexTerms - 1) / FixedGapTermsIndexReader.this.indexDivisor;
                    assert (this.numIndexTerms > 0) : "numIndexTerms=" + numIndexTerms + " indexDivisor=" + FixedGapTermsIndexReader.access$300(fieldIndexData.FixedGapTermsIndexReader.this);
                    if (FixedGapTermsIndexReader.this.indexDivisor == 1) {
                        try {
                            long numTermBytes = packedIndexStart - indexStart;
                            termBytes.copy(clone, numTermBytes);
                            this.termsDictOffsets = PackedInts.getReader((DataInput)clone);
                            assert (this.termsDictOffsets.size() == numIndexTerms);
                            this.termOffsets = PackedInts.getReader((DataInput)clone);
                            assert (this.termOffsets.size() == 1 + numIndexTerms);
                            break block15;
                        }
                        finally {
                            clone.close();
                        }
                    }
                    IndexInput clone1 = FixedGapTermsIndexReader.this.in.clone();
                    IndexInput clone2 = FixedGapTermsIndexReader.this.in.clone();
                    try {
                        clone1.seek(packedIndexStart);
                        PackedInts.ReaderIterator termsDictOffsetsIter = PackedInts.getReaderIterator((DataInput)clone1, (int)1024);
                        clone2.seek(packedOffsetsStart);
                        PackedInts.ReaderIterator termOffsetsIter = PackedInts.getReaderIterator((DataInput)clone2, (int)1024);
                        PackedInts.Mutable termsDictOffsetsM = PackedInts.getMutable((int)this.numIndexTerms, (int)termsDictOffsetsIter.getBitsPerValue(), (float)0.25f);
                        PackedInts.Mutable termOffsetsM = PackedInts.getMutable((int)(this.numIndexTerms + 1), (int)termOffsetsIter.getBitsPerValue(), (float)0.25f);
                        this.termsDictOffsets = termsDictOffsetsM;
                        this.termOffsets = termOffsetsM;
                        int upto = 0;
                        long termOffsetUpto = 0L;
                        while (upto < this.numIndexTerms) {
                            termsDictOffsetsM.set(upto, termsDictOffsetsIter.next());
                            termOffsetsM.set(upto, termOffsetUpto);
                            long termOffset = termOffsetsIter.next();
                            long nextTermOffset = termOffsetsIter.next();
                            int numTermBytes = (int)(nextTermOffset - termOffset);
                            clone.seek(indexStart + termOffset);
                            assert (indexStart + termOffset < clone.length()) : "indexStart=" + indexStart + " termOffset=" + termOffset + " len=" + clone.length();
                            assert (indexStart + termOffset + (long)numTermBytes < clone.length());
                            termBytes.copy(clone, (long)numTermBytes);
                            termOffsetUpto += (long)numTermBytes;
                            if (++upto == this.numIndexTerms) break;
                            termsDictOffsetsIter.next();
                            for (int i = 0; i < FixedGapTermsIndexReader.this.indexDivisor - 2; ++i) {
                                termOffsetsIter.next();
                                termsDictOffsetsIter.next();
                            }
                        }
                        termOffsetsM.set(upto, termOffsetUpto);
                    }
                    finally {
                        clone1.close();
                        clone2.close();
                        clone.close();
                    }
                }
            }

            public long ramBytesUsed() {
                return (this.termOffsets != null ? this.termOffsets.ramBytesUsed() : 0L) + (this.termsDictOffsets != null ? this.termsDictOffsets.ramBytesUsed() : 0L);
            }
        }
    }

    private class IndexEnum
    extends TermsIndexReaderBase.FieldIndexEnum {
        private final FieldIndexData.CoreFieldIndex fieldIndex;
        private final BytesRef term = new BytesRef();
        private long ord;

        public IndexEnum(FieldIndexData.CoreFieldIndex fieldIndex) {
            this.fieldIndex = fieldIndex;
        }

        @Override
        public BytesRef term() {
            return this.term;
        }

        @Override
        public long seek(BytesRef target) {
            int lo = 0;
            int hi = this.fieldIndex.numIndexTerms - 1;
            assert (FixedGapTermsIndexReader.this.totalIndexInterval > 0L) : "totalIndexInterval=" + FixedGapTermsIndexReader.access$000(FixedGapTermsIndexReader.this);
            while (hi >= lo) {
                int mid = lo + hi >>> 1;
                long offset = this.fieldIndex.termOffsets.get(mid);
                int length = (int)(this.fieldIndex.termOffsets.get(1 + mid) - offset);
                FixedGapTermsIndexReader.this.termBytesReader.fillSlice(this.term, this.fieldIndex.termBytesStart + offset, length);
                int delta = FixedGapTermsIndexReader.this.termComp.compare(target, this.term);
                if (delta < 0) {
                    hi = mid - 1;
                    continue;
                }
                if (delta > 0) {
                    lo = mid + 1;
                    continue;
                }
                assert (mid >= 0);
                this.ord = (long)mid * FixedGapTermsIndexReader.this.totalIndexInterval;
                return this.fieldIndex.termsStart + this.fieldIndex.termsDictOffsets.get(mid);
            }
            if (hi < 0) {
                assert (hi == -1);
                hi = 0;
            }
            long offset = this.fieldIndex.termOffsets.get(hi);
            int length = (int)(this.fieldIndex.termOffsets.get(1 + hi) - offset);
            FixedGapTermsIndexReader.this.termBytesReader.fillSlice(this.term, this.fieldIndex.termBytesStart + offset, length);
            this.ord = (long)hi * FixedGapTermsIndexReader.this.totalIndexInterval;
            return this.fieldIndex.termsStart + this.fieldIndex.termsDictOffsets.get(hi);
        }

        @Override
        public long next() {
            int idx = 1 + (int)(this.ord / FixedGapTermsIndexReader.this.totalIndexInterval);
            if (idx >= this.fieldIndex.numIndexTerms) {
                return -1L;
            }
            this.ord += FixedGapTermsIndexReader.this.totalIndexInterval;
            long offset = this.fieldIndex.termOffsets.get(idx);
            int length = (int)(this.fieldIndex.termOffsets.get(1 + idx) - offset);
            FixedGapTermsIndexReader.this.termBytesReader.fillSlice(this.term, this.fieldIndex.termBytesStart + offset, length);
            return this.fieldIndex.termsStart + this.fieldIndex.termsDictOffsets.get(idx);
        }

        @Override
        public long ord() {
            return this.ord;
        }

        @Override
        public long seek(long ord) {
            int idx = (int)(ord / FixedGapTermsIndexReader.this.totalIndexInterval);
            assert (idx < this.fieldIndex.numIndexTerms);
            long offset = this.fieldIndex.termOffsets.get(idx);
            int length = (int)(this.fieldIndex.termOffsets.get(1 + idx) - offset);
            FixedGapTermsIndexReader.this.termBytesReader.fillSlice(this.term, this.fieldIndex.termBytesStart + offset, length);
            this.ord = (long)idx * FixedGapTermsIndexReader.this.totalIndexInterval;
            return this.fieldIndex.termsStart + this.fieldIndex.termsDictOffsets.get(idx);
        }
    }
}

